/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.mqtt.handler;

import io.micrometer.core.instrument.Timer;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.mqtt.MqttMessage;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.bifromq.base.util.AsyncRetry;
import org.apache.bifromq.basehlc.HLC;
import org.apache.bifromq.inbox.client.IInboxClient;
import org.apache.bifromq.inbox.rpc.proto.CommitRequest;
import org.apache.bifromq.inbox.rpc.proto.DetachReply;
import org.apache.bifromq.inbox.rpc.proto.DetachRequest;
import org.apache.bifromq.inbox.rpc.proto.SubRequest;
import org.apache.bifromq.inbox.rpc.proto.UnsubRequest;
import org.apache.bifromq.inbox.storage.proto.Fetched;
import org.apache.bifromq.inbox.storage.proto.InboxMessage;
import org.apache.bifromq.inbox.storage.proto.InboxVersion;
import org.apache.bifromq.inbox.storage.proto.LWT;
import org.apache.bifromq.inbox.util.InboxServiceUtil;
import org.apache.bifromq.metrics.ITenantMeter;
import org.apache.bifromq.metrics.TenantMetric;
import org.apache.bifromq.mqtt.handler.DedupCache;
import org.apache.bifromq.mqtt.handler.IMQTTProtocolHelper;
import org.apache.bifromq.mqtt.handler.MQTTSessionHandler;
import org.apache.bifromq.mqtt.handler.RoutedMessage;
import org.apache.bifromq.mqtt.handler.TenantSettings;
import org.apache.bifromq.mqtt.handler.condition.Condition;
import org.apache.bifromq.mqtt.handler.record.ProtocolResponse;
import org.apache.bifromq.mqtt.session.IMQTTPersistentSession;
import org.apache.bifromq.mqtt.utils.AuthUtil;
import org.apache.bifromq.plugin.eventcollector.Event;
import org.apache.bifromq.plugin.eventcollector.OutOfTenantResource;
import org.apache.bifromq.plugin.eventcollector.ThreadLocalEventPool;
import org.apache.bifromq.plugin.eventcollector.mqttbroker.clientdisconnect.ByClient;
import org.apache.bifromq.plugin.resourcethrottler.TenantResourceType;
import org.apache.bifromq.retain.rpc.proto.MatchReply;
import org.apache.bifromq.retain.rpc.proto.MatchRequest;
import org.apache.bifromq.sysprops.props.DataPlaneMaxBurstLatencyMillis;
import org.apache.bifromq.sysprops.props.MaxActiveDedupChannels;
import org.apache.bifromq.sysprops.props.MaxActiveDedupTopicsPerChannel;
import org.apache.bifromq.type.ClientInfo;
import org.apache.bifromq.type.MatchInfo;
import org.apache.bifromq.type.Message;
import org.apache.bifromq.type.QoS;
import org.apache.bifromq.type.TopicFilterOption;
import org.apache.bifromq.type.TopicMessage;
import org.apache.bifromq.util.TopicUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MQTTPersistentSessionHandler
extends MQTTSessionHandler
implements IMQTTPersistentSession {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MQTTPersistentSessionHandler.class);
    private final int sessionExpirySeconds;
    private final InboxVersion inboxVersion;
    private final NavigableMap<Long, StagingMessage> stagingBuffer = new TreeMap<Long, StagingMessage>();
    private final IInboxClient inboxClient;
    private final DedupCache qoS0DedupCache = new DedupCache(2L * (Long)DataPlaneMaxBurstLatencyMillis.INSTANCE.get(), ((Integer)MaxActiveDedupChannels.INSTANCE.get()).intValue(), ((Integer)MaxActiveDedupTopicsPerChannel.INSTANCE.get()).intValue());
    private final DedupCache qoS12DedupCache = new DedupCache(2L * (Long)DataPlaneMaxBurstLatencyMillis.INSTANCE.get(), ((Integer)MaxActiveDedupChannels.INSTANCE.get()).intValue(), ((Integer)MaxActiveDedupTopicsPerChannel.INSTANCE.get()).intValue());
    private boolean qos0Confirming = false;
    private boolean inboxConfirming = false;
    private long nextSendSeq = 0L;
    private long qos0ConfirmUpToSeq;
    private long inboxConfirmedUpToSeq = -1L;
    private IInboxClient.IInboxReader inboxReader;
    private State state = State.INIT;
    private ScheduledFuture<?> confirmTimeout;
    private ScheduledFuture<?> hintTimeout;

    protected MQTTPersistentSessionHandler(TenantSettings settings, ITenantMeter tenantMeter, Condition oomCondition, String userSessionId, int keepAliveTimeSeconds, int sessionExpirySeconds, ClientInfo clientInfo, InboxVersion inboxVersion, LWT noDelayLWT, ChannelHandlerContext ctx) {
        super(settings, tenantMeter, oomCondition, userSessionId, keepAliveTimeSeconds, clientInfo, noDelayLWT, ctx);
        this.inboxVersion = inboxVersion;
        this.inboxClient = this.sessionCtx.inboxClient;
        this.sessionExpirySeconds = sessionExpirySeconds;
    }

    @Override
    protected void doOnServerShuttingDown() {
        if (this.state == State.ATTACHED) {
            this.state = State.SERVER_SHUTTING_DOWN;
        }
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) {
        super.handlerAdded(ctx);
        if (this.inboxVersion.getMod() == 0L) {
            if (!this.resourceThrottler.hasResource(this.clientInfo.getTenantId(), TenantResourceType.TotalPersistentSessions)) {
                this.handleProtocolResponse(this.helper().onResourceExhaustedDisconnect(TenantResourceType.TotalPersistentSessions));
                return;
            }
            if (!this.resourceThrottler.hasResource(this.clientInfo.getTenantId(), TenantResourceType.TotalPersistentSessionSpaceBytes)) {
                this.handleProtocolResponse(this.helper().onResourceExhaustedDisconnect(TenantResourceType.TotalPersistentSessionSpaceBytes));
                return;
            }
        }
        this.setupInboxReader();
    }

    @Override
    public void doTearDown(ChannelHandlerContext ctx) {
        int remainInboxSize;
        this.cancelScheduledHint();
        if (this.inboxReader != null) {
            this.inboxReader.close();
        }
        if ((remainInboxSize = this.stagingBuffer.values().stream().reduce(0, (acc, msg) -> acc + msg.message.estBytes(), Integer::sum).intValue()) > 0) {
            this.memUsage.addAndGet(-remainInboxSize);
        }
        switch (this.state) {
            case ATTACHED: {
                this.detach(DetachRequest.newBuilder().setReqId(System.nanoTime()).setInboxId(this.userSessionId).setVersion(this.inboxVersion).setExpirySeconds(this.sessionExpirySeconds).setDiscardLWT(false).setClient(this.clientInfo).setNow(HLC.INST.getPhysical()).build());
                break;
            }
            case SERVER_SHUTTING_DOWN: {
                this.detach(DetachRequest.newBuilder().setReqId(System.nanoTime()).setInboxId(this.userSessionId).setVersion(this.inboxVersion).setExpirySeconds(this.sessionExpirySeconds).setDiscardLWT(true).setClient(this.clientInfo).setNow(HLC.INST.getPhysical()).build());
                break;
            }
        }
    }

    @Override
    protected final ProtocolResponse handleDisconnect(MqttMessage message) {
        int finalSEI;
        if (this.state == State.SERVER_SHUTTING_DOWN) {
            return ProtocolResponse.responseNothing(new Event[0]);
        }
        int requestSEI = this.helper().sessionExpiryIntervalOnDisconnect(message).orElse(this.sessionExpirySeconds);
        int n = finalSEI = Integer.compareUnsigned(requestSEI, this.settings.maxSEI) < 0 ? requestSEI : this.settings.maxSEI;
        if (this.helper().isNormalDisconnect(message)) {
            this.discardLWT();
            if (finalSEI == 0) {
                this.detach(DetachRequest.newBuilder().setReqId(System.nanoTime()).setInboxId(this.userSessionId).setVersion(this.inboxVersion).setExpirySeconds(0).setDiscardLWT(true).setClient(this.clientInfo).setNow(HLC.INST.getPhysical()).build());
            } else {
                this.detach(DetachRequest.newBuilder().setReqId(System.nanoTime()).setInboxId(this.userSessionId).setVersion(this.inboxVersion).setExpirySeconds(finalSEI).setDiscardLWT(true).setClient(this.clientInfo).setNow(HLC.INST.getPhysical()).build());
            }
        } else if (this.helper().isDisconnectWithLWT(message)) {
            this.detach(DetachRequest.newBuilder().setReqId(System.nanoTime()).setInboxId(this.userSessionId).setVersion(this.inboxVersion).setExpirySeconds(finalSEI).setDiscardLWT(false).setClient(this.clientInfo).setNow(HLC.INST.getPhysical()).build());
        }
        return ProtocolResponse.goAwayNow(new Event[]{((ByClient)ThreadLocalEventPool.getLocal(ByClient.class)).clientInfo(this.clientInfo)});
    }

    private void detach(DetachRequest request) {
        if (this.state != State.ATTACHED && this.state != State.SERVER_SHUTTING_DOWN) {
            return;
        }
        this.state = State.DETACH;
        this.addBgTask(AsyncRetry.exec(() -> this.inboxClient.detach(request), (reply, t) -> {
            if (reply != null) {
                return reply.getCode() == DetachReply.Code.TRY_LATER;
            }
            return false;
        }, (long)(this.sessionCtx.retryTimeoutNanos / 5L), (long)this.sessionCtx.retryTimeoutNanos));
    }

    @Override
    protected final CompletableFuture<IMQTTProtocolHelper.SubResult> subTopicFilter(long reqId, String topicFilter, TopicFilterOption option) {
        if (!this.resourceThrottler.hasResource(this.clientInfo.getTenantId(), TenantResourceType.TotalPersistentSubscriptions)) {
            this.eventCollector.report((Event)((OutOfTenantResource)ThreadLocalEventPool.getLocal(OutOfTenantResource.class)).reason(TenantResourceType.TotalPersistentSubscriptions.name()).clientInfo(this.clientInfo));
            return CompletableFuture.completedFuture(IMQTTProtocolHelper.SubResult.EXCEED_LIMIT);
        }
        if (!this.resourceThrottler.hasResource(this.clientInfo.getTenantId(), TenantResourceType.TotalPersistentSubscribePerSecond)) {
            this.eventCollector.report((Event)((OutOfTenantResource)ThreadLocalEventPool.getLocal(OutOfTenantResource.class)).reason(TenantResourceType.TotalPersistentSubscribePerSecond.name()).clientInfo(this.clientInfo));
            return CompletableFuture.completedFuture(IMQTTProtocolHelper.SubResult.EXCEED_LIMIT);
        }
        this.tenantMeter.recordCount(TenantMetric.MqttPersistentSubCount);
        Timer.Sample start = Timer.start();
        return this.inboxClient.sub(SubRequest.newBuilder().setReqId(reqId).setTenantId(this.clientInfo.getTenantId()).setInboxId(this.userSessionId).setVersion(this.inboxVersion).setTopicFilter(topicFilter).setMaxTopicFilters(this.settings.maxTopicFiltersPerInbox).setOption(option).setNow(HLC.INST.getPhysical()).build()).thenApplyAsync(v -> {
            switch (v.getCode()) {
                case OK: {
                    start.stop(this.tenantMeter.timer(TenantMetric.MqttPersistentSubLatency));
                    return IMQTTProtocolHelper.SubResult.OK;
                }
                case EXISTS: {
                    start.stop(this.tenantMeter.timer(TenantMetric.MqttPersistentSubLatency));
                    return IMQTTProtocolHelper.SubResult.EXISTS;
                }
                case EXCEED_LIMIT: {
                    return IMQTTProtocolHelper.SubResult.EXCEED_LIMIT;
                }
                case NO_INBOX: 
                case CONFLICT: {
                    this.state = State.TERMINATE;
                    this.handleProtocolResponse(this.helper().onInboxTransientError(v.getCode().name()));
                    break;
                }
                case BACK_PRESSURE_REJECTED: {
                    return IMQTTProtocolHelper.SubResult.BACK_PRESSURE_REJECTED;
                }
                case TRY_LATER: {
                    return IMQTTProtocolHelper.SubResult.TRY_LATER;
                }
                case ERROR: {
                    return IMQTTProtocolHelper.SubResult.ERROR;
                }
            }
            return IMQTTProtocolHelper.SubResult.ERROR;
        }, (Executor)this.ctx.executor());
    }

    @Override
    protected CompletableFuture<MatchReply> matchRetainedMessage(long reqId, String topicFilter, TopicFilterOption option) {
        String tenantId = this.clientInfo().getTenantId();
        return this.sessionCtx.retainClient.match(MatchRequest.newBuilder().setReqId(reqId).setTenantId(tenantId).setMatchInfo(MatchInfo.newBuilder().setMatcher(TopicUtil.from((String)topicFilter)).setReceiverId(InboxServiceUtil.receiverId((String)this.userSessionId, (long)this.inboxVersion.getIncarnation())).setIncarnation(option.getIncarnation()).build()).setDelivererKey(InboxServiceUtil.getDelivererKey((String)tenantId, (String)this.userSessionId)).setBrokerId(this.inboxClient.id()).setLimit(this.settings.retainMatchLimit).build());
    }

    @Override
    protected final CompletableFuture<IMQTTProtocolHelper.UnsubResult> unsubTopicFilter(long reqId, String topicFilter) {
        if (!this.resourceThrottler.hasResource(this.clientInfo.getTenantId(), TenantResourceType.TotalPersistentUnsubscribePerSecond)) {
            this.eventCollector.report((Event)((OutOfTenantResource)ThreadLocalEventPool.getLocal(OutOfTenantResource.class)).reason(TenantResourceType.TotalPersistentUnsubscribePerSecond.name()).clientInfo(this.clientInfo));
            return CompletableFuture.completedFuture(IMQTTProtocolHelper.UnsubResult.ERROR);
        }
        this.tenantMeter.recordCount(TenantMetric.MqttPersistentUnsubCount);
        Timer.Sample start = Timer.start();
        return this.inboxClient.unsub(UnsubRequest.newBuilder().setReqId(reqId).setTenantId(this.clientInfo.getTenantId()).setInboxId(this.userSessionId).setVersion(this.inboxVersion).setTopicFilter(topicFilter).setNow(HLC.INST.getPhysical()).build()).thenApplyAsync(v -> {
            switch (v.getCode()) {
                case OK: {
                    start.stop(this.tenantMeter.timer(TenantMetric.MqttPersistentUnsubLatency));
                    return IMQTTProtocolHelper.UnsubResult.OK;
                }
                case NO_SUB: {
                    start.stop(this.tenantMeter.timer(TenantMetric.MqttPersistentUnsubLatency));
                    return IMQTTProtocolHelper.UnsubResult.NO_SUB;
                }
                case NO_INBOX: 
                case CONFLICT: {
                    this.state = State.TERMINATE;
                    this.handleProtocolResponse(this.helper().onInboxTransientError(v.getCode().name()));
                    return IMQTTProtocolHelper.UnsubResult.ERROR;
                }
                case BACK_PRESSURE_REJECTED: {
                    return IMQTTProtocolHelper.UnsubResult.BACK_PRESSURE_REJECTED;
                }
                case TRY_LATER: {
                    return IMQTTProtocolHelper.UnsubResult.TRY_LATER;
                }
            }
            return IMQTTProtocolHelper.UnsubResult.ERROR;
        }, (Executor)this.ctx.executor());
    }

    private void setupInboxReader() {
        this.state = State.ATTACHED;
        if (!this.ctx.channel().isActive()) {
            return;
        }
        this.inboxReader = this.inboxClient.openInboxReader(this.clientInfo().getTenantId(), this.userSessionId, this.inboxVersion.getIncarnation());
        this.inboxReader.fetch(this::consume);
        this.inboxReader.hint(this.clientReceiveQuota());
        this.onInitialized();
        this.resumeChannelRead();
    }

    private void scheduleHintTimeout() {
        this.cancelScheduledHint();
        this.hintTimeout = this.ctx.executor().schedule(() -> {
            this.inboxReader.hint(this.clientReceiveQuota());
            this.hintTimeout = null;
        }, ThreadLocalRandom.current().nextLong(15L, 45L), TimeUnit.SECONDS);
    }

    private void cancelScheduledHint() {
        if (this.hintTimeout != null && !this.hintTimeout.isDone()) {
            this.hintTimeout.cancel(true);
            this.hintTimeout = null;
        }
    }

    private void scheduleConfirmTimeout(long upToSeq) {
        this.confirmTimeout = this.ctx.executor().schedule(() -> {
            if (upToSeq < this.inboxConfirmedUpToSeq) {
                this.confirmSendBuffer();
            }
        }, ThreadLocalRandom.current().nextLong(15L, 45L), TimeUnit.SECONDS);
    }

    private void confirmQoS0() {
        if (this.qos0Confirming) {
            return;
        }
        this.qos0Confirming = true;
        long upToSeq = this.qos0ConfirmUpToSeq;
        this.addBgTask(this.inboxClient.commit(CommitRequest.newBuilder().setReqId(HLC.INST.get()).setTenantId(this.clientInfo.getTenantId()).setInboxId(this.userSessionId).setVersion(this.inboxVersion).setQos0UpToSeq(upToSeq).setNow(HLC.INST.getPhysical()).build())).thenAcceptAsync(v -> {
            switch (v.getCode()) {
                case OK: {
                    this.qos0Confirming = false;
                    if (upToSeq >= this.qos0ConfirmUpToSeq) break;
                    this.confirmQoS0();
                    break;
                }
                case NO_INBOX: 
                case CONFLICT: {
                    this.state = State.TERMINATE;
                    this.handleProtocolResponse(this.helper().onInboxTransientError(v.getCode().name()));
                    break;
                }
                case BACK_PRESSURE_REJECTED: {
                    this.qos0Confirming = false;
                    break;
                }
                case TRY_LATER: {
                    this.qos0Confirming = false;
                    if (upToSeq >= this.qos0ConfirmUpToSeq) break;
                    this.confirmQoS0();
                    break;
                }
            }
        }, (Executor)this.ctx.executor());
    }

    @Override
    protected final void onConfirm(long seq) {
        NavigableMap<Long, StagingMessage> confirmedMsgs = this.stagingBuffer.headMap(seq, true);
        for (StagingMessage stagingMessage : confirmedMsgs.values()) {
            RoutedMessage confirmed = stagingMessage.message;
            this.memUsage.addAndGet(-confirmed.estBytes());
            if (!stagingMessage.batchEnd() || this.inboxConfirmedUpToSeq >= confirmed.inboxPos()) continue;
            this.inboxConfirmedUpToSeq = confirmed.inboxPos();
            this.confirmSendBuffer();
        }
        confirmedMsgs.clear();
        this.inboxReader.hint(this.clientReceiveQuota());
        this.ctx.executor().execute(this::drainStaging);
    }

    private void confirmSendBuffer() {
        if (this.confirmTimeout != null && !this.confirmTimeout.isCancelled()) {
            this.confirmTimeout.cancel(false);
        }
        if (this.inboxConfirming) {
            return;
        }
        this.inboxConfirming = true;
        long upToSeq = this.inboxConfirmedUpToSeq;
        this.addFgTask(this.inboxClient.commit(CommitRequest.newBuilder().setReqId(HLC.INST.get()).setTenantId(this.clientInfo.getTenantId()).setInboxId(this.userSessionId).setVersion(this.inboxVersion).setSendBufferUpToSeq(upToSeq).setNow(HLC.INST.getPhysical()).build())).thenAcceptAsync(v -> {
            switch (v.getCode()) {
                case OK: {
                    this.inboxConfirming = false;
                    if (upToSeq < this.inboxConfirmedUpToSeq) {
                        this.confirmSendBuffer();
                        break;
                    }
                    this.inboxReader.hint(this.clientReceiveQuota());
                    break;
                }
                case NO_INBOX: 
                case CONFLICT: {
                    this.handleProtocolResponse(this.helper().onInboxTransientError(v.getCode().name()));
                    break;
                }
                case BACK_PRESSURE_REJECTED: {
                    this.inboxConfirming = false;
                    if (upToSeq >= this.inboxConfirmedUpToSeq) break;
                    this.scheduleConfirmTimeout(upToSeq);
                    break;
                }
                case TRY_LATER: {
                    this.inboxConfirming = false;
                    if (upToSeq < this.inboxConfirmedUpToSeq) {
                        this.confirmSendBuffer();
                        break;
                    }
                    this.inboxReader.hint(this.clientReceiveQuota());
                    break;
                }
            }
        }, (Executor)this.ctx.executor());
    }

    private void consume(Fetched fetched) {
        this.ctx.executor().execute(() -> {
            switch (fetched.getResult()) {
                case OK: {
                    this.cancelScheduledHint();
                    if (fetched.getQos0MsgCount() > 0) {
                        fetched.getQos0MsgList().forEach(this::pubQoS0Message);
                        this.flush(true);
                        this.qos0ConfirmUpToSeq = fetched.getQos0Msg(fetched.getQos0MsgCount() - 1).getSeq();
                        this.confirmQoS0();
                    }
                    if (fetched.getSendBufferMsgCount() <= 0) break;
                    for (int i = 0; i < fetched.getSendBufferMsgCount(); ++i) {
                        InboxMessage inboxMessage = fetched.getSendBufferMsg(i);
                        this.pubBufferedMessage(inboxMessage, i + 1 == fetched.getSendBufferMsgCount());
                    }
                    break;
                }
                case BACK_PRESSURE_REJECTED: {
                    this.scheduleHintTimeout();
                    break;
                }
                case TRY_LATER: {
                    this.inboxReader.hint(this.clientReceiveQuota());
                    break;
                }
                case NO_INBOX: 
                case ERROR: {
                    this.handleProtocolResponse(this.helper().onInboxTransientError(fetched.getResult().name()));
                    break;
                }
            }
        });
    }

    private void pubQoS0Message(InboxMessage inboxMsg) {
        boolean isDup = this.isDuplicateMessage(inboxMsg.getMsg().getTopic(), inboxMsg.getMsg().getPublisher(), inboxMsg.getMsg().getMessage(), this.qoS0DedupCache);
        inboxMsg.getMatchedTopicFilterMap().forEach((topicFilter, option) -> this.pubQoS0Message((String)topicFilter, (TopicFilterOption)option, inboxMsg.getMsg(), isDup));
    }

    private void pubQoS0Message(String topicFilter, TopicFilterOption option, TopicMessage topicMsg, boolean isDup) {
        this.addFgTask(this.authProvider.checkPermission(this.clientInfo(), AuthUtil.buildSubAction(topicFilter, option.getQos()))).thenAccept(checkResult -> {
            String topic = topicMsg.getTopic();
            Message message = topicMsg.getMessage();
            ClientInfo publisher = topicMsg.getPublisher();
            long now = HLC.INST.get();
            this.tenantMeter.timer(TenantMetric.MqttQoS0InternalLatency).record(HLC.INST.getPhysical(now - message.getTimestamp()), TimeUnit.MILLISECONDS);
            this.sendQoS0SubMessage(new RoutedMessage(topic, message, publisher, topicFilter, option, now, checkResult.hasGranted(), isDup));
        });
    }

    private void pubBufferedMessage(InboxMessage inboxMsg, boolean batchEnd) {
        boolean isDup = this.isDuplicateMessage(inboxMsg.getMsg().getTopic(), inboxMsg.getMsg().getPublisher(), inboxMsg.getMsg().getMessage(), this.qoS12DedupCache);
        int i = 0;
        for (Map.Entry entry : inboxMsg.getMatchedTopicFilterMap().entrySet()) {
            String topicFilter = (String)entry.getKey();
            TopicFilterOption option = (TopicFilterOption)entry.getValue();
            long seq = inboxMsg.getSeq();
            this.pubBufferedMessage(topicFilter, option, seq + (long)i++, seq, inboxMsg.getMsg(), isDup, batchEnd);
        }
    }

    private void pubBufferedMessage(String topicFilter, TopicFilterOption option, long seq, long inboxSeq, TopicMessage topicMsg, boolean isDup, boolean batchEnd) {
        if (seq < this.nextSendSeq) {
            return;
        }
        this.addFgTask(this.authProvider.checkPermission(this.clientInfo(), AuthUtil.buildSubAction(topicFilter, option.getQos()))).thenAccept(checkResult -> {
            long now;
            ClientInfo publisher;
            Message message;
            String topic = topicMsg.getTopic();
            RoutedMessage msg = new RoutedMessage(topic, message = topicMsg.getMessage(), publisher = topicMsg.getPublisher(), topicFilter, option, now = HLC.INST.get(), checkResult.hasGranted(), isDup, inboxSeq);
            this.tenantMeter.timer(msg.qos() == QoS.AT_LEAST_ONCE ? TenantMetric.MqttQoS1InternalLatency : TenantMetric.MqttQoS2InternalLatency).record(HLC.INST.getPhysical(now - message.getTimestamp()), TimeUnit.MILLISECONDS);
            StagingMessage prev = this.stagingBuffer.put(seq, new StagingMessage(msg, batchEnd));
            if (prev == null) {
                this.memUsage.addAndGet(msg.estBytes());
            }
            if (this.ctx.executor().inEventLoop()) {
                this.drainStaging();
            } else {
                this.ctx.executor().execute(this::drainStaging);
            }
        });
    }

    private void drainStaging() {
        SortedMap<Long, StagingMessage> toBeSent = this.stagingBuffer.tailMap(this.nextSendSeq);
        if (toBeSent.isEmpty()) {
            return;
        }
        Iterator<Map.Entry<Long, StagingMessage>> itr = toBeSent.entrySet().iterator();
        while (this.clientReceiveQuota() > 0 && itr.hasNext()) {
            Map.Entry<Long, StagingMessage> entry = itr.next();
            long seq = entry.getKey();
            this.sendConfirmableSubMessage(seq, entry.getValue().message);
            this.nextSendSeq = seq + 1L;
        }
        this.flush(true);
    }

    private static enum State {
        INIT,
        ATTACHED,
        DETACH,
        SERVER_SHUTTING_DOWN,
        TERMINATE;

    }

    private record StagingMessage(RoutedMessage message, boolean batchEnd) {
    }
}

