/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.localengine.memory;

import java.util.function.Consumer;
import org.apache.bifromq.basekv.localengine.IKVSpaceMigratableWriter;
import org.apache.bifromq.basekv.localengine.IRestoreSession;
import org.apache.bifromq.basekv.localengine.ISyncContext;
import org.apache.bifromq.basekv.localengine.KVEngineException;
import org.apache.bifromq.basekv.localengine.memory.InMemCPableKVSpace;
import org.apache.bifromq.basekv.localengine.memory.InMemKVEngine;
import org.apache.bifromq.basekv.localengine.memory.InMemKVSpace;
import org.apache.bifromq.basekv.localengine.memory.InMemKVSpaceEpoch;
import org.apache.bifromq.basekv.localengine.memory.InMemKVSpaceIterator;
import org.apache.bifromq.basekv.localengine.memory.InMemKVSpaceWriter;
import org.apache.bifromq.basekv.localengine.memory.InMemKVSpaceWriterHelper;
import org.apache.bifromq.basekv.localengine.metrics.KVSpaceOpMeters;
import org.apache.bifromq.basekv.proto.Boundary;
import org.slf4j.Logger;

public class InMemKVSpaceMigratableWriter<E extends InMemKVEngine<E, T>, T extends InMemKVSpace<E, T>>
extends InMemKVSpaceWriter<E, T>
implements IKVSpaceMigratableWriter {
    InMemKVSpaceMigratableWriter(String id, InMemKVSpaceEpoch epoch, E engine, ISyncContext syncContext, Consumer<Boolean> afterWrite, Consumer<InMemKVSpaceWriterHelper.WriteImpact> impactListener, KVSpaceOpMeters readOpMeters, Logger logger) {
        super(id, epoch, engine, syncContext, afterWrite, impactListener, readOpMeters, logger);
    }

    public IRestoreSession migrateTo(String targetSpaceId, Boundary boundary) {
        try {
            InMemCPableKVSpace targetKVSpace = (InMemCPableKVSpace)this.engine.createIfMissing(targetSpaceId);
            IRestoreSession session = targetKVSpace.startRestore((count, bytes) -> this.logger.debug("Migrate {} kv to space[{}] from space[{}]: startKey={}, endKey={}", new Object[]{count, targetSpaceId, this.id, boundary.getStartKey().toStringUtf8(), boundary.getEndKey().toStringUtf8()}));
            try (InMemKVSpaceIterator itr = new InMemKVSpaceIterator(this.epoch.dataMap(), boundary);){
                itr.seekToFirst();
                while (itr.isValid()) {
                    session.put(itr.key(), itr.value());
                    itr.next();
                }
            }
            this.helper.clear(this.id, boundary);
            return session;
        }
        catch (Throwable e) {
            throw new KVEngineException("Delete range in batch failed", e);
        }
    }
}

