/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.raft.exception;

public class ReadIndexException
extends RuntimeException {
    private ReadIndexException(String message) {
        super(message);
    }

    public static ReadIndexException commitIndexNotConfirmed() {
        return new CommitIndexNotConfirmedException();
    }

    public static ReadIndexException leaderStepDown() {
        return new LeaderStepDownException();
    }

    public static ReadIndexException noLeader() {
        return new NoLeaderException();
    }

    public static ReadIndexException forwardTimeout() {
        return new ForwardTimeoutException();
    }

    public static ReadIndexException cancelled() {
        return new CancelledException();
    }

    public static class CommitIndexNotConfirmedException
    extends ReadIndexException {
        private CommitIndexNotConfirmedException() {
            super("Leader has not confirmed the commit index of its term");
        }
    }

    public static class LeaderStepDownException
    extends ReadIndexException {
        private LeaderStepDownException() {
            super("Leader has been stepped down");
        }
    }

    public static class NoLeaderException
    extends ReadIndexException {
        private NoLeaderException() {
            super("No leader elected");
        }
    }

    public static class ForwardTimeoutException
    extends ReadIndexException {
        private ForwardTimeoutException() {
            super("Doesn't receive read index from leader within timeout");
        }
    }

    public static class CancelledException
    extends ReadIndexException {
        private CancelledException() {
            super("Cancelled");
        }
    }
}

