/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.raft;

import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bifromq.basekv.raft.ILogEntryIterator;
import org.apache.bifromq.basekv.raft.IRaftStateStore;
import org.apache.bifromq.basekv.raft.proto.ClusterConfig;
import org.apache.bifromq.basekv.raft.proto.LogEntry;
import org.apache.bifromq.basekv.raft.proto.Snapshot;
import org.apache.bifromq.basekv.raft.proto.Voting;
import org.testng.Assert;
import org.testng.annotations.Test;

public abstract class BasicStateStoreTest {
    protected abstract IRaftStateStore createStorage(String var1, Snapshot var2);

    protected abstract String localId();

    @Test
    public void testInit() {
        Snapshot initSnapshot = Snapshot.newBuilder().setClusterConfig(ClusterConfig.newBuilder().addVoters(this.localId()).addVoters(this.localId() + "_2").addVoters(this.localId() + "_3").build()).setIndex(0L).setTerm(0L).build();
        IRaftStateStore stateStorage = this.createStorage(this.localId(), initSnapshot);
        Assert.assertEquals((String)stateStorage.local(), (String)this.localId());
        Assert.assertEquals((long)stateStorage.firstIndex(), (long)1L);
        Assert.assertEquals((long)stateStorage.lastIndex(), (long)0L);
        Assert.assertEquals((Object)stateStorage.latestSnapshot(), (Object)initSnapshot);
        Assert.assertEquals((Object)stateStorage.latestClusterConfig(), (Object)initSnapshot.getClusterConfig());
        Assert.assertFalse((boolean)stateStorage.entryAt(1L).isPresent());
        Assert.assertFalse((boolean)stateStorage.entryAt(0L).isPresent());
        try {
            stateStorage.entries(0L, 1L, -1L);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
    }

    @Test
    public void testSaveAndLoadCurrentTerm() {
        IRaftStateStore stateStorage = this.setupStateStorage();
        Assert.assertEquals((long)stateStorage.currentTerm(), (long)0L);
        stateStorage.saveTerm(0L);
        Assert.assertEquals((long)stateStorage.currentTerm(), (long)0L);
        stateStorage.saveTerm(1L);
        Assert.assertEquals((long)stateStorage.currentTerm(), (long)1L);
    }

    @Test
    public void testSaveAndLoadVoting() {
        IRaftStateStore stateStorage = this.setupStateStorage();
        Assert.assertFalse((boolean)stateStorage.currentVoting().isPresent());
        Voting voting = Voting.newBuilder().setFor(this.localId()).setTerm(1L).build();
        stateStorage.saveVoting(voting);
        Assert.assertEquals((Object)stateStorage.currentVoting().get(), (Object)voting);
    }

    @Test
    public void testSyncAppend() {
        IRaftStateStore stateStorage = this.setupStateStorage();
        ArrayList stabledIndexes = new ArrayList();
        stateStorage.addStableListener(stabledIndexes::add);
        int count = 10;
        while (count-- > 0) {
            LogEntry entry = LogEntry.newBuilder().setTerm(1L).setIndex(stateStorage.lastIndex() + 1L).setData(ByteString.EMPTY).build();
            stateStorage.append(Collections.singletonList(entry), true);
            Assert.assertEquals((long)stateStorage.entryAt(stateStorage.lastIndex()).get().getIndex(), (long)stateStorage.lastIndex());
        }
        for (int i = 0; i < stabledIndexes.size(); ++i) {
            Assert.assertEquals((Long)((Long)stabledIndexes.get(i)), (Long)Long.valueOf(i + 1));
        }
    }

    @Test
    public void testAppendFirstEntryFailedWithLowerBoundCheck() {
        ClusterConfig initialClusterConfig = ClusterConfig.newBuilder().addVoters(this.localId()).addVoters(this.localId() + "_2").addVoters(this.localId() + "_3").build();
        Snapshot initSnapshot = Snapshot.newBuilder().setClusterConfig(initialClusterConfig).setIndex(5L).setTerm(1L).build();
        IRaftStateStore stateStorage = this.createStorage(this.localId(), initSnapshot);
        try {
            stateStorage.append(List.of(LogEntry.newBuilder().setTerm(1L).setIndex(5L).setData(ByteString.EMPTY).build()), true);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            stateStorage.append(List.of(LogEntry.newBuilder().setTerm(1L).setIndex(7L).setData(ByteString.EMPTY).build()), true);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        stateStorage.append(Arrays.asList(LogEntry.newBuilder().setTerm(1L).setIndex(6L).setData(ByteString.EMPTY).build(), LogEntry.newBuilder().setTerm(1L).setIndex(7L).setData(ByteString.EMPTY).build()), true);
        try {
            stateStorage.append(List.of(LogEntry.newBuilder().setTerm(1L).setIndex(5L).setData(ByteString.EMPTY).build()), true);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
        try {
            stateStorage.append(List.of(LogEntry.newBuilder().setTerm(1L).setIndex(9L).setData(ByteString.EMPTY).build()), true);
            Assert.fail();
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof IndexOutOfBoundsException));
        }
    }

    @Test
    public void testAsyncAppend() throws InterruptedException {
        IRaftStateStore stateStorage = this.setupStateStorage();
        ArrayList stabledIndexes = new ArrayList();
        CountDownLatch countDownLatch = new CountDownLatch(1);
        stateStorage.addStableListener(stableIndex -> {
            stabledIndexes.add(stableIndex);
            countDownLatch.countDown();
        });
        int count = 10;
        while (count-- > 0) {
            LogEntry entry = LogEntry.newBuilder().setTerm(1L).setIndex(stateStorage.lastIndex() + 1L).setData(ByteString.EMPTY).build();
            stateStorage.append(Collections.singletonList(entry), false);
            Assert.assertEquals((long)stateStorage.entryAt(stateStorage.lastIndex()).get().getIndex(), (long)stateStorage.lastIndex());
        }
        countDownLatch.await();
        Assert.assertFalse((boolean)stabledIndexes.isEmpty());
        Assert.assertTrue(((Long)stabledIndexes.get(0) >= 1L ? 1 : 0) != 0);
    }

    @Test
    public void testTruncateAndAppend() {
        IRaftStateStore stateStorage = this.setupStateStorage();
        ClusterConfig updatedClusterConfig = ClusterConfig.newBuilder().addVoters(this.localId()).build();
        int count = 10;
        while (count-- > 0) {
            LogEntry.Builder entryBuilder = LogEntry.newBuilder();
            if (count == 5) {
                entryBuilder.setTerm(1L).setIndex(stateStorage.lastIndex() + 1L).setConfig(updatedClusterConfig);
            } else {
                entryBuilder.setTerm(1L).setIndex(stateStorage.lastIndex() + 1L).setData(ByteString.copyFromUtf8((String)("Data:" + (stateStorage.lastIndex() + 1L))));
            }
            LogEntry entry = entryBuilder.build();
            stateStorage.append(Collections.singletonList(entry), true);
            Assert.assertEquals((long)stateStorage.lastIndex(), (long)entry.getIndex());
        }
        ArrayList<LogEntry> newEntries = new ArrayList<LogEntry>();
        for (count = 5; count <= 8; ++count) {
            newEntries.add(LogEntry.newBuilder().setTerm(2L).setIndex((long)count).setData(ByteString.copyFromUtf8((String)("Data:" + count))).build());
        }
        Assert.assertEquals((Object)stateStorage.latestClusterConfig(), (Object)updatedClusterConfig);
        stateStorage.append(newEntries, true);
        Assert.assertNotEquals((Object)stateStorage.latestClusterConfig(), (Object)updatedClusterConfig);
        Assert.assertEquals((long)stateStorage.firstIndex(), (long)1L);
        Assert.assertEquals((long)stateStorage.lastIndex(), (long)8L);
        try (ILogEntryIterator entries5To8 = stateStorage.entries(5L, 9L, -1L);){
            int i = 0;
            while (entries5To8.hasNext()) {
                LogEntry entry = (LogEntry)entries5To8.next();
                Assert.assertEquals((long)entry.getTerm(), (long)2L);
                Assert.assertEquals((long)entry.getIndex(), (long)(i + 5));
                ++i;
            }
        }
    }

    @Test
    public void testTruncateWholeLog() {
        ClusterConfig initialClusterConfig = ClusterConfig.newBuilder().addVoters(this.localId()).addVoters(this.localId() + "_2").addVoters(this.localId() + "_3").build();
        Snapshot initSnapshot = Snapshot.newBuilder().setClusterConfig(initialClusterConfig).setIndex(5L).setTerm(1L).build();
        IRaftStateStore stateStorage = this.createStorage(this.localId(), initSnapshot);
        Assert.assertEquals((long)stateStorage.firstIndex(), (long)6L);
        Assert.assertEquals((long)stateStorage.lastIndex(), (long)5L);
        List<LogEntry> newEntries = List.of(LogEntry.newBuilder().setTerm(1L).setIndex(6L).setData(ByteString.EMPTY).build());
        stateStorage.append(newEntries, true);
        Assert.assertEquals((long)stateStorage.firstIndex(), (long)6L);
        Assert.assertEquals((long)stateStorage.lastIndex(), (long)6L);
        newEntries = Arrays.asList(LogEntry.newBuilder().setTerm(1L).setIndex(6L).setData(ByteString.EMPTY).build(), LogEntry.newBuilder().setTerm(1L).setIndex(7L).setData(ByteString.EMPTY).build());
        stateStorage.append(newEntries, true);
        Assert.assertEquals((long)stateStorage.firstIndex(), (long)6L);
        Assert.assertEquals((long)stateStorage.lastIndex(), (long)7L);
        newEntries = List.of(LogEntry.newBuilder().setTerm(1L).setIndex(6L).setData(ByteString.EMPTY).build());
        stateStorage.append(newEntries, true);
        Assert.assertEquals((long)stateStorage.firstIndex(), (long)6L);
        Assert.assertEquals((long)stateStorage.lastIndex(), (long)6L);
    }

    @Test
    public void testTruncateAndAppendFromZeroIndex() {
        IRaftStateStore stateStorage = this.setupStateStorage();
        ArrayList stabledIndexes = new ArrayList();
        stateStorage.addStableListener(stabledIndexes::add);
        int count = 5;
        while (count-- > 0) {
            LogEntry entry = LogEntry.newBuilder().setTerm(1L).setIndex(stateStorage.lastIndex() + 1L).setData(ByteString.EMPTY).build();
            stateStorage.append(Collections.singletonList(entry), true);
        }
        ArrayList<LogEntry> newEntries = new ArrayList<LogEntry>();
        for (int i = 1; i <= 5; ++i) {
            newEntries.add(LogEntry.newBuilder().setTerm(2L).setIndex((long)i).setData(ByteString.copyFromUtf8((String)("Data:" + count))).build());
        }
        stateStorage.append(newEntries, true);
        Assert.assertEquals((long)stateStorage.firstIndex(), (long)1L);
        Assert.assertEquals((long)stateStorage.lastIndex(), (long)5L);
        Assert.assertEquals((long)stateStorage.entryAt(stateStorage.firstIndex()).get().getTerm(), (long)2L);
        Assert.assertEquals((long)stateStorage.entryAt(stateStorage.lastIndex()).get().getTerm(), (long)2L);
    }

    @Test
    public void testApplyPartialSnapshot() {
        IRaftStateStore stateStorage = this.setupStateStorage();
        ClusterConfig updatedClusterConfig = ClusterConfig.newBuilder().addVoters(this.localId()).build();
        int count = 10;
        while (count-- > 0) {
            LogEntry.Builder entryBuilder = LogEntry.newBuilder();
            if (count == 5) {
                entryBuilder.setTerm(1L).setIndex(stateStorage.lastIndex() + 1L).setConfig(updatedClusterConfig);
            } else {
                entryBuilder.setTerm(1L).setIndex(stateStorage.lastIndex() + 1L).setData(ByteString.copyFromUtf8((String)("Data:" + (stateStorage.lastIndex() + 1L))));
            }
            stateStorage.append(Collections.singletonList(entryBuilder.build()), true);
        }
        Assert.assertEquals((Object)stateStorage.latestClusterConfig(), (Object)updatedClusterConfig);
        Snapshot snapshot = Snapshot.newBuilder().setClusterConfig(stateStorage.latestClusterConfig()).setData(ByteString.EMPTY).setTerm(1L).setIndex(3L).build();
        stateStorage.applySnapshot(snapshot);
        Assert.assertEquals((Object)stateStorage.latestClusterConfig(), (Object)updatedClusterConfig);
        Assert.assertEquals((long)stateStorage.firstIndex(), (long)4L);
        Assert.assertEquals((long)stateStorage.lastIndex(), (long)10L);
    }

    @Test
    public void testOverrideWithSameSnapshot() {
        IRaftStateStore stateStorage = this.setupStateStorage();
        ClusterConfig updatedClusterConfig = ClusterConfig.newBuilder().addVoters(this.localId()).build();
        int count = 10;
        while (count-- > 0) {
            LogEntry.Builder entryBuilder = LogEntry.newBuilder();
            if (count == 5) {
                entryBuilder.setTerm(1L).setIndex(stateStorage.lastIndex() + 1L).setConfig(updatedClusterConfig);
            } else {
                entryBuilder.setTerm(1L).setIndex(stateStorage.lastIndex() + 1L).setData(ByteString.copyFromUtf8((String)("Data:" + (stateStorage.lastIndex() + 1L))));
            }
            stateStorage.append(Collections.singletonList(entryBuilder.build()), true);
        }
        Assert.assertEquals((Object)stateStorage.latestClusterConfig(), (Object)updatedClusterConfig);
        Snapshot snapshot = Snapshot.newBuilder().setClusterConfig(stateStorage.latestClusterConfig()).setData(ByteString.EMPTY).setTerm(1L).setIndex(3L).build();
        stateStorage.applySnapshot(snapshot);
        Assert.assertEquals((Object)stateStorage.latestClusterConfig(), (Object)updatedClusterConfig);
        Assert.assertEquals((long)stateStorage.firstIndex(), (long)4L);
        Assert.assertEquals((long)stateStorage.lastIndex(), (long)10L);
        Assert.assertEquals((Object)stateStorage.latestSnapshot(), (Object)snapshot);
        snapshot = Snapshot.newBuilder().setClusterConfig(stateStorage.latestClusterConfig()).setData(ByteString.copyFromUtf8((String)"hello")).setTerm(1L).setIndex(3L).build();
        stateStorage.applySnapshot(snapshot);
        Assert.assertEquals((Object)stateStorage.latestClusterConfig(), (Object)updatedClusterConfig);
        Assert.assertEquals((long)stateStorage.firstIndex(), (long)4L);
        Assert.assertEquals((long)stateStorage.lastIndex(), (long)10L);
        Assert.assertEquals((Object)stateStorage.latestSnapshot(), (Object)snapshot);
    }

    @Test
    public void testOverrideSnapshot() {
        IRaftStateStore stateStorage = this.setupStateStorage();
        ClusterConfig updatedClusterConfig = ClusterConfig.newBuilder().addVoters(this.localId()).build();
        int count = 10;
        while (count-- > 0) {
            LogEntry.Builder entryBuilder = LogEntry.newBuilder();
            if (count == 5) {
                entryBuilder.setTerm(1L).setIndex(stateStorage.lastIndex() + 1L).setConfig(updatedClusterConfig);
            } else {
                entryBuilder.setTerm(1L).setIndex(stateStorage.lastIndex() + 1L).setData(ByteString.copyFromUtf8((String)("Data:" + (stateStorage.lastIndex() + 1L))));
            }
            stateStorage.append(Collections.singletonList(entryBuilder.build()), true);
        }
        Assert.assertEquals((Object)stateStorage.latestClusterConfig(), (Object)updatedClusterConfig);
        Snapshot snapshot = Snapshot.newBuilder().setClusterConfig(stateStorage.latestClusterConfig()).setData(ByteString.EMPTY).setTerm(1L).setIndex(3L).build();
        stateStorage.applySnapshot(snapshot);
        Assert.assertEquals((Object)stateStorage.latestClusterConfig(), (Object)updatedClusterConfig);
        Assert.assertEquals((long)stateStorage.firstIndex(), (long)4L);
        Assert.assertEquals((long)stateStorage.lastIndex(), (long)10L);
        Assert.assertEquals((Object)stateStorage.latestSnapshot(), (Object)snapshot);
        snapshot = Snapshot.newBuilder().setClusterConfig(stateStorage.latestClusterConfig()).setData(ByteString.copyFromUtf8((String)"hello")).setTerm(2L).setIndex(3L).build();
        stateStorage.applySnapshot(snapshot);
        Assert.assertEquals((Object)stateStorage.latestClusterConfig(), (Object)updatedClusterConfig);
        Assert.assertEquals((long)stateStorage.firstIndex(), (long)4L);
        Assert.assertEquals((long)stateStorage.lastIndex(), (long)3L);
        Assert.assertEquals((Object)stateStorage.latestSnapshot(), (Object)snapshot);
    }

    @Test
    public void testApplyFullSnapshot() {
        IRaftStateStore stateStorage = this.setupStateStorage();
        ClusterConfig updatedClusterConfig = ClusterConfig.newBuilder().addVoters(this.localId()).build();
        int count = 10;
        while (count-- > 0) {
            LogEntry.Builder entryBuilder = LogEntry.newBuilder();
            if (count == 5) {
                entryBuilder.setTerm(1L).setIndex(stateStorage.lastIndex() + 1L).setConfig(updatedClusterConfig);
            } else {
                entryBuilder.setTerm(1L).setIndex(stateStorage.lastIndex() + 1L).setData(ByteString.copyFromUtf8((String)("Data:" + (stateStorage.lastIndex() + 1L))));
            }
            stateStorage.append(Collections.singletonList(entryBuilder.build()), true);
        }
        Snapshot snapshot = Snapshot.newBuilder().setClusterConfig(stateStorage.latestClusterConfig()).setData(ByteString.EMPTY).setTerm(1L).setIndex(10L).build();
        stateStorage.applySnapshot(snapshot);
        Assert.assertEquals((Object)stateStorage.latestClusterConfig(), (Object)updatedClusterConfig);
        Assert.assertEquals((long)stateStorage.firstIndex(), (long)11L);
        Assert.assertEquals((long)stateStorage.lastIndex(), (long)10L);
        Assert.assertEquals((Object)stateStorage.latestSnapshot(), (Object)snapshot);
    }

    @Test
    public void testApplyLargerSnapshot() {
        IRaftStateStore stateStorage = this.setupStateStorage();
        int count = 10;
        while (count-- > 0) {
            LogEntry entry = LogEntry.newBuilder().setTerm(1L).setIndex(stateStorage.lastIndex() + 1L).setData(ByteString.copyFromUtf8((String)("Data:" + (stateStorage.lastIndex() + 1L)))).build();
            stateStorage.append(Collections.singletonList(entry), true);
        }
        ClusterConfig updatedClusterConfig = ClusterConfig.newBuilder().addVoters(this.localId()).build();
        Snapshot snapshot = Snapshot.newBuilder().setClusterConfig(updatedClusterConfig).setData(ByteString.EMPTY).setTerm(1L).setIndex(15L).build();
        stateStorage.applySnapshot(snapshot);
        Assert.assertEquals((Object)stateStorage.latestClusterConfig(), (Object)updatedClusterConfig);
        Assert.assertEquals((long)stateStorage.firstIndex(), (long)16L);
        Assert.assertEquals((long)stateStorage.lastIndex(), (long)15L);
        Assert.assertEquals((Object)stateStorage.latestSnapshot(), (Object)snapshot);
    }

    @Test
    public void testApplyDifferentSnapshot() {
        IRaftStateStore stateStorage = this.setupStateStorage();
        int count = 10;
        while (count-- > 0) {
            LogEntry entry = LogEntry.newBuilder().setTerm(1L).setIndex(stateStorage.lastIndex() + 1L).setData(ByteString.copyFromUtf8((String)("Data:" + (stateStorage.lastIndex() + 1L)))).build();
            stateStorage.append(Collections.singletonList(entry), true);
        }
        ClusterConfig cc = ClusterConfig.newBuilder().addVoters("V1").build();
        Snapshot snapshot = Snapshot.newBuilder().setClusterConfig(cc).setData(ByteString.EMPTY).setTerm(2L).setIndex(3L).build();
        stateStorage.applySnapshot(snapshot);
        Assert.assertEquals((long)stateStorage.lastIndex(), (long)3L);
        Assert.assertEquals((long)stateStorage.firstIndex(), (long)4L);
        Assert.assertEquals((long)stateStorage.latestSnapshot().getIndex(), (long)3L);
        Assert.assertEquals((long)stateStorage.latestSnapshot().getTerm(), (long)2L);
        Assert.assertEquals((Object)stateStorage.latestClusterConfig(), (Object)cc);
        Assert.assertEquals((Object)stateStorage.latestSnapshot(), (Object)snapshot);
    }

    @Test
    public void testFetchEntries() {
        IRaftStateStore stateStorage = this.setupStateStorage();
        try (ILogEntryIterator entries = stateStorage.entries(stateStorage.firstIndex(), stateStorage.lastIndex(), -1L);){
            Assert.assertFalse((boolean)entries.hasNext());
        }
        int count = 10;
        while (count-- > 0) {
            LogEntry entry = LogEntry.newBuilder().setTerm(1L).setIndex(stateStorage.lastIndex() + 1L).setData(ByteString.copyFromUtf8((String)("Data:" + (stateStorage.lastIndex() + 1L)))).build();
            stateStorage.append(Collections.singletonList(entry), true);
        }
        AtomicInteger counter = new AtomicInteger(0);
        try (ILogEntryIterator it = stateStorage.entries(stateStorage.firstIndex(), stateStorage.lastIndex() + 1L, -1L);){
            it.forEachRemaining(e -> counter.incrementAndGet());
        }
        Assert.assertEquals((int)counter.get(), (int)10);
        counter.set(0);
        it = stateStorage.entries(stateStorage.firstIndex(), stateStorage.lastIndex() + 1L, 2L);
        try {
            it.forEachRemaining(e -> counter.incrementAndGet());
        }
        finally {
            if (it != null) {
                it.close();
            }
        }
        Assert.assertEquals((int)counter.get(), (int)1);
        counter.set(0);
        it = stateStorage.entries(stateStorage.firstIndex(), stateStorage.lastIndex() + 1L, 10L);
        try {
            it.forEachRemaining(e -> counter.incrementAndGet());
        }
        finally {
            if (it != null) {
                it.close();
            }
        }
        Assert.assertEquals((int)counter.get(), (int)2);
    }

    @Test
    public void testAppendClusterConfigEntry() {
        IRaftStateStore stateStorage = this.setupStateStorage();
        int count = 10;
        while (count-- > 0) {
            LogEntry.Builder entryBuilder = LogEntry.newBuilder();
            if (count == 5) {
                entryBuilder.setTerm(1L).setIndex(stateStorage.lastIndex() + 1L).setConfig(ClusterConfig.newBuilder().addVoters("V1").addVoters("V2").addVoters("V3").addVoters("V4").addVoters("V5").build());
            } else {
                entryBuilder.setTerm(1L).setIndex(stateStorage.lastIndex() + 1L).setData(ByteString.copyFromUtf8((String)("Data:" + (stateStorage.lastIndex() + 1L))));
            }
            stateStorage.append(Collections.singletonList(entryBuilder.build()), true);
        }
        Assert.assertEquals((Object)stateStorage.latestClusterConfig(), (Object)ClusterConfig.newBuilder().addVoters("V1").addVoters("V2").addVoters("V3").addVoters("V4").addVoters("V5").build());
        stateStorage.append(Collections.singletonList(LogEntry.newBuilder().setTerm(1L).setIndex(4L).setConfig(ClusterConfig.newBuilder().addVoters("S1").addVoters("S2").addVoters("S3").build()).build()), true);
        Assert.assertEquals((Object)stateStorage.latestClusterConfig(), (Object)ClusterConfig.newBuilder().addVoters("S1").addVoters("S2").addVoters("S3").build());
    }

    private IRaftStateStore setupStateStorage() {
        ClusterConfig initialClusterConfig = ClusterConfig.newBuilder().addVoters(this.localId()).addVoters(this.localId() + "_2").addVoters(this.localId() + "_3").build();
        Snapshot initSnapshot = Snapshot.newBuilder().setClusterConfig(initialClusterConfig).setIndex(0L).setTerm(0L).build();
        return this.createStorage(this.localId(), initSnapshot);
    }
}

