/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.client.scheduler;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import lombok.Generated;
import org.apache.bifromq.base.util.CompletableFutureUtil;
import org.apache.bifromq.basekv.client.IMutationPipeline;
import org.apache.bifromq.basekv.client.exception.BadRequestException;
import org.apache.bifromq.basekv.client.exception.BadVersionException;
import org.apache.bifromq.basekv.client.exception.InternalErrorException;
import org.apache.bifromq.basekv.client.exception.TryLaterException;
import org.apache.bifromq.basekv.client.scheduler.MutationCallBatcherKey;
import org.apache.bifromq.basekv.store.proto.KVRangeRWRequest;
import org.apache.bifromq.basekv.store.proto.RWCoProcInput;
import org.apache.bifromq.basekv.store.proto.RWCoProcOutput;
import org.apache.bifromq.basescheduler.IBatchCall;
import org.apache.bifromq.basescheduler.ICallTask;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BatchMutationCall<ReqT, RespT>
implements IBatchCall<ReqT, RespT, MutationCallBatcherKey> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BatchMutationCall.class);
    protected final MutationCallBatcherKey batcherKey;
    private final IMutationPipeline storePipeline;
    private Deque<MutationCallTaskBatch<ReqT, RespT>> batchCallTasks = new ArrayDeque<MutationCallTaskBatch<ReqT, RespT>>();

    protected BatchMutationCall(IMutationPipeline storePipeline, MutationCallBatcherKey batcherKey) {
        this.batcherKey = batcherKey;
        this.storePipeline = storePipeline;
    }

    public final void add(ICallTask<ReqT, RespT, MutationCallBatcherKey> callTask) {
        MutationCallBatcherKey batcherKey = (MutationCallBatcherKey)callTask.batcherKey();
        assert (((MutationCallBatcherKey)callTask.batcherKey()).id.equals((Object)batcherKey.id));
        MutationCallTaskBatch<ReqT, RespT> lastBatchCallTask = this.batchCallTasks.peekLast();
        if (lastBatchCallTask != null) {
            if (!lastBatchCallTask.isBatchable(callTask)) {
                lastBatchCallTask = this.newBatch(batcherKey.ver);
                this.batchCallTasks.add(lastBatchCallTask);
            }
            lastBatchCallTask.add(callTask);
        } else {
            lastBatchCallTask = this.newBatch(batcherKey.ver);
            lastBatchCallTask.add(callTask);
            this.batchCallTasks.add(lastBatchCallTask);
        }
    }

    protected MutationCallTaskBatch<ReqT, RespT> newBatch(long ver) {
        return new MutationCallTaskBatch(ver);
    }

    protected abstract RWCoProcInput makeBatch(Iterable<ICallTask<ReqT, RespT, MutationCallBatcherKey>> var1);

    protected abstract void handleOutput(Queue<ICallTask<ReqT, RespT, MutationCallBatcherKey>> var1, RWCoProcOutput var2);

    protected abstract void handleException(ICallTask<ReqT, RespT, MutationCallBatcherKey> var1, Throwable var2);

    public void reset(boolean abort) {
        if (abort) {
            this.batchCallTasks = new ArrayDeque<MutationCallTaskBatch<ReqT, RespT>>();
        }
    }

    public CompletableFuture<Void> execute() {
        return this.execute(this.batchCallTasks);
    }

    private CompletableFuture<Void> execute(Deque<MutationCallTaskBatch<ReqT, RespT>> batchCallTasks) {
        MutationCallTaskBatch<ReqT, RespT> batchCallTask;
        CompletionStage<Object> chained = CompletableFuture.completedFuture(null);
        while ((batchCallTask = batchCallTasks.poll()) != null) {
            MutationCallTaskBatch<ReqT, RespT> current = batchCallTask;
            chained = chained.thenCompose(v -> this.fireSingleBatch(current));
        }
        return chained;
    }

    private CompletableFuture<Void> fireSingleBatch(MutationCallTaskBatch<ReqT, RespT> batchCallTask) {
        RWCoProcInput input = this.makeBatch(batchCallTask.batchedTasks);
        long reqId = System.nanoTime();
        return ((CompletableFuture)this.storePipeline.execute(KVRangeRWRequest.newBuilder().setReqId(reqId).setVer(batchCallTask.ver).setKvRangeId(this.batcherKey.id).setRwCoProc(input).build()).thenApply(reply -> {
            switch (reply.getCode()) {
                case Ok: {
                    return reply.getRwCoProcResult();
                }
                case TryLater: {
                    throw new TryLaterException();
                }
                case BadVersion: {
                    throw new BadVersionException();
                }
                case BadRequest: {
                    throw new BadRequestException();
                }
            }
            throw new InternalErrorException();
        })).handle(CompletableFutureUtil.unwrap((v, e) -> {
            if (e != null) {
                ICallTask callTask;
                while ((callTask = batchCallTask.batchedTasks.poll()) != null) {
                    this.handleException((ICallTask<ReqT, RespT, MutationCallBatcherKey>)callTask, (Throwable)e);
                }
            } else {
                this.handleOutput((Queue<ICallTask<ReqT, RespT, MutationCallBatcherKey>>)batchCallTask.batchedTasks, (RWCoProcOutput)v);
            }
            return null;
        }));
    }

    protected static class MutationCallTaskBatch<CallT, CallResultT> {
        private final long ver;
        private final LinkedList<ICallTask<CallT, CallResultT, MutationCallBatcherKey>> batchedTasks = new LinkedList();

        protected MutationCallTaskBatch(long ver) {
            this.ver = ver;
        }

        protected void add(ICallTask<CallT, CallResultT, MutationCallBatcherKey> callTask) {
            this.batchedTasks.add(callTask);
        }

        protected boolean isBatchable(ICallTask<CallT, CallResultT, MutationCallBatcherKey> callTask) {
            return true;
        }
    }
}

