/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.dist.server.scheduler;

import com.google.protobuf.ByteString;
import java.time.Duration;
import lombok.Generated;
import org.apache.bifromq.basekv.client.IBaseKVStoreClient;
import org.apache.bifromq.basekv.client.scheduler.MutationCallScheduler;
import org.apache.bifromq.dist.rpc.proto.UnmatchReply;
import org.apache.bifromq.dist.rpc.proto.UnmatchRequest;
import org.apache.bifromq.dist.server.scheduler.BatchUnmatchCall;
import org.apache.bifromq.dist.server.scheduler.IUnmatchCallScheduler;
import org.apache.bifromq.dist.worker.schema.KVSchemaUtil;
import org.apache.bifromq.sysprops.props.ControlPlaneMaxBurstLatencyMillis;
import org.apache.bifromq.type.RouteMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UnmatchCallScheduler
extends MutationCallScheduler<UnmatchRequest, UnmatchReply, BatchUnmatchCall>
implements IUnmatchCallScheduler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(UnmatchCallScheduler.class);

    public UnmatchCallScheduler(IBaseKVStoreClient distWorkerClient) {
        super(BatchUnmatchCall::new, Duration.ofMillis((Long)ControlPlaneMaxBurstLatencyMillis.INSTANCE.get()).toNanos(), distWorkerClient);
    }

    protected ByteString rangeKey(UnmatchRequest call) {
        RouteMatcher matcher = call.getMatcher();
        if (matcher.getType() == RouteMatcher.Type.Normal) {
            return KVSchemaUtil.toNormalRouteKey((String)call.getTenantId(), (RouteMatcher)matcher, (String)KVSchemaUtil.toReceiverUrl((int)call.getBrokerId(), (String)call.getReceiverId(), (String)call.getDelivererKey()));
        }
        return KVSchemaUtil.toGroupRouteKey((String)call.getTenantId(), (RouteMatcher)matcher);
    }
}

