/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.basekv.store.range;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.google.protobuf.ByteString;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Supplier;
import org.apache.bifromq.basekv.proto.Boundary;
import org.apache.bifromq.basekv.proto.KVRangeDescriptor;
import org.apache.bifromq.basekv.proto.State;
import org.apache.bifromq.basekv.store.api.IKVRangeCoProc;
import org.apache.bifromq.basekv.store.api.IKVRangeReader;
import org.apache.bifromq.basekv.store.api.IKVRangeRefreshableReader;
import org.apache.bifromq.basekv.store.exception.KVRangeException;
import org.apache.bifromq.basekv.store.proto.ROCoProcInput;
import org.apache.bifromq.basekv.store.proto.ROCoProcOutput;
import org.apache.bifromq.basekv.store.range.IKVRange;
import org.apache.bifromq.basekv.store.range.IKVRangeQueryLinearizer;
import org.apache.bifromq.basekv.store.range.IKVRangeQueryRunner;
import org.apache.bifromq.basekv.store.range.KVLoadRecorder;
import org.apache.bifromq.basekv.store.range.LoadRecordableKVReader;
import org.apache.bifromq.basekv.store.range.hinter.IKVLoadRecord;
import org.apache.bifromq.basekv.store.range.hinter.IKVRangeSplitHinter;
import org.apache.bifromq.basekv.store.util.VerUtil;
import org.apache.bifromq.basekv.utils.BoundaryUtil;
import org.apache.bifromq.logger.MDCLogger;
import org.slf4j.Logger;

class KVRangeQueryRunner
implements IKVRangeQueryRunner {
    private final Logger log;
    private final IKVRange kvRange;
    private final IKVRangeCoProc coProc;
    private final Executor executor;
    private final Set<CompletableFuture<?>> runningQueries = Sets.newConcurrentHashSet();
    private final IKVRangeQueryLinearizer linearizer;
    private final StampedLock queryLock;
    private final AtomicBoolean closed = new AtomicBoolean();
    private final List<IKVRangeSplitHinter> splitHinters;
    private final Supplier<KVRangeDescriptor> descriptorSupplier;

    KVRangeQueryRunner(IKVRange kvRange, IKVRangeCoProc coProc, Executor executor, IKVRangeQueryLinearizer linearizer, List<IKVRangeSplitHinter> splitHinters, Supplier<KVRangeDescriptor> descriptorSupplier, StampedLock queryLock, String ... tags) {
        this.kvRange = kvRange;
        this.coProc = coProc;
        this.executor = executor;
        this.linearizer = linearizer;
        this.queryLock = queryLock;
        this.splitHinters = splitHinters;
        this.descriptorSupplier = descriptorSupplier;
        this.log = MDCLogger.getLogger(KVRangeQueryRunner.class, (String[])tags);
    }

    @Override
    public CompletableFuture<Boolean> exist(long ver, ByteString key, boolean linearized) {
        return this.submit(ver, rangeReader -> {
            Preconditions.checkArgument((boolean)BoundaryUtil.inRange((ByteString)key, (Boundary)rangeReader.boundary()));
            return CompletableFuture.completedFuture(rangeReader.exist(key));
        }, linearized);
    }

    @Override
    public CompletableFuture<Optional<ByteString>> get(long ver, ByteString key, boolean linearized) {
        return this.submit(ver, rangeReader -> {
            Preconditions.checkArgument((boolean)BoundaryUtil.inRange((ByteString)key, (Boundary)rangeReader.boundary()));
            return CompletableFuture.completedFuture(rangeReader.get(key));
        }, linearized);
    }

    @Override
    public CompletableFuture<ROCoProcOutput> queryCoProc(long ver, ROCoProcInput query, boolean linearized) {
        return this.submit(ver, rangeReader -> {
            KVLoadRecorder loadRecorder = new KVLoadRecorder();
            LoadRecordableKVReader loadRecordableReader = new LoadRecordableKVReader(rangeReader, loadRecorder);
            return this.coProc.query(query, (IKVRangeReader)loadRecordableReader).whenComplete((v, e) -> {
                try {
                    IKVLoadRecord record = loadRecorder.stop();
                    this.splitHinters.forEach(hinter -> hinter.recordQuery(query, record));
                }
                catch (Throwable t) {
                    this.log.error("Failed to reset hinter and coProc", t);
                }
            });
        }, linearized);
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.runningQueries.forEach(f -> f.cancel(true));
        }
    }

    private <ReqT, ResultT> CompletableFuture<ResultT> submit(long ver, QueryFunction<ReqT, ResultT> queryFn, boolean linearized) {
        if (!VerUtil.boundaryCompatible(ver, this.kvRange.currentVer())) {
            return CompletableFuture.failedFuture(new KVRangeException.BadVersion("Version Mismatch", this.descriptorSupplier.get()));
        }
        CompletableFuture onDone = new CompletableFuture();
        this.runningQueries.add(onDone);
        Runnable queryTask = () -> {
            if (onDone.isDone()) {
                return;
            }
            if (this.closed.get()) {
                onDone.cancel(true);
                return;
            }
            if (linearized) {
                this.linearizer.linearize().thenComposeAsync(v -> this.doQuery(ver, queryFn), this.executor).whenCompleteAsync((r, e) -> {
                    if (e != null) {
                        onDone.completeExceptionally((Throwable)e);
                    } else {
                        onDone.complete(r);
                    }
                }, this.executor);
            } else {
                this.doQuery(ver, queryFn).whenCompleteAsync((v, e) -> {
                    if (e != null) {
                        onDone.completeExceptionally((Throwable)e);
                    } else {
                        onDone.complete(v);
                    }
                }, this.executor);
            }
        };
        onDone.whenComplete((v, e) -> this.runningQueries.remove(onDone));
        this.executor.execute(queryTask);
        return onDone;
    }

    private <ReqT, ResultT> CompletableFuture<ResultT> doQuery(long ver, QueryFunction<ReqT, ResultT> queryFn) {
        CompletableFuture onDone = new CompletableFuture();
        long stamp = this.queryLock.tryReadLock();
        try {
            if (stamp == 0L) {
                return CompletableFuture.failedFuture(new KVRangeException.TryLater("Range is resetting or busy", this.descriptorSupplier.get()));
            }
            IKVRangeRefreshableReader refreshableReader = this.kvRange.newReader();
            onDone.whenComplete((v, e) -> refreshableReader.close());
            State state = this.kvRange.currentState();
            if (!VerUtil.boundaryCompatible(ver, this.kvRange.currentVer())) {
                this.queryLock.unlockRead(stamp);
                onDone.completeExceptionally(new KVRangeException.BadVersion("Version Mismatch", this.descriptorSupplier.get()));
                return onDone;
            }
            if (state.getType() == State.StateType.Merged || state.getType() == State.StateType.Removed || state.getType() == State.StateType.ToBePurged) {
                this.queryLock.unlockRead(stamp);
                onDone.completeExceptionally(new KVRangeException.TryLater("Range has been in state: " + state.getType().name().toLowerCase()));
                return onDone;
            }
            return queryFn.apply(refreshableReader).whenCompleteAsync((v, e) -> {
                this.queryLock.unlockRead(stamp);
                if (e != null) {
                    onDone.completeExceptionally((Throwable)e);
                } else {
                    onDone.complete(v);
                }
            }, this.executor);
        }
        catch (Throwable e2) {
            if (stamp != 0L) {
                this.queryLock.unlockRead(stamp);
            }
            this.log.debug("Failed to query range", e2);
            return CompletableFuture.failedFuture(new KVRangeException.InternalException(e2.getMessage()));
        }
    }

    private static interface QueryFunction<Req, Resp> {
        public CompletableFuture<Resp> apply(IKVRangeRefreshableReader var1);
    }
}

