/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bifromq.starter.module;

import com.google.common.util.concurrent.MoreExecutors;
import io.netty.util.concurrent.EventExecutorGroup;
import java.util.Stack;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public class SharedResourcesHolder {
    private final Stack<Object> closeableResources = new Stack();

    public <T> T add(T resource) {
        assert (this.closeableResources instanceof AutoCloseable || this.closeableResources instanceof ExecutorService);
        this.closeableResources.add(resource);
        return resource;
    }

    public void close() {
        while (!this.closeableResources.isEmpty()) {
            Object resource = this.closeableResources.pop();
            if (resource instanceof AutoCloseable) {
                try {
                    ((AutoCloseable)resource).close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (resource instanceof EventExecutorGroup) {
                ((EventExecutorGroup)resource).shutdownGracefully();
            }
            if (!(resource instanceof ExecutorService)) continue;
            MoreExecutors.shutdownAndAwaitTermination((ExecutorService)((ExecutorService)resource), (long)5L, (TimeUnit)TimeUnit.SECONDS);
        }
    }
}

