/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.storage;

import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.hlc.HybridTimestamp;
import org.apache.ignite3.internal.schema.BinaryRow;
import org.apache.ignite3.internal.storage.AbortResult;
import org.apache.ignite3.internal.storage.AddWriteCommittedResult;
import org.apache.ignite3.internal.storage.AddWriteResult;
import org.apache.ignite3.internal.storage.CommitResult;
import org.apache.ignite3.internal.storage.MvPartitionStorage;
import org.apache.ignite3.internal.storage.PartitionTimestampCursor;
import org.apache.ignite3.internal.storage.ReadResult;
import org.apache.ignite3.internal.storage.RowId;
import org.apache.ignite3.internal.storage.StorageException;
import org.apache.ignite3.internal.storage.ThreadAssertingPartitionTimestampCursor;
import org.apache.ignite3.internal.storage.gc.GcEntry;
import org.apache.ignite3.internal.storage.lease.LeaseInfo;
import org.apache.ignite3.internal.util.Cursor;
import org.apache.ignite3.internal.worker.ThreadAssertingCursor;
import org.apache.ignite3.internal.worker.ThreadAssertions;
import org.apache.ignite3.internal.wrapper.Wrapper;
import org.jetbrains.annotations.Nullable;

public class ThreadAssertingMvPartitionStorage
implements MvPartitionStorage,
Wrapper {
    private final MvPartitionStorage partitionStorage;

    public ThreadAssertingMvPartitionStorage(MvPartitionStorage partitionStorage) {
        this.partitionStorage = partitionStorage;
    }

    @Override
    public <V> V runConsistently(MvPartitionStorage.WriteClosure<V> closure) throws StorageException {
        return this.partitionStorage.runConsistently(closure);
    }

    @Override
    public CompletableFuture<Void> flush(boolean trigger) {
        ThreadAssertions.assertThreadAllowsToWrite();
        return this.partitionStorage.flush(trigger);
    }

    @Override
    public long lastAppliedIndex() {
        return this.partitionStorage.lastAppliedIndex();
    }

    @Override
    public long lastAppliedTerm() {
        return this.partitionStorage.lastAppliedTerm();
    }

    @Override
    public void lastApplied(long lastAppliedIndex, long lastAppliedTerm) throws StorageException {
        ThreadAssertions.assertThreadAllowsToWrite();
        this.partitionStorage.lastApplied(lastAppliedIndex, lastAppliedTerm);
    }

    @Override
    public byte @Nullable [] committedGroupConfiguration() {
        return this.partitionStorage.committedGroupConfiguration();
    }

    @Override
    public void committedGroupConfiguration(byte[] config) {
        this.partitionStorage.committedGroupConfiguration(config);
    }

    @Override
    public ReadResult read(RowId rowId, HybridTimestamp timestamp) throws StorageException {
        ThreadAssertions.assertThreadAllowsToRead();
        return this.partitionStorage.read(rowId, timestamp);
    }

    @Override
    public AddWriteResult addWrite(RowId rowId, @Nullable BinaryRow row, UUID txId, int commitTableOrZoneId, int commitPartitionId) throws StorageException {
        ThreadAssertions.assertThreadAllowsToWrite();
        return this.partitionStorage.addWrite(rowId, row, txId, commitTableOrZoneId, commitPartitionId);
    }

    @Override
    public AbortResult abortWrite(RowId rowId, UUID txId) throws StorageException {
        ThreadAssertions.assertThreadAllowsToWrite();
        return this.partitionStorage.abortWrite(rowId, txId);
    }

    @Override
    public CommitResult commitWrite(RowId rowId, HybridTimestamp timestamp, UUID txId) throws StorageException {
        ThreadAssertions.assertThreadAllowsToWrite();
        return this.partitionStorage.commitWrite(rowId, timestamp, txId);
    }

    @Override
    public AddWriteCommittedResult addWriteCommitted(RowId rowId, @Nullable BinaryRow row, HybridTimestamp commitTimestamp) throws StorageException {
        ThreadAssertions.assertThreadAllowsToWrite();
        return this.partitionStorage.addWriteCommitted(rowId, row, commitTimestamp);
    }

    @Override
    public Cursor<ReadResult> scanVersions(RowId rowId) throws StorageException {
        ThreadAssertions.assertThreadAllowsToRead();
        return new ThreadAssertingCursor<ReadResult>(this.partitionStorage.scanVersions(rowId));
    }

    @Override
    public PartitionTimestampCursor scan(HybridTimestamp timestamp) throws StorageException {
        ThreadAssertions.assertThreadAllowsToRead();
        return new ThreadAssertingPartitionTimestampCursor(this.partitionStorage.scan(timestamp));
    }

    @Override
    @Nullable
    public RowId closestRowId(RowId lowerBound) throws StorageException {
        ThreadAssertions.assertThreadAllowsToRead();
        return this.partitionStorage.closestRowId(lowerBound);
    }

    @Override
    @Nullable
    public GcEntry peek(HybridTimestamp lowWatermark) {
        ThreadAssertions.assertThreadAllowsToRead();
        return this.partitionStorage.peek(lowWatermark);
    }

    @Override
    @Nullable
    public BinaryRow vacuum(GcEntry entry) {
        ThreadAssertions.assertThreadAllowsToWrite();
        return this.partitionStorage.vacuum(entry);
    }

    @Override
    public void updateLease(LeaseInfo leaseInfo) {
        ThreadAssertions.assertThreadAllowsToWrite();
        this.partitionStorage.updateLease(leaseInfo);
    }

    @Override
    @Nullable
    public LeaseInfo leaseInfo() {
        return this.partitionStorage.leaseInfo();
    }

    @Override
    public long estimatedSize() {
        return this.partitionStorage.estimatedSize();
    }

    @Override
    public void close() {
        this.partitionStorage.close();
    }

    @Override
    public <T> T unwrap(Class<T> classToUnwrap) {
        return classToUnwrap.cast(this.partitionStorage);
    }
}

