/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.sql.engine.rel.explain;

import it.unimi.dsi.fastutil.objects.ObjectIntPair;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.calcite.avatica.util.Spacer;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.core.SetOp;
import org.apache.calcite.rel.core.TableModify;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.ignite3.internal.sql.engine.prepare.bounds.SearchBounds;
import org.apache.ignite3.internal.sql.engine.rel.IgniteRel;
import org.apache.ignite3.internal.sql.engine.rel.explain.ExplainUtils;
import org.apache.ignite3.internal.sql.engine.rel.explain.IgniteRelWriter;
import org.apache.ignite3.internal.sql.engine.schema.IgniteIndex;
import org.apache.ignite3.internal.sql.engine.trait.IgniteDistribution;
import org.apache.ignite3.internal.sql.engine.util.Commons;
import org.apache.ignite3.lang.util.IgniteNameUtils;
import org.apache.ignite3.table.QualifiedNameHelper;

class RelTreeToTextWriter {
    static final int NEXT_OPERATOR_INDENT = 2;
    private static final int OPERATOR_ATTRIBUTES_INDENT = 4;

    private static boolean needToAddFieldNames(IgniteRel rel) {
        List inputs = rel.getInputs();
        if (inputs.isEmpty()) {
            return true;
        }
        if (rel instanceof SetOp) {
            return false;
        }
        if (inputs.size() == 1 && rel.getRowType() == ((RelNode)inputs.get(0)).getRowType()) {
            return false;
        }
        assert (inputs.size() == 1 || inputs.size() == 2);
        ArrayList inputNames = new ArrayList(((RelNode)inputs.get(0)).getRowType().getFieldNames());
        if (inputs.size() == 2) {
            inputNames.addAll(((RelNode)inputs.get(1)).getRowType().getFieldNames());
        }
        return !rel.getRowType().getFieldNames().equals(inputNames);
    }

    private static RelInfoHolder collectRelInfo(IgniteRel rel) {
        RelInfoHolder infoHolder = new RelInfoHolder(rel);
        rel.explain(infoHolder);
        if (!infoHolder.attributes.containsKey((Object)AttributeName.FIELD_NAMES) && RelTreeToTextWriter.needToAddFieldNames(rel)) {
            infoHolder.attributes.put(AttributeName.FIELD_NAMES, rel.getRowType().getFieldNames().toString());
        }
        rel.getInputs().forEach(input -> infoHolder.addChild((IgniteRel)input));
        return infoHolder;
    }

    static String dumpTree(IgniteRel rootRel, int initialLevel) {
        RelInfoHolder root = RelTreeToTextWriter.collectRelInfo(rootRel);
        ArrayDeque<ObjectIntPair> explanationStack = new ArrayDeque<ObjectIntPair>();
        explanationStack.add(ObjectIntPair.of((Object)root, (int)initialLevel));
        StringBuilder sb = new StringBuilder();
        Spacer spacer = new Spacer();
        while (!explanationStack.isEmpty()) {
            ObjectIntPair infoHolderWithLevel = (ObjectIntPair)explanationStack.pollLast();
            RelInfoHolder infoHolder = (RelInfoHolder)infoHolderWithLevel.first();
            int level = infoHolderWithLevel.secondInt();
            for (int i = infoHolder.inputs.size() - 1; i >= 0; --i) {
                explanationStack.add(ObjectIntPair.of((Object)infoHolder.inputs.get(i), (int)(level + 1)));
            }
            spacer.set(level * 2);
            spacer.spaces(sb).append(infoHolder.rel.getRelTypeName());
            spacer.add(4);
            for (AttributeName name : AttributeName.values()) {
                String attributeValue = infoHolder.attributes.get((Object)name);
                if (attributeValue == null) continue;
                sb.append(System.lineSeparator());
                spacer.spaces(sb);
                sb.append(name.label).append(": ").append(attributeValue);
            }
            sb.append(System.lineSeparator());
            spacer.spaces(sb);
            RelMetadataQuery mq = infoHolder.rel.getCluster().getMetadataQuery();
            sb.append("est: (rows=").append(BigDecimal.valueOf(mq.getRowCount((RelNode)infoHolder.rel)).setScale(0, RoundingMode.HALF_UP)).append(')');
            spacer.subtract(4);
            sb.append(System.lineSeparator());
        }
        return sb.toString();
    }

    private static List<String> beautifyBitSet(ImmutableBitSet bitSet, RelDataType rowType) {
        return bitSet.stream().mapToObj(rowType.getFieldNames()::get).collect(Collectors.toList());
    }

    private static String beautifyAggCall(AggregateCall call, RexShuttle inputRefRewriter, RelDataType rowType) {
        StringBuilder buf = new StringBuilder(call.getAggregation().toString());
        buf.append('(');
        if (call.isApproximate()) {
            buf.append("APPROXIMATE ");
        }
        if (call.isDistinct()) {
            buf.append(call.getArgList().isEmpty() ? "DISTINCT" : "DISTINCT ");
        }
        int i = -1;
        for (RexNode rexNode : call.rexList) {
            if (++i > 0) {
                buf.append(", ");
            }
            buf.append(rexNode.accept((RexVisitor)inputRefRewriter));
        }
        for (Integer arg : call.getArgList()) {
            if (++i > 0) {
                buf.append(", ");
            }
            buf.append((String)rowType.getFieldNames().get(arg));
        }
        buf.append(')');
        if (call.distinctKeys != null) {
            buf.append(" WITHIN DISTINCT (");
            for (Ord key : Ord.zip((Iterable)call.distinctKeys)) {
                buf.append(key.i > 0 ? ", " : "").append((String)rowType.getFieldNames().get((Integer)key.e));
            }
            buf.append(')');
        }
        if (call.hasCollation()) {
            buf.append(" WITHIN GROUP (").append(RelTreeToTextWriter.beautifyCollation(call.collation, rowType)).append(')');
        }
        if (call.hasFilter()) {
            buf.append(" FILTER ").append((String)rowType.getFieldNames().get(call.filterArg));
        }
        return buf.toString();
    }

    private static List<String> beautifyCollation(RelCollation collation, RelDataType rowType) {
        return collation.getFieldCollations().stream().map(fc -> {
            StringBuilder sb = new StringBuilder((String)rowType.getFieldNames().get(fc.getFieldIndex())).append(' ').append(fc.direction.shortString);
            if (fc.nullDirection != fc.direction.defaultNullDirection()) {
                sb.append(" NULLS ").append(fc.nullDirection);
            }
            return sb.toString();
        }).collect(Collectors.toList());
    }

    private static String beautifyDistribution(IgniteDistribution distribution, RelDataType rowType) {
        StringBuilder sb = new StringBuilder();
        sb.append(distribution.label());
        if (!distribution.getKeys().isEmpty()) {
            sb.append(" by [");
            boolean shouldAppendComma = false;
            Iterator iterator = distribution.getKeys().iterator();
            while (iterator.hasNext()) {
                int idx = (Integer)iterator.next();
                if (shouldAppendComma) {
                    sb.append(", ");
                }
                sb.append((String)rowType.getFieldNames().get(idx));
                shouldAppendComma = true;
            }
            sb.append(']');
        }
        return sb.toString();
    }

    private RelTreeToTextWriter() {
        throw new AssertionError((Object)"Should not be called");
    }

    private static class RelInfoHolder
    implements IgniteRelWriter {
        private final IgniteRel rel;
        private final EnumMap<AttributeName, String> attributes = new EnumMap(AttributeName.class);
        private final List<RelInfoHolder> inputs = new ArrayList<RelInfoHolder>();

        RelInfoHolder(IgniteRel rel) {
            this.rel = rel;
        }

        @Override
        public IgniteRelWriter addChild(IgniteRel rel) {
            RelInfoHolder infoHolder = RelTreeToTextWriter.collectRelInfo(rel);
            this.inputs.add(infoHolder);
            return this;
        }

        @Override
        public IgniteRelWriter addProjection(List<RexNode> projections, RelDataType rowType) {
            RexShuttle inputRefRewriter = ExplainUtils.inputRefRewriter(rowType);
            Function<RexNode, RexNode> f = in -> (RexNode)in.accept((RexVisitor)inputRefRewriter);
            this.attributes.put(AttributeName.PROJECTION, Commons.transform(projections, f).toString());
            return this;
        }

        @Override
        public IgniteRelWriter addPredicate(RexNode condition, RelDataType rowType) {
            this.attributes.put(AttributeName.PREDICATE, ((RexNode)condition.accept((RexVisitor)ExplainUtils.inputRefRewriter(rowType))).toString());
            return this;
        }

        @Override
        public IgniteRelWriter addTable(RelOptTable table) {
            List parts = table.getQualifiedName();
            assert (parts.size() == 2) : parts;
            this.attributes.put(AttributeName.TABLE, QualifiedNameHelper.fromNormalized((String)parts.get(0), (String)parts.get(1)).toCanonicalForm());
            return this;
        }

        @Override
        public IgniteRelWriter addIndex(String name, IgniteIndex.Type type) {
            this.attributes.put(AttributeName.INDEX_NAME, IgniteNameUtils.quoteIfNeeded(name));
            this.attributes.put(AttributeName.INDEX_TYPE, type.name());
            return this;
        }

        @Override
        public IgniteRelWriter addCollation(RelCollation collation, RelDataType rowType) {
            this.attributes.put(AttributeName.COLLATION, RelTreeToTextWriter.beautifyCollation(collation, rowType).toString());
            return this;
        }

        @Override
        public IgniteRelWriter addTuples(List<List<RexLiteral>> tuples) {
            this.attributes.put(AttributeName.TUPLES, tuples.toString());
            return this;
        }

        @Override
        public IgniteRelWriter addJoinType(JoinRelType joinType) {
            this.attributes.put(AttributeName.JOIN_TYPE, joinType.lowerName);
            return this;
        }

        @Override
        public IgniteRelWriter addDistribution(IgniteDistribution distribution, RelDataType rowType) {
            this.attributes.put(AttributeName.DISTRIBUTION, RelTreeToTextWriter.beautifyDistribution(distribution, rowType));
            return this;
        }

        @Override
        public IgniteRelWriter addSourceExpressions(List<RexNode> expressions) {
            this.attributes.put(AttributeName.SOURCE_EXPRESSIONS, expressions.toString());
            return this;
        }

        @Override
        public IgniteRelWriter addModifyOperationType(TableModify.Operation operation) {
            this.attributes.put(AttributeName.MODIFY_OPERATION_TYPE, operation.toString());
            return this;
        }

        @Override
        public IgniteRelWriter addGroup(ImmutableBitSet groupSet, RelDataType rowType) {
            this.attributes.put(AttributeName.GROUP, RelTreeToTextWriter.beautifyBitSet(groupSet, rowType).toString());
            return this;
        }

        @Override
        public IgniteRelWriter addGroupSets(List<ImmutableBitSet> groupSets, RelDataType rowType) {
            List sets = groupSets.stream().map(groupSet -> RelTreeToTextWriter.beautifyBitSet(groupSet, rowType)).collect(Collectors.toList());
            this.attributes.put(AttributeName.GROUP_SETS, sets.toString());
            return this;
        }

        @Override
        public IgniteRelWriter addAggregation(List<AggregateCall> aggCalls, RelDataType rowType) {
            RexShuttle inputRefRewriter = ExplainUtils.inputRefRewriter(rowType);
            List calls = aggCalls.stream().map(call -> RelTreeToTextWriter.beautifyAggCall(call, inputRefRewriter, rowType)).collect(Collectors.toList());
            this.attributes.put(AttributeName.AGGREGATION, calls.toString());
            return this;
        }

        @Override
        public IgniteRelWriter addKeyExpression(List<RexNode> expressions) {
            this.attributes.put(AttributeName.KEY_EXPRESSIONS, expressions.toString());
            return this;
        }

        @Override
        public IgniteRelWriter addCorrelatedVariables(Set<CorrelationId> variablesSet) {
            this.attributes.put(AttributeName.CORRELATED_VARIABLES, variablesSet.toString());
            return this;
        }

        @Override
        public IgniteRelWriter addSearchBounds(List<SearchBounds> searchBounds) {
            this.attributes.put(AttributeName.SEARCH_BOUNDS, searchBounds.toString());
            return this;
        }

        @Override
        public IgniteRelWriter addInvocation(RexNode call) {
            this.attributes.put(AttributeName.INVOCATION, call.toString());
            return this;
        }

        @Override
        public IgniteRelWriter addOffset(RexNode offset) {
            this.attributes.put(AttributeName.OFFSET, offset.toString());
            return this;
        }

        @Override
        public IgniteRelWriter addFetch(RexNode fetch) {
            this.attributes.put(AttributeName.FETCH, fetch.toString());
            return this;
        }

        @Override
        public IgniteRelWriter addAll(boolean all) {
            this.attributes.put(AttributeName.ALL, String.valueOf(all));
            return this;
        }

        @Override
        public IgniteRelWriter addSourceFragmentId(long fragmentId) {
            this.attributes.put(AttributeName.SOURCE_FRAGMENT_ID, String.valueOf(fragmentId));
            return this;
        }

        @Override
        public IgniteRelWriter addTargetFragmentId(long fragmentId) {
            this.attributes.put(AttributeName.TARGET_FRAGMENT_ID, String.valueOf(fragmentId));
            return this;
        }
    }

    private static enum AttributeName {
        TABLE("table"),
        INDEX_NAME("index"),
        INDEX_TYPE("type"),
        PREDICATE("predicate"),
        SEARCH_BOUNDS("searchBounds"),
        FIELD_NAMES("fieldNames"),
        PROJECTION("projection"),
        COLLATION("collation"),
        TUPLES("tuples"),
        JOIN_TYPE("type"),
        DISTRIBUTION("distribution"),
        SOURCE_EXPRESSIONS("sourceExpression"),
        MODIFY_OPERATION_TYPE("type"),
        GROUP("group"),
        GROUP_SETS("groupSets"),
        AGGREGATION("aggregation"),
        KEY_EXPRESSIONS("key"),
        CORRELATED_VARIABLES("correlates"),
        INVOCATION("invocation"),
        OFFSET("offset"),
        FETCH("fetch"),
        ALL("all"),
        SOURCE_FRAGMENT_ID("sourceFragmentId"),
        TARGET_FRAGMENT_ID("targetFragmentId");

        private final String label;

        private AttributeName(String label) {
            this.label = label;
        }
    }
}

