/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.partition.replicator.network.replication;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.ignite3.internal.partition.replicator.network.replication.RequestType;
import org.apache.ignite3.internal.replicator.message.SchemaVersionAwareReplicaRequest;
import org.apache.ignite3.internal.schema.BinaryRow;
import org.apache.ignite3.internal.schema.BinaryRowImpl;
import org.apache.ignite3.internal.tostring.IgniteStringifier;
import org.apache.ignite3.internal.tostring.SizeOnlyStringifier;

public interface MultipleRowReplicaRequest
extends SchemaVersionAwareReplicaRequest {
    @IgniteStringifier(name="binaryTuples.size", value=SizeOnlyStringifier.class)
    public List<ByteBuffer> binaryTuples();

    default public List<BinaryRow> binaryRows() {
        List<ByteBuffer> tuples = this.binaryTuples();
        ArrayList<BinaryRow> rows = new ArrayList<BinaryRow>(tuples.size());
        for (ByteBuffer tuple : tuples) {
            rows.add(new BinaryRowImpl(this.schemaVersion(), tuple));
        }
        return rows;
    }

    public RequestType requestType();
}

