/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.distributionzones.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.ignite3.internal.catalog.CatalogService;
import org.apache.ignite3.internal.catalog.descriptors.CatalogZoneDescriptor;
import org.apache.ignite3.internal.catalog.events.AlterZoneEventParameters;
import org.apache.ignite3.internal.event.EventListener;
import org.apache.ignite3.internal.util.CompletableFutures;

public class CatalogAlterZoneEventListener
implements EventListener<AlterZoneEventParameters> {
    private final CatalogService catalogService;

    public CatalogAlterZoneEventListener(CatalogService catalogService) {
        this.catalogService = catalogService;
    }

    @Override
    public CompletableFuture<Boolean> notify(AlterZoneEventParameters parameters) {
        try {
            CatalogZoneDescriptor newZone = parameters.zoneDescriptor();
            CatalogZoneDescriptor oldZone = this.catalogService.catalog(parameters.catalogVersion() - 1).zone(newZone.id());
            assert (oldZone != null) : "zoneId=" + newZone.id() + ", catalogVersion=" + parameters.catalogVersion();
            return this.notify(parameters, newZone, oldZone).thenApply(unused -> false);
        }
        catch (Throwable t) {
            return CompletableFuture.failedFuture(t);
        }
    }

    private CompletableFuture<Void> notify(AlterZoneEventParameters parameters, CatalogZoneDescriptor newZone, CatalogZoneDescriptor oldZone) {
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        CatalogAlterZoneEventListener.addFuture(futures, this.onZoneUpdate(parameters, oldZone));
        if (newZone.partitions() != oldZone.partitions()) {
            CatalogAlterZoneEventListener.addFuture(futures, this.onPartitionsUpdate(parameters, oldZone.partitions()));
        }
        if (newZone.replicas() != oldZone.replicas()) {
            CatalogAlterZoneEventListener.addFuture(futures, this.onReplicasUpdate(parameters, oldZone.replicas()));
        }
        if (!newZone.filter().equals(oldZone.filter())) {
            CatalogAlterZoneEventListener.addFuture(futures, this.onFilterUpdate(parameters, oldZone.filter()));
        }
        if (newZone.dataNodesAutoAdjustScaleUp() != oldZone.dataNodesAutoAdjustScaleUp()) {
            CatalogAlterZoneEventListener.addFuture(futures, this.onAutoAdjustScaleUpUpdate(parameters, oldZone.dataNodesAutoAdjustScaleUp()));
        }
        if (newZone.dataNodesAutoAdjustScaleDown() != oldZone.dataNodesAutoAdjustScaleDown()) {
            CatalogAlterZoneEventListener.addFuture(futures, this.onAutoAdjustScaleDownUpdate(parameters, oldZone.dataNodesAutoAdjustScaleDown()));
        }
        if (!oldZone.name().equals(newZone.name())) {
            CatalogAlterZoneEventListener.addFuture(futures, this.onNameUpdate(parameters, oldZone.name()));
        }
        return futures.isEmpty() ? CompletableFutures.nullCompletedFuture() : CompletableFuture.allOf((CompletableFuture[])futures.toArray(CompletableFuture[]::new));
    }

    protected CompletableFuture<Void> onZoneUpdate(AlterZoneEventParameters parameters, CatalogZoneDescriptor oldZone) {
        return CompletableFutures.nullCompletedFuture();
    }

    protected CompletableFuture<Void> onPartitionsUpdate(AlterZoneEventParameters parameters, int oldPartitions) {
        return CompletableFutures.nullCompletedFuture();
    }

    protected CompletableFuture<Void> onReplicasUpdate(AlterZoneEventParameters parameters, int oldReplicas) {
        return CompletableFutures.nullCompletedFuture();
    }

    protected CompletableFuture<Void> onFilterUpdate(AlterZoneEventParameters parameters, String oldFilter) {
        return CompletableFutures.nullCompletedFuture();
    }

    protected CompletableFuture<Void> onAutoAdjustScaleUpUpdate(AlterZoneEventParameters parameters, int oldAutoAdjustScaleUp) {
        return CompletableFutures.nullCompletedFuture();
    }

    protected CompletableFuture<Void> onAutoAdjustScaleDownUpdate(AlterZoneEventParameters parameters, int oldAutoAdjustScaleDown) {
        return CompletableFutures.nullCompletedFuture();
    }

    protected CompletableFuture<Void> onNameUpdate(AlterZoneEventParameters parameters, String oldName) {
        return CompletableFutures.nullCompletedFuture();
    }

    private static void addFuture(List<CompletableFuture<Void>> futures, CompletableFuture<Void> future) {
        if (!future.isDone() || future.isCompletedExceptionally()) {
            futures.add(future);
        }
    }
}

