/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.compute.message;

import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.Objects;
import org.apache.ignite3.internal.compute.ComputeJobDataHolder;
import org.apache.ignite3.internal.compute.ExecutionOptions;
import org.apache.ignite3.internal.compute.message.DeploymentUnitMsg;
import org.apache.ignite3.internal.compute.message.ExecuteRequest;
import org.apache.ignite3.internal.compute.message.ExecuteRequestBuilder;
import org.apache.ignite3.internal.compute.message.ExecuteRequestSerializer;
import org.apache.ignite3.internal.network.serialization.MessageSerializer;
import org.apache.ignite3.internal.network.serialization.marshal.MarshalledObject;
import org.apache.ignite3.internal.network.serialization.marshal.UserObjectMarshaller;
import org.apache.ignite3.internal.tostring.IgniteToStringInclude;
import org.apache.ignite3.internal.tostring.S;

public class ExecuteRequestImpl
implements ExecuteRequest,
Cloneable {
    public static final short GROUP_TYPE = 6;
    public static final short TYPE = 0;
    @IgniteToStringInclude
    private final List<DeploymentUnitMsg> deploymentUnits;
    @IgniteToStringInclude
    private ExecutionOptions executeOptions;
    private byte[] executeOptionsByteArray;
    @IgniteToStringInclude
    private ComputeJobDataHolder input;
    private byte[] inputByteArray;
    @IgniteToStringInclude
    private final String jobClassName;

    private ExecuteRequestImpl(List<DeploymentUnitMsg> deploymentUnits, ExecutionOptions executeOptions, byte[] executeOptionsByteArray, ComputeJobDataHolder input, byte[] inputByteArray, String jobClassName) {
        this.deploymentUnits = deploymentUnits;
        if (executeOptions == null && executeOptionsByteArray == null) {
            throw new NullPointerException("executeOptions is not marked @Nullable");
        }
        this.executeOptions = executeOptions;
        this.executeOptionsByteArray = executeOptionsByteArray;
        this.input = input;
        this.inputByteArray = inputByteArray;
        this.jobClassName = jobClassName;
    }

    @Override
    public List<DeploymentUnitMsg> deploymentUnits() {
        return this.deploymentUnits;
    }

    byte[] executeOptionsByteArray() {
        return this.executeOptionsByteArray;
    }

    @Override
    public ExecutionOptions executeOptions() {
        return this.executeOptions;
    }

    byte[] inputByteArray() {
        return this.inputByteArray;
    }

    @Override
    public ComputeJobDataHolder input() {
        return this.input;
    }

    @Override
    public String jobClassName() {
        return this.jobClassName;
    }

    public MessageSerializer serializer() {
        return ExecuteRequestSerializer.INSTANCE;
    }

    @Override
    public short groupType() {
        return 6;
    }

    public String toString() {
        return S.toString(ExecuteRequestImpl.class, this);
    }

    @Override
    public short messageType() {
        return 0;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        ExecuteRequestImpl otherMessage = (ExecuteRequestImpl)other;
        return Objects.equals(this.deploymentUnits, otherMessage.deploymentUnits) && Objects.equals(this.executeOptions, otherMessage.executeOptions) && Objects.equals(this.input, otherMessage.input) && Objects.equals(this.jobClassName, otherMessage.jobClassName);
    }

    public int hashCode() {
        int result = 0;
        result = Objects.hash(this.deploymentUnits, this.executeOptions, this.input, this.jobClassName);
        return result;
    }

    @Override
    public ExecuteRequestImpl clone() {
        try {
            return (ExecuteRequestImpl)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static ExecuteRequestBuilder builder() {
        return new Builder();
    }

    @Override
    public void prepareMarshal(IntSet usedDescriptors, Object marshallerObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.deploymentUnits != null) {
            for (DeploymentUnitMsg obj : this.deploymentUnits) {
                if (obj == null) continue;
                obj.prepareMarshal(usedDescriptors, marshaller);
            }
        }
        MarshalledObject executeOptionsByteArraymo = marshaller.marshal(this.executeOptions);
        usedDescriptors.addAll((IntCollection)executeOptionsByteArraymo.usedDescriptorIds());
        this.executeOptionsByteArray = executeOptionsByteArraymo.bytes();
        MarshalledObject inputByteArraymo = marshaller.marshal(this.input);
        usedDescriptors.addAll((IntCollection)inputByteArraymo.usedDescriptorIds());
        this.inputByteArray = inputByteArraymo.bytes();
    }

    @Override
    public void unmarshal(Object marshallerObj, Object descriptorsObj) throws Exception {
        UserObjectMarshaller marshaller = (UserObjectMarshaller)marshallerObj;
        if (this.deploymentUnits != null) {
            for (DeploymentUnitMsg obj : this.deploymentUnits) {
                if (obj == null) continue;
                obj.unmarshal(marshaller, descriptorsObj);
            }
        }
        this.executeOptions = (ExecutionOptions)marshaller.unmarshal(this.executeOptionsByteArray, descriptorsObj);
        this.executeOptionsByteArray = null;
        this.input = (ComputeJobDataHolder)marshaller.unmarshal(this.inputByteArray, descriptorsObj);
        this.inputByteArray = null;
    }

    private static class Builder
    implements ExecuteRequestBuilder {
        private List<DeploymentUnitMsg> deploymentUnits;
        private ExecutionOptions executeOptions;
        private byte[] executeOptionsByteArray;
        private ComputeJobDataHolder input;
        private byte[] inputByteArray;
        private String jobClassName;

        private Builder() {
        }

        @Override
        public ExecuteRequestBuilder deploymentUnits(List<DeploymentUnitMsg> deploymentUnits) {
            Objects.requireNonNull(deploymentUnits, "deploymentUnits is not marked @Nullable");
            this.deploymentUnits = deploymentUnits;
            return this;
        }

        @Override
        public ExecuteRequestBuilder executeOptions(ExecutionOptions executeOptions) {
            Objects.requireNonNull(executeOptions, "executeOptions is not marked @Nullable");
            this.executeOptions = executeOptions;
            return this;
        }

        @Override
        public ExecuteRequestBuilder executeOptionsByteArray(byte[] executeOptionsByteArray) {
            this.executeOptionsByteArray = executeOptionsByteArray;
            return this;
        }

        @Override
        public ExecuteRequestBuilder input(ComputeJobDataHolder input) {
            this.input = input;
            return this;
        }

        @Override
        public ExecuteRequestBuilder inputByteArray(byte[] inputByteArray) {
            this.inputByteArray = inputByteArray;
            return this;
        }

        @Override
        public ExecuteRequestBuilder jobClassName(String jobClassName) {
            Objects.requireNonNull(jobClassName, "jobClassName is not marked @Nullable");
            this.jobClassName = jobClassName;
            return this;
        }

        @Override
        public List<DeploymentUnitMsg> deploymentUnits() {
            return this.deploymentUnits;
        }

        @Override
        public ExecutionOptions executeOptions() {
            return this.executeOptions;
        }

        @Override
        public byte[] executeOptionsByteArray() {
            return this.executeOptionsByteArray;
        }

        @Override
        public ComputeJobDataHolder input() {
            return this.input;
        }

        @Override
        public byte[] inputByteArray() {
            return this.inputByteArray;
        }

        @Override
        public String jobClassName() {
            return this.jobClassName;
        }

        @Override
        public ExecuteRequest build() {
            return new ExecuteRequestImpl(Objects.requireNonNull(this.deploymentUnits, "deploymentUnits is not marked @Nullable"), this.executeOptions, this.executeOptionsByteArray, this.input, this.inputByteArray, Objects.requireNonNull(this.jobClassName, "jobClassName is not marked @Nullable"));
        }
    }
}

