/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.pagemem.wal.record;

import java.util.Set;
import java.util.UUID;
import org.apache.ignite.internal.pagemem.wal.record.WALRecord;
import org.apache.ignite.internal.processors.cache.persistence.tree.io.CacheVersionIO;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.tostring.GridToStringInclude;
import org.apache.ignite.internal.util.typedef.internal.S;

public class IncrementalSnapshotFinishRecord
extends WALRecord {
    @GridToStringInclude
    private final UUID id;
    @GridToStringInclude
    private final Set<GridCacheVersion> included;
    @GridToStringInclude
    private final Set<GridCacheVersion> excluded;

    public IncrementalSnapshotFinishRecord(UUID id, Set<GridCacheVersion> included, Set<GridCacheVersion> excluded) {
        this.id = id;
        this.included = included;
        this.excluded = excluded;
    }

    public Set<GridCacheVersion> included() {
        return this.included;
    }

    public Set<GridCacheVersion> excluded() {
        return this.excluded;
    }

    public UUID id() {
        return this.id;
    }

    @Override
    public WALRecord.RecordType type() {
        return WALRecord.RecordType.INCREMENTAL_SNAPSHOT_FINISH_RECORD;
    }

    public int dataSize() {
        int size = 24;
        for (GridCacheVersion v : this.included) {
            size += CacheVersionIO.size(v, false);
        }
        for (GridCacheVersion v : this.excluded) {
            size += CacheVersionIO.size(v, false);
        }
        return size;
    }

    @Override
    public String toString() {
        return S.toString(IncrementalSnapshotFinishRecord.class, this);
    }
}

