/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.management.tx;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import org.apache.ignite.Ignite;
import org.apache.ignite.client.IgniteClient;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.client.GridClient;
import org.apache.ignite.internal.client.GridClientNode;
import org.apache.ignite.internal.management.api.CommandUtils;
import org.apache.ignite.internal.management.api.LocalCommand;
import org.apache.ignite.internal.management.tx.FetchNearXidVersionTask;
import org.apache.ignite.internal.management.tx.TxCommand;
import org.apache.ignite.internal.management.tx.TxInfo;
import org.apache.ignite.internal.management.tx.TxInfoCommandArg;
import org.apache.ignite.internal.management.tx.TxKeyLockType;
import org.apache.ignite.internal.management.tx.TxMappingType;
import org.apache.ignite.internal.management.tx.TxTask;
import org.apache.ignite.internal.management.tx.TxTaskResult;
import org.apache.ignite.internal.management.tx.TxVerboseInfo;
import org.apache.ignite.internal.management.tx.TxVerboseKey;
import org.apache.ignite.internal.processors.cache.version.GridCacheVersion;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.transactions.TransactionState;
import org.jetbrains.annotations.Nullable;

public class TxInfoCommand
implements LocalCommand<TxCommand.AbstractTxCommandArg, Map<ClusterNode, TxTaskResult>> {
    @Override
    public String description() {
        return "Print detailed information (topology and key lock ownership) about specific transaction";
    }

    @Override
    public Class<TxInfoCommandArg> argClass() {
        return TxInfoCommandArg.class;
    }

    @Override
    public Map<ClusterNode, TxTaskResult> execute(@Nullable GridClient cli, @Nullable IgniteClient client, @Nullable Ignite ignite, TxCommand.AbstractTxCommandArg arg0, Consumer<String> printer) throws Exception {
        TxInfoCommandArg arg = (TxInfoCommandArg)arg0;
        Optional<GridClientNode> node = CommandUtils.nodes(cli, client, ignite).stream().filter(n -> !n.isClient()).filter(GridClientNode::connectable).findFirst();
        if (!node.isPresent()) {
            throw new IllegalStateException("No nodes to connect");
        }
        GridCacheVersion nearXidVer = (GridCacheVersion)CommandUtils.execute(cli, client, ignite, FetchNearXidVersionTask.class, arg, Collections.singleton(node.get()));
        boolean histMode = false;
        if (nearXidVer != null) {
            printer.accept("Resolved transaction near XID version: " + nearXidVer);
            arg = new TxInfoCommandArg();
            arg.gridCacheVersion(nearXidVer);
        } else {
            printer.accept("Active transactions not found.");
            if (arg.gridCacheVersion() != null) {
                printer.accept("Will try to peek history to find out whether transaction was committed / rolled back.");
                histMode = true;
            } else {
                printer.accept("You can specify transaction in GridCacheVersion format in order to peek history to find out whether transaction was committed / rolled back.");
                return null;
            }
        }
        Map res = (Map)CommandUtils.execute(cli, client, ignite, TxTask.class, arg, Collections.singleton(node.get()));
        if (histMode) {
            this.printTxInfoHistoricalResult(res, printer);
        } else {
            this.printTxInfoResult(res, printer);
        }
        return res;
    }

    private void printTxInfoHistoricalResult(Map<ClusterNode, TxTaskResult> res, Consumer<String> printer) {
        if (F.isEmpty(res)) {
            printer.accept("Transaction was not found in history across the cluster.");
        } else {
            printer.accept("Transaction was found in completed versions history of the following nodes:");
            for (Map.Entry<ClusterNode, TxTaskResult> entry : res.entrySet()) {
                printer.accept("    " + TxCommand.nodeDescription(entry.getKey()) + ":");
                printer.accept("        State: " + entry.getValue().getInfos().get(0).getState());
            }
        }
    }

    private void printTxInfoResult(Map<ClusterNode, TxTaskResult> res, Consumer<String> printer) {
        String lb = null;
        HashMap<Integer, String> usedCaches = new HashMap<Integer, String>();
        HashMap<Integer, String> usedCacheGrps = new HashMap<Integer, String>();
        TxInfo firstInfo = null;
        TxVerboseInfo firstVerboseInfo = null;
        HashSet<TransactionState> states = new HashSet<TransactionState>();
        for (Map.Entry<ClusterNode, TxTaskResult> entry : res.entrySet()) {
            for (TxInfo info : entry.getValue().getInfos()) {
                assert (info.getTxVerboseInfo() != null);
                if (lb == null) {
                    lb = info.getLabel();
                }
                if (firstInfo == null) {
                    firstInfo = info;
                    firstVerboseInfo = info.getTxVerboseInfo();
                }
                usedCaches.putAll(info.getTxVerboseInfo().usedCaches());
                usedCacheGrps.putAll(info.getTxVerboseInfo().usedCacheGroups());
                states.add(info.getState());
            }
        }
        String indent = "";
        printer.accept("");
        printer.accept(indent + "Transaction detailed info:");
        this.printTransactionDetailedInfo(res, usedCaches, usedCacheGrps, firstInfo, firstVerboseInfo, states, indent + "    ", printer);
    }

    private void printTransactionDetailedInfo(Map<ClusterNode, TxTaskResult> res, Map<Integer, String> usedCaches, Map<Integer, String> usedCacheGroups, TxInfo firstInfo, TxVerboseInfo firstVerboseInfo, Set<TransactionState> states, String indent, Consumer<String> printer) {
        printer.accept(indent + "Near XID version: " + (firstVerboseInfo == null ? null : firstVerboseInfo.nearXidVersion()));
        printer.accept(indent + "Near XID version (UUID): " + (firstInfo == null ? null : firstInfo.getNearXid()));
        printer.accept(indent + "Isolation: " + (firstInfo == null ? null : firstInfo.getIsolation()));
        printer.accept(indent + "Concurrency: " + (firstInfo == null ? null : firstInfo.getConcurrency()));
        printer.accept(indent + "Timeout: " + (firstInfo == null ? null : Long.valueOf(firstInfo.getTimeout())));
        printer.accept(indent + "Initiator node: " + (firstVerboseInfo == null ? null : firstVerboseInfo.nearNodeId()));
        printer.accept(indent + "Initiator node (consistent ID): " + (firstVerboseInfo == null ? null : firstVerboseInfo.nearNodeConsistentId()));
        printer.accept(indent + "Label: " + (firstInfo == null ? null : firstInfo.getLabel()));
        printer.accept(indent + "Topology version: " + (firstInfo == null ? null : firstInfo.getTopologyVersion()));
        printer.accept(indent + "Used caches (ID to name): " + usedCaches);
        printer.accept(indent + "Used cache groups (ID to name): " + usedCacheGroups);
        printer.accept(indent + "States across the cluster: " + states);
        printer.accept(indent + "Transaction topology: ");
        this.printTransactionTopology(res, indent + "    ", printer);
    }

    private void printTransactionTopology(Map<ClusterNode, TxTaskResult> res, String indent, Consumer<String> printer) {
        for (Map.Entry<ClusterNode, TxTaskResult> entry : res.entrySet()) {
            printer.accept(indent + TxCommand.nodeDescription(entry.getKey()) + ":");
            this.printTransactionMappings(indent + "    ", entry, printer);
        }
    }

    private void printTransactionMappings(String indent, Map.Entry<ClusterNode, TxTaskResult> entry, Consumer<String> printer) {
        for (TxInfo info : entry.getValue().getInfos()) {
            TxVerboseInfo verboseInfo = info.getTxVerboseInfo();
            if (verboseInfo != null) {
                printer.accept(indent + "Mapping [type=" + verboseInfo.txMappingType() + "]:");
                this.printTransactionMapping(indent + "    ", info, verboseInfo, printer);
                continue;
            }
            printer.accept(indent + "Mapping [type=HISTORICAL]:");
            printer.accept(indent + "    State: " + info.getState());
        }
    }

    private void printTransactionMapping(String indent, TxInfo info, TxVerboseInfo verboseInfo, Consumer<String> printer) {
        printer.accept(indent + "XID version (UUID): " + info.getXid());
        printer.accept(indent + "State: " + info.getState());
        if (verboseInfo.txMappingType() == TxMappingType.REMOTE) {
            printer.accept(indent + "Primary node: " + verboseInfo.dhtNodeId());
            printer.accept(indent + "Primary node (consistent ID): " + verboseInfo.dhtNodeConsistentId());
        }
        if (!F.isEmpty(verboseInfo.localTxKeys())) {
            printer.accept(indent + "Mapped keys:");
            this.printTransactionKeys(indent + "    ", verboseInfo, printer);
        }
    }

    private void printTransactionKeys(String indent, TxVerboseInfo verboseInfo, Consumer<String> printer) {
        for (TxVerboseKey txVerboseKey : verboseInfo.localTxKeys()) {
            printer.accept(indent + (txVerboseKey.read() ? "Read" : "Write") + " [lock=" + txVerboseKey.lockType() + "]: " + txVerboseKey.txKey());
            if (txVerboseKey.lockType() != TxKeyLockType.AWAITS_LOCK) continue;
            printer.accept(indent + "    Lock owner XID: " + txVerboseKey.ownerVersion());
        }
    }
}

