/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.security.authentication;

import io.micronaut.security.authentication.Authentication;
import io.micronaut.security.authentication.AuthenticationFailureReason;
import io.micronaut.security.authentication.AuthenticationResponse;
import java.util.Objects;
import java.util.Optional;

public class AuthenticationFailed
implements AuthenticationResponse {
    private final AuthenticationFailureReason authenticationFailure;
    private final String message;

    public AuthenticationFailed() {
        this(AuthenticationFailureReason.UNKNOWN);
    }

    public AuthenticationFailed(AuthenticationFailureReason authenticationFailure) {
        this.authenticationFailure = authenticationFailure;
        this.message = this.createMessage(authenticationFailure);
    }

    public AuthenticationFailed(String message) {
        this.authenticationFailure = AuthenticationFailureReason.CUSTOM;
        this.message = message;
    }

    protected String createMessage(AuthenticationFailureReason authenticationFailure) {
        StringBuilder sb = new StringBuilder(authenticationFailure.name().toLowerCase());
        for (int i = 0; i < sb.length(); ++i) {
            int end = i + 1;
            if (i == 0) {
                sb.replace(i, end, String.valueOf(Character.toUpperCase(sb.charAt(i))));
            }
            if (sb.charAt(i) != '_') continue;
            sb.replace(i, end, " ");
            sb.replace(end, end + 1, String.valueOf(Character.toUpperCase(sb.charAt(i + 1))));
        }
        return sb.toString();
    }

    @Override
    public Optional<Authentication> getAuthentication() {
        return Optional.empty();
    }

    @Override
    public Optional<String> getMessage() {
        return Optional.of(this.message);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AuthenticationFailed that = (AuthenticationFailed)o;
        return this.authenticationFailure == that.authenticationFailure;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.authenticationFailure});
    }

    public AuthenticationFailureReason getReason() {
        return this.authenticationFailure;
    }
}

