/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cli.core.style;

import picocli.CommandLine;

public final class AnsiStringSupport {
    private AnsiStringSupport() {
    }

    public static String ansi(String markupText) {
        return CommandLine.Help.Ansi.AUTO.string(markupText);
    }

    public static Fg fg(Color color) {
        return new Fg(color);
    }

    public static class Fg
    implements Marker {
        private final Color color;
        private Style style;

        private Fg(Color color) {
            this.color = color;
        }

        public Fg with(Style style) {
            this.style = style;
            return this;
        }

        @Override
        public String mark(String textToMark) {
            if (this.style == Style.BOLD) {
                return String.format("@|fg(%d),bold %s|@", this.color.code, textToMark);
            }
            return String.format("@|fg(%d) %s|@", this.color.code, textToMark);
        }
    }

    public static enum Color {
        RED(1),
        GREEN(2),
        YELLOW(3),
        BLUE(31),
        YELLOW_DARK(215),
        GREEN_DARK(22),
        GRAY(246),
        WHITE(252);

        private final int code;

        private Color(int code) {
            this.code = code;
        }
    }

    public static enum Style implements Marker
    {
        BOLD("bold"),
        UNDERLINE("underline");

        private final String value;

        private Style(String value) {
            this.value = value;
        }

        @Override
        public String mark(String textToMark) {
            return String.format("@|%s %s|@", this.value, textToMark);
        }
    }

    public static interface Marker {
        public String mark(String var1);
    }
}

