/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.internal;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;

class StackTraceRenderer {
    private static final String CAUSED_BY = "Caused by: ";
    private static final String SUPPRESSED = "Suppressed: ";
    private final Throwable throwable;
    private final int lengthLimit;
    private final StringBuilder builder = new StringBuilder();

    StackTraceRenderer(Throwable throwable, int lengthLimit) {
        this.throwable = throwable;
        this.lengthLimit = lengthLimit;
    }

    String render() {
        if (this.builder.length() == 0) {
            this.appendStackTrace();
        }
        return this.builder.substring(0, Math.min(this.builder.length(), this.lengthLimit));
    }

    private void appendStackTrace() {
        StackTraceElement[] stackTraceElements;
        this.builder.append(this.throwable).append(System.lineSeparator());
        if (this.isOverLimit()) {
            return;
        }
        for (StackTraceElement stackTraceElement : stackTraceElements = this.throwable.getStackTrace()) {
            this.builder.append("\tat ").append(stackTraceElement).append(System.lineSeparator());
            if (!this.isOverLimit()) continue;
            return;
        }
        Set<Throwable> seen = Collections.newSetFromMap(new IdentityHashMap());
        seen.add(this.throwable);
        for (Throwable suppressed : this.throwable.getSuppressed()) {
            this.appendInnerStacktrace(stackTraceElements, suppressed, "\t", SUPPRESSED, seen);
        }
        Throwable cause = this.throwable.getCause();
        if (cause != null) {
            this.appendInnerStacktrace(stackTraceElements, cause, "", CAUSED_BY, seen);
        }
    }

    private boolean appendInnerStacktrace(StackTraceElement[] parentElements, Throwable innerThrowable, String prefix, String caption, Set<Throwable> seen) {
        int lastSharedFrameIndex;
        if (seen.contains(innerThrowable)) {
            this.builder.append(prefix).append(caption).append("[CIRCULAR REFERENCE: ").append(innerThrowable).append("]").append(System.lineSeparator());
            return true;
        }
        seen.add(innerThrowable);
        StackTraceElement[] currentElements = innerThrowable.getStackTrace();
        int parentIndex = parentElements.length - 1;
        for (lastSharedFrameIndex = currentElements.length - 1; parentIndex >= 0 && lastSharedFrameIndex >= 0 && parentElements[parentIndex].equals(currentElements[lastSharedFrameIndex]); --parentIndex, --lastSharedFrameIndex) {
        }
        this.builder.append(prefix).append(caption).append(innerThrowable).append(System.lineSeparator());
        if (this.isOverLimit()) {
            return true;
        }
        for (int i = 0; i <= lastSharedFrameIndex; ++i) {
            Throwable[] stackTraceElement = currentElements[i];
            this.builder.append(prefix).append("\tat ").append(stackTraceElement).append(System.lineSeparator());
            if (!this.isOverLimit()) continue;
            return true;
        }
        int duplicateFrames = currentElements.length - 1 - lastSharedFrameIndex;
        if (duplicateFrames != 0) {
            this.builder.append(prefix).append("\t... ").append(duplicateFrames).append(" more").append(System.lineSeparator());
            if (this.isOverLimit()) {
                return true;
            }
        }
        for (Throwable suppressed : innerThrowable.getSuppressed()) {
            if (!this.appendInnerStacktrace(currentElements, suppressed, prefix + "\t", SUPPRESSED, seen)) continue;
            return true;
        }
        Throwable cause = innerThrowable.getCause();
        if (cause != null) {
            return this.appendInnerStacktrace(currentElements, cause, prefix, CAUSED_BY, seen);
        }
        return false;
    }

    private boolean isOverLimit() {
        return this.builder.length() >= this.lengthLimit;
    }
}

