/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hugegraph.computer.core.sender;

import java.io.IOException;
import org.apache.hugegraph.computer.core.common.ComputerContext;
import org.apache.hugegraph.computer.core.common.exception.ComputerException;
import org.apache.hugegraph.computer.core.graph.id.Id;
import org.apache.hugegraph.computer.core.graph.value.Value;
import org.apache.hugegraph.computer.core.graph.vertex.Vertex;
import org.apache.hugegraph.computer.core.io.BytesOutput;
import org.apache.hugegraph.computer.core.io.IOFactory;
import org.apache.hugegraph.computer.core.io.RandomAccessInput;
import org.apache.hugegraph.computer.core.receiver.MessageStat;
import org.apache.hugegraph.computer.core.sender.WriteBuffer;
import org.apache.hugegraph.util.E;

public class WriteBuffers {
    private WriteBuffer writingBuffer;
    private WriteBuffer sortingBuffer;
    private long totalCount;
    private long totalBytes;

    public WriteBuffers(ComputerContext context, int threshold, int capacity) {
        E.checkArgument((threshold > 0 ? 1 : 0) != 0, (String)"The threshold of buffer must be > 0, actual got %s", (Object[])new Object[]{threshold});
        E.checkArgument((capacity > 0 ? 1 : 0) != 0, (String)"The capacity of buffer must be > 0, actual got %s", (Object[])new Object[]{capacity});
        E.checkArgument((threshold <= capacity ? 1 : 0) != 0, (String)"The threshold must be <= capacity, actual got %s > %s", (Object[])new Object[]{threshold, capacity});
        this.writingBuffer = new WriteBuffer(context, threshold, capacity);
        this.sortingBuffer = new WriteBuffer(context, threshold, capacity);
        this.totalCount = 0L;
        this.totalBytes = 0L;
    }

    public boolean reachThreshold() {
        return this.writingBuffer.reachThreshold();
    }

    public boolean isEmpty() {
        return this.writingBuffer.isEmpty();
    }

    public void resetMessageWritten() {
        this.totalCount = 0L;
        this.totalBytes = 0L;
    }

    public MessageStat messageWritten() {
        return new MessageStat(this.totalCount, this.totalBytes);
    }

    public synchronized void writeVertex(Vertex vertex) throws IOException {
        this.writingBuffer.writeVertex(vertex);
    }

    public synchronized void writeEdges(Vertex vertex) throws IOException {
        this.writingBuffer.writeEdges(vertex);
    }

    public synchronized void writeMessage(Id targetId, Value value) throws IOException {
        this.writingBuffer.writeMessage(targetId, value);
    }

    public synchronized void switchForSorting() {
        if (!this.reachThreshold()) {
            return;
        }
        this.prepareSorting();
    }

    public synchronized void prepareSorting() {
        while (!this.sortingBuffer.isEmpty()) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new ComputerException("Interrupted when waiting sorting buffer empty");
            }
        }
        this.totalCount += this.writingBuffer.writeCount();
        this.totalBytes += this.writingBuffer.numBytes();
        WriteBuffer temp = this.writingBuffer;
        this.writingBuffer = this.sortingBuffer;
        this.sortingBuffer = temp;
    }

    public synchronized void finishSorting() {
        try {
            this.sortingBuffer.clear();
        }
        catch (IOException e) {
            throw new ComputerException("Failed to clear sorting buffer");
        }
        this.notify();
    }

    public synchronized RandomAccessInput wrapForRead() {
        BytesOutput output = this.sortingBuffer.output();
        return IOFactory.createBytesInput(output.buffer(), (int)output.position());
    }
}

