/*
 * Decompiled with CFR 0.152.
 */
package org.pcap4j.packet;

import java.util.Arrays;
import org.pcap4j.packet.Dot11InformationElement;
import org.pcap4j.packet.IllegalRawDataException;
import org.pcap4j.packet.namednumber.Dot11InformationElementId;
import org.pcap4j.packet.namednumber.Dot11ServiceIntervalGranularity;
import org.pcap4j.util.ByteArrays;

public final class Dot11ExtendedCapabilitiesElement
extends Dot11InformationElement {
    private static final long serialVersionUID = 5039470467536222487L;
    private final Boolean twentyFortyBssCoexistenceManagementSupported;
    private final Boolean bit1;
    private final Boolean extendedChannelSwitchingSupported;
    private final Boolean bit3;
    private final Boolean psmpOperationSupported;
    private final Boolean bit5;
    private final Boolean scheduledPsmpSupported;
    private final Boolean eventActivated;
    private final Boolean diagnosticsActivated;
    private final Boolean multicastDiagnosticsActivated;
    private final Boolean locationTrackingActivated;
    private final Boolean fmsActivated;
    private final Boolean proxyArpServiceActivated;
    private final Boolean collocatedInterferenceReportingActivated;
    private final Boolean rmCivicMeasurementActivated;
    private final Boolean rmLciMeasurementActivated;
    private final Boolean tfsActivated;
    private final Boolean wnmSleepModeActivated;
    private final Boolean timBroadcastActivated;
    private final Boolean bssTransitionActivated;
    private final Boolean qosTrafficCapabilityActivated;
    private final Boolean acStationCountActivated;
    private final Boolean multiBssIdActivated;
    private final Boolean timingMeasurementActivated;
    private final Boolean channelUsageActivated;
    private final Boolean ssidListActivated;
    private final Boolean dmsActivated;
    private final Boolean utcTsfOffsetActivated;
    private final Boolean tdlsPeerUapsdBufferStaSupported;
    private final Boolean tdlsPeerPsmSupported;
    private final Boolean tdlsChannelSwitchingActivated;
    private final Boolean interworkingServiceActivated;
    private final Boolean qosMapActivated;
    private final Boolean ebrActivated;
    private final Boolean sspnInterfaceActivated;
    private final Boolean bit35;
    private final Boolean msgcfActivated;
    private final Boolean tdlsSupported;
    private final Boolean tdlsProhibited;
    private final Boolean tdlsChannelSwitchingProhibited;
    private final Boolean rejectingUnadmittedTraffic;
    private final Dot11ServiceIntervalGranularity serviceIntervalGranularity;
    private final Boolean rmIdentifierMeasurementActivated;
    private final Boolean uapsdCoexistenceActivated;
    private final Boolean wnmNotificationActivated;
    private final Boolean bit47;
    private final Boolean utf8Ssid;
    private final Boolean bit49;
    private final Boolean bit50;
    private final Boolean bit51;
    private final Boolean bit52;
    private final Boolean bit53;
    private final Boolean bit54;
    private final Boolean bit55;
    private final byte[] trailingData;
    private final int actualLength;

    public static Dot11ExtendedCapabilitiesElement newInstance(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        ByteArrays.validateBounds(rawData, offset, length);
        return new Dot11ExtendedCapabilitiesElement(rawData, offset, length);
    }

    private Dot11ExtendedCapabilitiesElement(byte[] rawData, int offset, int length) throws IllegalRawDataException {
        super(rawData, offset, length, Dot11InformationElementId.EXTENDED_CAPABILITIES);
        this.actualLength = this.getLengthAsInt();
        if (this.actualLength > 0) {
            this.twentyFortyBssCoexistenceManagementSupported = (rawData[offset + 2] & 1) != 0;
            this.bit1 = (rawData[offset + 2] & 2) != 0;
            this.extendedChannelSwitchingSupported = (rawData[offset + 2] & 4) != 0;
            this.bit3 = (rawData[offset + 2] & 8) != 0;
            this.psmpOperationSupported = (rawData[offset + 2] & 0x10) != 0;
            this.bit5 = (rawData[offset + 2] & 0x20) != 0;
            this.scheduledPsmpSupported = (rawData[offset + 2] & 0x40) != 0;
            this.eventActivated = (rawData[offset + 2] & 0x80) != 0;
        } else {
            this.twentyFortyBssCoexistenceManagementSupported = null;
            this.bit1 = null;
            this.extendedChannelSwitchingSupported = null;
            this.bit3 = null;
            this.psmpOperationSupported = null;
            this.bit5 = null;
            this.scheduledPsmpSupported = null;
            this.eventActivated = null;
        }
        if (this.actualLength > 1) {
            this.diagnosticsActivated = (rawData[offset + 3] & 1) != 0;
            this.multicastDiagnosticsActivated = (rawData[offset + 3] & 2) != 0;
            this.locationTrackingActivated = (rawData[offset + 3] & 4) != 0;
            this.fmsActivated = (rawData[offset + 3] & 8) != 0;
            this.proxyArpServiceActivated = (rawData[offset + 3] & 0x10) != 0;
            this.collocatedInterferenceReportingActivated = (rawData[offset + 3] & 0x20) != 0;
            this.rmCivicMeasurementActivated = (rawData[offset + 3] & 0x40) != 0;
            this.rmLciMeasurementActivated = (rawData[offset + 3] & 0x80) != 0;
        } else {
            this.diagnosticsActivated = null;
            this.multicastDiagnosticsActivated = null;
            this.locationTrackingActivated = null;
            this.fmsActivated = null;
            this.proxyArpServiceActivated = null;
            this.collocatedInterferenceReportingActivated = null;
            this.rmCivicMeasurementActivated = null;
            this.rmLciMeasurementActivated = null;
        }
        if (this.actualLength > 2) {
            this.tfsActivated = (rawData[offset + 4] & 1) != 0;
            this.wnmSleepModeActivated = (rawData[offset + 4] & 2) != 0;
            this.timBroadcastActivated = (rawData[offset + 4] & 4) != 0;
            this.bssTransitionActivated = (rawData[offset + 4] & 8) != 0;
            this.qosTrafficCapabilityActivated = (rawData[offset + 4] & 0x10) != 0;
            this.acStationCountActivated = (rawData[offset + 4] & 0x20) != 0;
            this.multiBssIdActivated = (rawData[offset + 4] & 0x40) != 0;
            this.timingMeasurementActivated = (rawData[offset + 4] & 0x80) != 0;
        } else {
            this.tfsActivated = null;
            this.wnmSleepModeActivated = null;
            this.timBroadcastActivated = null;
            this.bssTransitionActivated = null;
            this.qosTrafficCapabilityActivated = null;
            this.acStationCountActivated = null;
            this.multiBssIdActivated = null;
            this.timingMeasurementActivated = null;
        }
        if (this.actualLength > 3) {
            this.channelUsageActivated = (rawData[offset + 5] & 1) != 0;
            this.ssidListActivated = (rawData[offset + 5] & 2) != 0;
            this.dmsActivated = (rawData[offset + 5] & 4) != 0;
            this.utcTsfOffsetActivated = (rawData[offset + 5] & 8) != 0;
            this.tdlsPeerUapsdBufferStaSupported = (rawData[offset + 5] & 0x10) != 0;
            this.tdlsPeerPsmSupported = (rawData[offset + 5] & 0x20) != 0;
            this.tdlsChannelSwitchingActivated = (rawData[offset + 5] & 0x40) != 0;
            this.interworkingServiceActivated = (rawData[offset + 5] & 0x80) != 0;
        } else {
            this.channelUsageActivated = null;
            this.ssidListActivated = null;
            this.dmsActivated = null;
            this.utcTsfOffsetActivated = null;
            this.tdlsPeerUapsdBufferStaSupported = null;
            this.tdlsPeerPsmSupported = null;
            this.tdlsChannelSwitchingActivated = null;
            this.interworkingServiceActivated = null;
        }
        if (this.actualLength > 4) {
            this.qosMapActivated = (rawData[offset + 6] & 1) != 0;
            this.ebrActivated = (rawData[offset + 6] & 2) != 0;
            this.sspnInterfaceActivated = (rawData[offset + 6] & 4) != 0;
            this.bit35 = (rawData[offset + 6] & 8) != 0;
            this.msgcfActivated = (rawData[offset + 6] & 0x10) != 0;
            this.tdlsSupported = (rawData[offset + 6] & 0x20) != 0;
            this.tdlsProhibited = (rawData[offset + 6] & 0x40) != 0;
            this.tdlsChannelSwitchingProhibited = (rawData[offset + 6] & 0x80) != 0;
        } else {
            this.qosMapActivated = null;
            this.ebrActivated = null;
            this.sspnInterfaceActivated = null;
            this.bit35 = null;
            this.msgcfActivated = null;
            this.tdlsSupported = null;
            this.tdlsProhibited = null;
            this.tdlsChannelSwitchingProhibited = null;
        }
        if (this.actualLength > 5) {
            this.rejectingUnadmittedTraffic = (rawData[offset + 7] & 1) != 0;
            this.serviceIntervalGranularity = Dot11ServiceIntervalGranularity.getInstance((byte)((rawData[offset + 7] & 0xE) >> 1));
            this.rmIdentifierMeasurementActivated = (rawData[offset + 7] & 0x10) != 0;
            this.uapsdCoexistenceActivated = (rawData[offset + 7] & 0x20) != 0;
            this.wnmNotificationActivated = (rawData[offset + 7] & 0x40) != 0;
            this.bit47 = (rawData[offset + 7] & 0x80) != 0;
        } else {
            this.rejectingUnadmittedTraffic = null;
            this.serviceIntervalGranularity = null;
            this.rmIdentifierMeasurementActivated = null;
            this.uapsdCoexistenceActivated = null;
            this.wnmNotificationActivated = null;
            this.bit47 = null;
        }
        if (this.actualLength > 6) {
            this.utf8Ssid = (rawData[offset + 8] & 1) != 0;
            this.bit49 = (rawData[offset + 8] & 2) != 0;
            this.bit50 = (rawData[offset + 8] & 4) != 0;
            this.bit51 = (rawData[offset + 8] & 8) != 0;
            this.bit52 = (rawData[offset + 8] & 0x10) != 0;
            this.bit53 = (rawData[offset + 8] & 0x20) != 0;
            this.bit54 = (rawData[offset + 8] & 0x40) != 0;
            this.bit55 = (rawData[offset + 8] & 0x80) != 0;
        } else {
            this.utf8Ssid = null;
            this.bit49 = null;
            this.bit50 = null;
            this.bit51 = null;
            this.bit52 = null;
            this.bit53 = null;
            this.bit54 = null;
            this.bit55 = null;
        }
        this.trailingData = (byte[])(this.actualLength > 7 ? ByteArrays.getSubArray(rawData, offset + 9, this.actualLength - 7) : null);
    }

    private Dot11ExtendedCapabilitiesElement(Builder builder) {
        super(builder);
        if (builder.trailingData.length > 248) {
            throw new IllegalArgumentException("Too long trailingData: " + ByteArrays.toHexString(builder.trailingData, " "));
        }
        this.actualLength = builder.getCorrectLengthAtBuild() ? this.getLengthAsInt() : Dot11ExtendedCapabilitiesElement.calcActualLength(builder);
        this.twentyFortyBssCoexistenceManagementSupported = builder.twentyFortyBssCoexistenceManagementSupported;
        this.bit1 = builder.bit1;
        this.extendedChannelSwitchingSupported = builder.extendedChannelSwitchingSupported;
        this.bit3 = builder.bit3;
        this.psmpOperationSupported = builder.psmpOperationSupported;
        this.bit5 = builder.bit5;
        this.scheduledPsmpSupported = builder.scheduledPsmpSupported;
        this.eventActivated = builder.eventActivated;
        this.diagnosticsActivated = builder.diagnosticsActivated;
        this.multicastDiagnosticsActivated = builder.multicastDiagnosticsActivated;
        this.locationTrackingActivated = builder.locationTrackingActivated;
        this.fmsActivated = builder.fmsActivated;
        this.proxyArpServiceActivated = builder.proxyArpServiceActivated;
        this.collocatedInterferenceReportingActivated = builder.collocatedInterferenceReportingActivated;
        this.rmCivicMeasurementActivated = builder.rmCivicMeasurementActivated;
        this.rmLciMeasurementActivated = builder.rmLciMeasurementActivated;
        this.tfsActivated = builder.tfsActivated;
        this.wnmSleepModeActivated = builder.wnmSleepModeActivated;
        this.timBroadcastActivated = builder.timBroadcastActivated;
        this.bssTransitionActivated = builder.bssTransitionActivated;
        this.qosTrafficCapabilityActivated = builder.qosTrafficCapabilityActivated;
        this.acStationCountActivated = builder.acStationCountActivated;
        this.multiBssIdActivated = builder.multiBssIdActivated;
        this.timingMeasurementActivated = builder.timingMeasurementActivated;
        this.channelUsageActivated = builder.channelUsageActivated;
        this.ssidListActivated = builder.ssidListActivated;
        this.dmsActivated = builder.dmsActivated;
        this.utcTsfOffsetActivated = builder.utcTsfOffsetActivated;
        this.tdlsPeerUapsdBufferStaSupported = builder.tdlsPeerUapsdBufferStaSupported;
        this.tdlsPeerPsmSupported = builder.tdlsPeerPsmSupported;
        this.tdlsChannelSwitchingActivated = builder.tdlsChannelSwitchingActivated;
        this.interworkingServiceActivated = builder.interworkingServiceActivated;
        this.qosMapActivated = builder.qosMapActivated;
        this.ebrActivated = builder.ebrActivated;
        this.sspnInterfaceActivated = builder.sspnInterfaceActivated;
        this.bit35 = builder.bit35;
        this.msgcfActivated = builder.msgcfActivated;
        this.tdlsSupported = builder.tdlsSupported;
        this.tdlsProhibited = builder.tdlsProhibited;
        this.tdlsChannelSwitchingProhibited = builder.tdlsChannelSwitchingProhibited;
        this.rejectingUnadmittedTraffic = builder.rejectingUnadmittedTraffic;
        this.serviceIntervalGranularity = builder.serviceIntervalGranularity;
        this.rmIdentifierMeasurementActivated = builder.rmIdentifierMeasurementActivated;
        this.uapsdCoexistenceActivated = builder.uapsdCoexistenceActivated;
        this.wnmNotificationActivated = builder.wnmNotificationActivated;
        this.bit47 = builder.bit47;
        this.utf8Ssid = builder.utf8Ssid;
        this.bit49 = builder.bit49;
        this.bit50 = builder.bit50;
        this.bit51 = builder.bit51;
        this.bit52 = builder.bit52;
        this.bit53 = builder.bit53;
        this.bit54 = builder.bit54;
        this.bit55 = builder.bit55;
        this.trailingData = (byte[])(builder.trailingData != null ? ByteArrays.clone(builder.trailingData) : null);
    }

    private static int calcActualLength(Builder builder) {
        if (builder.trailingData != null) {
            return 7 + builder.trailingData.length;
        }
        if (builder.utf8Ssid != null || builder.bit49 != null || builder.bit50 != null || builder.bit51 != null || builder.bit52 != null || builder.bit53 != null || builder.bit54 != null || builder.bit55 != null) {
            return 7;
        }
        if (builder.rejectingUnadmittedTraffic != null || builder.serviceIntervalGranularity != null || builder.rmIdentifierMeasurementActivated != null || builder.uapsdCoexistenceActivated != null || builder.wnmNotificationActivated != null || builder.bit47 != null) {
            return 6;
        }
        if (builder.qosMapActivated != null || builder.ebrActivated != null || builder.sspnInterfaceActivated != null || builder.bit35 != null || builder.msgcfActivated != null || builder.tdlsSupported != null || builder.tdlsProhibited != null || builder.tdlsChannelSwitchingProhibited != null) {
            return 5;
        }
        if (builder.channelUsageActivated != null || builder.ssidListActivated != null || builder.dmsActivated != null || builder.utcTsfOffsetActivated != null || builder.tdlsPeerUapsdBufferStaSupported != null || builder.tdlsPeerPsmSupported != null || builder.tdlsChannelSwitchingActivated != null || builder.interworkingServiceActivated != null) {
            return 4;
        }
        if (builder.tfsActivated != null || builder.wnmSleepModeActivated != null || builder.timBroadcastActivated != null || builder.bssTransitionActivated != null || builder.qosTrafficCapabilityActivated != null || builder.acStationCountActivated != null || builder.multiBssIdActivated != null || builder.timingMeasurementActivated != null) {
            return 3;
        }
        if (builder.diagnosticsActivated != null || builder.multicastDiagnosticsActivated != null || builder.locationTrackingActivated != null || builder.fmsActivated != null || builder.proxyArpServiceActivated != null || builder.collocatedInterferenceReportingActivated != null || builder.rmCivicMeasurementActivated != null || builder.rmLciMeasurementActivated != null) {
            return 2;
        }
        if (builder.twentyFortyBssCoexistenceManagementSupported != null || builder.bit1 != null || builder.extendedChannelSwitchingSupported != null || builder.bit3 != null || builder.psmpOperationSupported != null || builder.bit5 != null || builder.scheduledPsmpSupported != null || builder.eventActivated != null) {
            return 1;
        }
        return 0;
    }

    public Boolean is2040BssCoexistenceManagementSupported() {
        return this.twentyFortyBssCoexistenceManagementSupported;
    }

    public Boolean getBit1() {
        return this.bit1;
    }

    public Boolean isExtendedChannelSwitchingSupported() {
        return this.extendedChannelSwitchingSupported;
    }

    public Boolean getBit3() {
        return this.bit3;
    }

    public Boolean isPsmpOperationSupported() {
        return this.psmpOperationSupported;
    }

    public Boolean getBit5() {
        return this.bit5;
    }

    public Boolean isScheduledPsmpSupported() {
        return this.scheduledPsmpSupported;
    }

    public Boolean isEventActivated() {
        return this.eventActivated;
    }

    public Boolean isDiagnosticsActivated() {
        return this.diagnosticsActivated;
    }

    public Boolean isMulticastDiagnosticsActivated() {
        return this.multicastDiagnosticsActivated;
    }

    public Boolean isLocationTrackingActivated() {
        return this.locationTrackingActivated;
    }

    public Boolean isFmsActivated() {
        return this.fmsActivated;
    }

    public Boolean isProxyArpServiceActivated() {
        return this.proxyArpServiceActivated;
    }

    public Boolean isCollocatedInterferenceReportingActivated() {
        return this.collocatedInterferenceReportingActivated;
    }

    public Boolean isRmCivicMeasurementActivated() {
        return this.rmCivicMeasurementActivated;
    }

    public Boolean isRmLciMeasurementActivated() {
        return this.rmLciMeasurementActivated;
    }

    public Boolean isTfsActivated() {
        return this.tfsActivated;
    }

    public Boolean isWnmSleepModeActivated() {
        return this.wnmSleepModeActivated;
    }

    public Boolean isTimBroadcastActivated() {
        return this.timBroadcastActivated;
    }

    public Boolean isBssTransitionActivated() {
        return this.bssTransitionActivated;
    }

    public Boolean isQosTrafficCapabilityActivated() {
        return this.qosTrafficCapabilityActivated;
    }

    public Boolean isAcStationCountActivated() {
        return this.acStationCountActivated;
    }

    public Boolean isMultiBssIdActivated() {
        return this.multiBssIdActivated;
    }

    public Boolean isTimingMeasurementActivated() {
        return this.timingMeasurementActivated;
    }

    public Boolean isChannelUsageActivated() {
        return this.channelUsageActivated;
    }

    public Boolean isSsidListActivated() {
        return this.ssidListActivated;
    }

    public Boolean isDmsActivated() {
        return this.dmsActivated;
    }

    public Boolean isUtcTsfOffsetActivated() {
        return this.utcTsfOffsetActivated;
    }

    public Boolean isTdlsPeerUapsdBufferStaSupported() {
        return this.tdlsPeerUapsdBufferStaSupported;
    }

    public Boolean isTdlsPeerPsmSupported() {
        return this.tdlsPeerPsmSupported;
    }

    public Boolean isTdlsChannelSwitchingActivated() {
        return this.tdlsChannelSwitchingActivated;
    }

    public Boolean isInterworkingServiceActivated() {
        return this.interworkingServiceActivated;
    }

    public Boolean isQosMapActivated() {
        return this.qosMapActivated;
    }

    public Boolean isEbrActivated() {
        return this.ebrActivated;
    }

    public Boolean isSspnInterfaceActivated() {
        return this.sspnInterfaceActivated;
    }

    public Boolean getBit35() {
        return this.bit35;
    }

    public Boolean isMsgcfActivated() {
        return this.msgcfActivated;
    }

    public Boolean isTdlsSupported() {
        return this.tdlsSupported;
    }

    public Boolean isTdlsProhibited() {
        return this.tdlsProhibited;
    }

    public Boolean isTdlsChannelSwitchingProhibited() {
        return this.tdlsChannelSwitchingProhibited;
    }

    public Boolean isRejectingUnadmittedTraffic() {
        return this.rejectingUnadmittedTraffic;
    }

    public Dot11ServiceIntervalGranularity getServiceIntervalGranularity() {
        return this.serviceIntervalGranularity;
    }

    public Boolean isRmIdentifierMeasurementActivated() {
        return this.rmIdentifierMeasurementActivated;
    }

    public Boolean isUapsdCoexistenceActivated() {
        return this.uapsdCoexistenceActivated;
    }

    public Boolean isWnmNotificationActivated() {
        return this.wnmNotificationActivated;
    }

    public Boolean getBit47() {
        return this.bit47;
    }

    public Boolean isutf8Ssid() {
        return this.utf8Ssid;
    }

    public Boolean getBit49() {
        return this.bit49;
    }

    public Boolean getBit50() {
        return this.bit50;
    }

    public Boolean getBit51() {
        return this.bit51;
    }

    public Boolean getBit52() {
        return this.bit52;
    }

    public Boolean getBit53() {
        return this.bit53;
    }

    public Boolean getBit54() {
        return this.bit54;
    }

    public Boolean getBit55() {
        return this.bit55;
    }

    public byte[] getTrailingData() {
        return this.trailingData != null ? ByteArrays.clone(this.trailingData) : null;
    }

    @Override
    public int length() {
        return this.actualLength + 2;
    }

    @Override
    public byte[] getRawData() {
        byte[] rawData = new byte[this.length()];
        rawData[0] = (Byte)this.getElementId().value();
        rawData[1] = this.getLength();
        if (this.actualLength > 0) {
            if (Boolean.TRUE.equals(this.twentyFortyBssCoexistenceManagementSupported)) {
                rawData[2] = (byte)(rawData[2] | 1);
            }
            if (Boolean.TRUE.equals(this.bit1)) {
                rawData[2] = (byte)(rawData[2] | 2);
            }
            if (Boolean.TRUE.equals(this.extendedChannelSwitchingSupported)) {
                rawData[2] = (byte)(rawData[2] | 4);
            }
            if (Boolean.TRUE.equals(this.bit3)) {
                rawData[2] = (byte)(rawData[2] | 8);
            }
            if (Boolean.TRUE.equals(this.psmpOperationSupported)) {
                rawData[2] = (byte)(rawData[2] | 0x10);
            }
            if (Boolean.TRUE.equals(this.bit5)) {
                rawData[2] = (byte)(rawData[2] | 0x20);
            }
            if (Boolean.TRUE.equals(this.scheduledPsmpSupported)) {
                rawData[2] = (byte)(rawData[2] | 0x40);
            }
            if (Boolean.TRUE.equals(this.eventActivated)) {
                rawData[2] = (byte)(rawData[2] | 0x80);
            }
        }
        if (this.actualLength > 1) {
            if (Boolean.TRUE.equals(this.diagnosticsActivated)) {
                rawData[3] = (byte)(rawData[3] | 1);
            }
            if (Boolean.TRUE.equals(this.multicastDiagnosticsActivated)) {
                rawData[3] = (byte)(rawData[3] | 2);
            }
            if (Boolean.TRUE.equals(this.locationTrackingActivated)) {
                rawData[3] = (byte)(rawData[3] | 4);
            }
            if (Boolean.TRUE.equals(this.fmsActivated)) {
                rawData[3] = (byte)(rawData[3] | 8);
            }
            if (Boolean.TRUE.equals(this.proxyArpServiceActivated)) {
                rawData[3] = (byte)(rawData[3] | 0x10);
            }
            if (Boolean.TRUE.equals(this.collocatedInterferenceReportingActivated)) {
                rawData[3] = (byte)(rawData[3] | 0x20);
            }
            if (Boolean.TRUE.equals(this.rmCivicMeasurementActivated)) {
                rawData[3] = (byte)(rawData[3] | 0x40);
            }
            if (Boolean.TRUE.equals(this.rmLciMeasurementActivated)) {
                rawData[3] = (byte)(rawData[3] | 0x80);
            }
        }
        if (this.actualLength > 2) {
            if (Boolean.TRUE.equals(this.tfsActivated)) {
                rawData[4] = (byte)(rawData[4] | 1);
            }
            if (Boolean.TRUE.equals(this.wnmSleepModeActivated)) {
                rawData[4] = (byte)(rawData[4] | 2);
            }
            if (Boolean.TRUE.equals(this.timBroadcastActivated)) {
                rawData[4] = (byte)(rawData[4] | 4);
            }
            if (Boolean.TRUE.equals(this.bssTransitionActivated)) {
                rawData[4] = (byte)(rawData[4] | 8);
            }
            if (Boolean.TRUE.equals(this.qosTrafficCapabilityActivated)) {
                rawData[4] = (byte)(rawData[4] | 0x10);
            }
            if (Boolean.TRUE.equals(this.acStationCountActivated)) {
                rawData[4] = (byte)(rawData[4] | 0x20);
            }
            if (Boolean.TRUE.equals(this.multiBssIdActivated)) {
                rawData[4] = (byte)(rawData[4] | 0x40);
            }
            if (Boolean.TRUE.equals(this.timingMeasurementActivated)) {
                rawData[4] = (byte)(rawData[4] | 0x80);
            }
        }
        if (this.actualLength > 3) {
            if (Boolean.TRUE.equals(this.channelUsageActivated)) {
                rawData[5] = (byte)(rawData[5] | 1);
            }
            if (Boolean.TRUE.equals(this.ssidListActivated)) {
                rawData[5] = (byte)(rawData[5] | 2);
            }
            if (Boolean.TRUE.equals(this.dmsActivated)) {
                rawData[5] = (byte)(rawData[5] | 4);
            }
            if (Boolean.TRUE.equals(this.utcTsfOffsetActivated)) {
                rawData[5] = (byte)(rawData[5] | 8);
            }
            if (Boolean.TRUE.equals(this.tdlsPeerUapsdBufferStaSupported)) {
                rawData[5] = (byte)(rawData[5] | 0x10);
            }
            if (Boolean.TRUE.equals(this.tdlsPeerPsmSupported)) {
                rawData[5] = (byte)(rawData[5] | 0x20);
            }
            if (Boolean.TRUE.equals(this.tdlsChannelSwitchingActivated)) {
                rawData[5] = (byte)(rawData[5] | 0x40);
            }
            if (Boolean.TRUE.equals(this.interworkingServiceActivated)) {
                rawData[5] = (byte)(rawData[5] | 0x80);
            }
        }
        if (this.actualLength > 4) {
            if (Boolean.TRUE.equals(this.qosMapActivated)) {
                rawData[6] = (byte)(rawData[6] | 1);
            }
            if (Boolean.TRUE.equals(this.ebrActivated)) {
                rawData[6] = (byte)(rawData[6] | 2);
            }
            if (Boolean.TRUE.equals(this.sspnInterfaceActivated)) {
                rawData[6] = (byte)(rawData[6] | 4);
            }
            if (Boolean.TRUE.equals(this.bit35)) {
                rawData[6] = (byte)(rawData[6] | 8);
            }
            if (Boolean.TRUE.equals(this.msgcfActivated)) {
                rawData[6] = (byte)(rawData[6] | 0x10);
            }
            if (Boolean.TRUE.equals(this.tdlsSupported)) {
                rawData[6] = (byte)(rawData[6] | 0x20);
            }
            if (Boolean.TRUE.equals(this.tdlsProhibited)) {
                rawData[6] = (byte)(rawData[6] | 0x40);
            }
            if (Boolean.TRUE.equals(this.tdlsChannelSwitchingProhibited)) {
                rawData[6] = (byte)(rawData[6] | 0x80);
            }
        }
        if (this.actualLength > 5) {
            rawData[7] = (byte)((Byte)this.serviceIntervalGranularity.value() << 1);
            if (Boolean.TRUE.equals(this.rejectingUnadmittedTraffic)) {
                rawData[7] = (byte)(rawData[7] | 1);
            }
            if (Boolean.TRUE.equals(this.rmIdentifierMeasurementActivated)) {
                rawData[7] = (byte)(rawData[7] | 0x10);
            }
            if (Boolean.TRUE.equals(this.uapsdCoexistenceActivated)) {
                rawData[7] = (byte)(rawData[7] | 0x20);
            }
            if (Boolean.TRUE.equals(this.wnmNotificationActivated)) {
                rawData[7] = (byte)(rawData[7] | 0x40);
            }
            if (Boolean.TRUE.equals(this.bit47)) {
                rawData[7] = (byte)(rawData[7] | 0x80);
            }
        }
        if (this.actualLength > 6) {
            if (Boolean.TRUE.equals(this.utf8Ssid)) {
                rawData[8] = (byte)(rawData[8] | 1);
            }
            if (Boolean.TRUE.equals(this.bit49)) {
                rawData[8] = (byte)(rawData[8] | 2);
            }
            if (Boolean.TRUE.equals(this.bit50)) {
                rawData[8] = (byte)(rawData[8] | 4);
            }
            if (Boolean.TRUE.equals(this.bit51)) {
                rawData[8] = (byte)(rawData[8] | 8);
            }
            if (Boolean.TRUE.equals(this.bit52)) {
                rawData[8] = (byte)(rawData[8] | 0x10);
            }
            if (Boolean.TRUE.equals(this.bit53)) {
                rawData[8] = (byte)(rawData[8] | 0x20);
            }
            if (Boolean.TRUE.equals(this.bit54)) {
                rawData[8] = (byte)(rawData[8] | 0x40);
            }
            if (Boolean.TRUE.equals(this.bit55)) {
                rawData[8] = (byte)(rawData[8] | 0x80);
            }
        }
        if (this.actualLength > 7) {
            System.arraycopy(this.trailingData, 0, rawData, 9, this.trailingData.length);
        }
        return rawData;
    }

    public Builder getBuilder() {
        return new Builder(this);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.utf8Ssid == null ? 0 : this.utf8Ssid.hashCode());
        result = 31 * result + (this.acStationCountActivated == null ? 0 : this.acStationCountActivated.hashCode());
        result = 31 * result + (this.bit1 == null ? 0 : this.bit1.hashCode());
        result = 31 * result + (this.bit3 == null ? 0 : this.bit3.hashCode());
        result = 31 * result + (this.bit35 == null ? 0 : this.bit35.hashCode());
        result = 31 * result + (this.bit47 == null ? 0 : this.bit47.hashCode());
        result = 31 * result + (this.bit49 == null ? 0 : this.bit49.hashCode());
        result = 31 * result + (this.bit5 == null ? 0 : this.bit5.hashCode());
        result = 31 * result + (this.bit50 == null ? 0 : this.bit50.hashCode());
        result = 31 * result + (this.bit51 == null ? 0 : this.bit51.hashCode());
        result = 31 * result + (this.bit52 == null ? 0 : this.bit52.hashCode());
        result = 31 * result + (this.bit53 == null ? 0 : this.bit53.hashCode());
        result = 31 * result + (this.bit54 == null ? 0 : this.bit54.hashCode());
        result = 31 * result + (this.bit55 == null ? 0 : this.bit55.hashCode());
        result = 31 * result + (this.bssTransitionActivated == null ? 0 : this.bssTransitionActivated.hashCode());
        result = 31 * result + (this.channelUsageActivated == null ? 0 : this.channelUsageActivated.hashCode());
        result = 31 * result + (this.collocatedInterferenceReportingActivated == null ? 0 : this.collocatedInterferenceReportingActivated.hashCode());
        result = 31 * result + (this.diagnosticsActivated == null ? 0 : this.diagnosticsActivated.hashCode());
        result = 31 * result + (this.dmsActivated == null ? 0 : this.dmsActivated.hashCode());
        result = 31 * result + (this.ebrActivated == null ? 0 : this.ebrActivated.hashCode());
        result = 31 * result + (this.eventActivated == null ? 0 : this.eventActivated.hashCode());
        result = 31 * result + (this.extendedChannelSwitchingSupported == null ? 0 : this.extendedChannelSwitchingSupported.hashCode());
        result = 31 * result + (this.fmsActivated == null ? 0 : this.fmsActivated.hashCode());
        result = 31 * result + (this.interworkingServiceActivated == null ? 0 : this.interworkingServiceActivated.hashCode());
        result = 31 * result + (this.locationTrackingActivated == null ? 0 : this.locationTrackingActivated.hashCode());
        result = 31 * result + (this.msgcfActivated == null ? 0 : this.msgcfActivated.hashCode());
        result = 31 * result + (this.multiBssIdActivated == null ? 0 : this.multiBssIdActivated.hashCode());
        result = 31 * result + (this.multicastDiagnosticsActivated == null ? 0 : this.multicastDiagnosticsActivated.hashCode());
        result = 31 * result + (this.proxyArpServiceActivated == null ? 0 : this.proxyArpServiceActivated.hashCode());
        result = 31 * result + (this.psmpOperationSupported == null ? 0 : this.psmpOperationSupported.hashCode());
        result = 31 * result + (this.qosMapActivated == null ? 0 : this.qosMapActivated.hashCode());
        result = 31 * result + (this.qosTrafficCapabilityActivated == null ? 0 : this.qosTrafficCapabilityActivated.hashCode());
        result = 31 * result + (this.rejectingUnadmittedTraffic == null ? 0 : this.rejectingUnadmittedTraffic.hashCode());
        result = 31 * result + (this.rmCivicMeasurementActivated == null ? 0 : this.rmCivicMeasurementActivated.hashCode());
        result = 31 * result + (this.rmIdentifierMeasurementActivated == null ? 0 : this.rmIdentifierMeasurementActivated.hashCode());
        result = 31 * result + (this.rmLciMeasurementActivated == null ? 0 : this.rmLciMeasurementActivated.hashCode());
        result = 31 * result + (this.scheduledPsmpSupported == null ? 0 : this.scheduledPsmpSupported.hashCode());
        result = 31 * result + (this.serviceIntervalGranularity == null ? 0 : this.serviceIntervalGranularity.hashCode());
        result = 31 * result + (this.ssidListActivated == null ? 0 : this.ssidListActivated.hashCode());
        result = 31 * result + (this.sspnInterfaceActivated == null ? 0 : this.sspnInterfaceActivated.hashCode());
        result = 31 * result + (this.tdlsChannelSwitchingActivated == null ? 0 : this.tdlsChannelSwitchingActivated.hashCode());
        result = 31 * result + (this.tdlsChannelSwitchingProhibited == null ? 0 : this.tdlsChannelSwitchingProhibited.hashCode());
        result = 31 * result + (this.tdlsPeerPsmSupported == null ? 0 : this.tdlsPeerPsmSupported.hashCode());
        result = 31 * result + (this.tdlsPeerUapsdBufferStaSupported == null ? 0 : this.tdlsPeerUapsdBufferStaSupported.hashCode());
        result = 31 * result + (this.tdlsProhibited == null ? 0 : this.tdlsProhibited.hashCode());
        result = 31 * result + (this.tdlsSupported == null ? 0 : this.tdlsSupported.hashCode());
        result = 31 * result + (this.tfsActivated == null ? 0 : this.tfsActivated.hashCode());
        result = 31 * result + (this.timBroadcastActivated == null ? 0 : this.timBroadcastActivated.hashCode());
        result = 31 * result + (this.timingMeasurementActivated == null ? 0 : this.timingMeasurementActivated.hashCode());
        result = 31 * result + Arrays.hashCode(this.trailingData);
        result = 31 * result + (this.twentyFortyBssCoexistenceManagementSupported == null ? 0 : this.twentyFortyBssCoexistenceManagementSupported.hashCode());
        result = 31 * result + (this.uapsdCoexistenceActivated == null ? 0 : this.uapsdCoexistenceActivated.hashCode());
        result = 31 * result + (this.utcTsfOffsetActivated == null ? 0 : this.utcTsfOffsetActivated.hashCode());
        result = 31 * result + (this.wnmNotificationActivated == null ? 0 : this.wnmNotificationActivated.hashCode());
        result = 31 * result + (this.wnmSleepModeActivated == null ? 0 : this.wnmSleepModeActivated.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        Dot11ExtendedCapabilitiesElement other = (Dot11ExtendedCapabilitiesElement)obj;
        if (this.utf8Ssid == null ? other.utf8Ssid != null : !this.utf8Ssid.equals(other.utf8Ssid)) {
            return false;
        }
        if (this.acStationCountActivated == null ? other.acStationCountActivated != null : !this.acStationCountActivated.equals(other.acStationCountActivated)) {
            return false;
        }
        if (this.bit1 == null ? other.bit1 != null : !this.bit1.equals(other.bit1)) {
            return false;
        }
        if (this.bit3 == null ? other.bit3 != null : !this.bit3.equals(other.bit3)) {
            return false;
        }
        if (this.bit35 == null ? other.bit35 != null : !this.bit35.equals(other.bit35)) {
            return false;
        }
        if (this.bit47 == null ? other.bit47 != null : !this.bit47.equals(other.bit47)) {
            return false;
        }
        if (this.bit49 == null ? other.bit49 != null : !this.bit49.equals(other.bit49)) {
            return false;
        }
        if (this.bit5 == null ? other.bit5 != null : !this.bit5.equals(other.bit5)) {
            return false;
        }
        if (this.bit50 == null ? other.bit50 != null : !this.bit50.equals(other.bit50)) {
            return false;
        }
        if (this.bit51 == null ? other.bit51 != null : !this.bit51.equals(other.bit51)) {
            return false;
        }
        if (this.bit52 == null ? other.bit52 != null : !this.bit52.equals(other.bit52)) {
            return false;
        }
        if (this.bit53 == null ? other.bit53 != null : !this.bit53.equals(other.bit53)) {
            return false;
        }
        if (this.bit54 == null ? other.bit54 != null : !this.bit54.equals(other.bit54)) {
            return false;
        }
        if (this.bit55 == null ? other.bit55 != null : !this.bit55.equals(other.bit55)) {
            return false;
        }
        if (this.bssTransitionActivated == null ? other.bssTransitionActivated != null : !this.bssTransitionActivated.equals(other.bssTransitionActivated)) {
            return false;
        }
        if (this.channelUsageActivated == null ? other.channelUsageActivated != null : !this.channelUsageActivated.equals(other.channelUsageActivated)) {
            return false;
        }
        if (this.collocatedInterferenceReportingActivated == null ? other.collocatedInterferenceReportingActivated != null : !this.collocatedInterferenceReportingActivated.equals(other.collocatedInterferenceReportingActivated)) {
            return false;
        }
        if (this.diagnosticsActivated == null ? other.diagnosticsActivated != null : !this.diagnosticsActivated.equals(other.diagnosticsActivated)) {
            return false;
        }
        if (this.dmsActivated == null ? other.dmsActivated != null : !this.dmsActivated.equals(other.dmsActivated)) {
            return false;
        }
        if (this.ebrActivated == null ? other.ebrActivated != null : !this.ebrActivated.equals(other.ebrActivated)) {
            return false;
        }
        if (this.eventActivated == null ? other.eventActivated != null : !this.eventActivated.equals(other.eventActivated)) {
            return false;
        }
        if (this.extendedChannelSwitchingSupported == null ? other.extendedChannelSwitchingSupported != null : !this.extendedChannelSwitchingSupported.equals(other.extendedChannelSwitchingSupported)) {
            return false;
        }
        if (this.fmsActivated == null ? other.fmsActivated != null : !this.fmsActivated.equals(other.fmsActivated)) {
            return false;
        }
        if (this.interworkingServiceActivated == null ? other.interworkingServiceActivated != null : !this.interworkingServiceActivated.equals(other.interworkingServiceActivated)) {
            return false;
        }
        if (this.locationTrackingActivated == null ? other.locationTrackingActivated != null : !this.locationTrackingActivated.equals(other.locationTrackingActivated)) {
            return false;
        }
        if (this.msgcfActivated == null ? other.msgcfActivated != null : !this.msgcfActivated.equals(other.msgcfActivated)) {
            return false;
        }
        if (this.multiBssIdActivated == null ? other.multiBssIdActivated != null : !this.multiBssIdActivated.equals(other.multiBssIdActivated)) {
            return false;
        }
        if (this.multicastDiagnosticsActivated == null ? other.multicastDiagnosticsActivated != null : !this.multicastDiagnosticsActivated.equals(other.multicastDiagnosticsActivated)) {
            return false;
        }
        if (this.proxyArpServiceActivated == null ? other.proxyArpServiceActivated != null : !this.proxyArpServiceActivated.equals(other.proxyArpServiceActivated)) {
            return false;
        }
        if (this.psmpOperationSupported == null ? other.psmpOperationSupported != null : !this.psmpOperationSupported.equals(other.psmpOperationSupported)) {
            return false;
        }
        if (this.qosMapActivated == null ? other.qosMapActivated != null : !this.qosMapActivated.equals(other.qosMapActivated)) {
            return false;
        }
        if (this.qosTrafficCapabilityActivated == null ? other.qosTrafficCapabilityActivated != null : !this.qosTrafficCapabilityActivated.equals(other.qosTrafficCapabilityActivated)) {
            return false;
        }
        if (this.rejectingUnadmittedTraffic == null ? other.rejectingUnadmittedTraffic != null : !this.rejectingUnadmittedTraffic.equals(other.rejectingUnadmittedTraffic)) {
            return false;
        }
        if (this.rmCivicMeasurementActivated == null ? other.rmCivicMeasurementActivated != null : !this.rmCivicMeasurementActivated.equals(other.rmCivicMeasurementActivated)) {
            return false;
        }
        if (this.rmIdentifierMeasurementActivated == null ? other.rmIdentifierMeasurementActivated != null : !this.rmIdentifierMeasurementActivated.equals(other.rmIdentifierMeasurementActivated)) {
            return false;
        }
        if (this.rmLciMeasurementActivated == null ? other.rmLciMeasurementActivated != null : !this.rmLciMeasurementActivated.equals(other.rmLciMeasurementActivated)) {
            return false;
        }
        if (this.scheduledPsmpSupported == null ? other.scheduledPsmpSupported != null : !this.scheduledPsmpSupported.equals(other.scheduledPsmpSupported)) {
            return false;
        }
        if (this.serviceIntervalGranularity == null ? other.serviceIntervalGranularity != null : !this.serviceIntervalGranularity.equals(other.serviceIntervalGranularity)) {
            return false;
        }
        if (this.ssidListActivated == null ? other.ssidListActivated != null : !this.ssidListActivated.equals(other.ssidListActivated)) {
            return false;
        }
        if (this.sspnInterfaceActivated == null ? other.sspnInterfaceActivated != null : !this.sspnInterfaceActivated.equals(other.sspnInterfaceActivated)) {
            return false;
        }
        if (this.tdlsChannelSwitchingActivated == null ? other.tdlsChannelSwitchingActivated != null : !this.tdlsChannelSwitchingActivated.equals(other.tdlsChannelSwitchingActivated)) {
            return false;
        }
        if (this.tdlsChannelSwitchingProhibited == null ? other.tdlsChannelSwitchingProhibited != null : !this.tdlsChannelSwitchingProhibited.equals(other.tdlsChannelSwitchingProhibited)) {
            return false;
        }
        if (this.tdlsPeerPsmSupported == null ? other.tdlsPeerPsmSupported != null : !this.tdlsPeerPsmSupported.equals(other.tdlsPeerPsmSupported)) {
            return false;
        }
        if (this.tdlsPeerUapsdBufferStaSupported == null ? other.tdlsPeerUapsdBufferStaSupported != null : !this.tdlsPeerUapsdBufferStaSupported.equals(other.tdlsPeerUapsdBufferStaSupported)) {
            return false;
        }
        if (this.tdlsProhibited == null ? other.tdlsProhibited != null : !this.tdlsProhibited.equals(other.tdlsProhibited)) {
            return false;
        }
        if (this.tdlsSupported == null ? other.tdlsSupported != null : !this.tdlsSupported.equals(other.tdlsSupported)) {
            return false;
        }
        if (this.tfsActivated == null ? other.tfsActivated != null : !this.tfsActivated.equals(other.tfsActivated)) {
            return false;
        }
        if (this.timBroadcastActivated == null ? other.timBroadcastActivated != null : !this.timBroadcastActivated.equals(other.timBroadcastActivated)) {
            return false;
        }
        if (this.timingMeasurementActivated == null ? other.timingMeasurementActivated != null : !this.timingMeasurementActivated.equals(other.timingMeasurementActivated)) {
            return false;
        }
        if (!Arrays.equals(this.trailingData, other.trailingData)) {
            return false;
        }
        if (this.twentyFortyBssCoexistenceManagementSupported == null ? other.twentyFortyBssCoexistenceManagementSupported != null : !this.twentyFortyBssCoexistenceManagementSupported.equals(other.twentyFortyBssCoexistenceManagementSupported)) {
            return false;
        }
        if (this.uapsdCoexistenceActivated == null ? other.uapsdCoexistenceActivated != null : !this.uapsdCoexistenceActivated.equals(other.uapsdCoexistenceActivated)) {
            return false;
        }
        if (this.utcTsfOffsetActivated == null ? other.utcTsfOffsetActivated != null : !this.utcTsfOffsetActivated.equals(other.utcTsfOffsetActivated)) {
            return false;
        }
        if (this.wnmNotificationActivated == null ? other.wnmNotificationActivated != null : !this.wnmNotificationActivated.equals(other.wnmNotificationActivated)) {
            return false;
        }
        return !(this.wnmSleepModeActivated == null ? other.wnmSleepModeActivated != null : !this.wnmSleepModeActivated.equals(other.wnmSleepModeActivated));
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String indent) {
        StringBuilder sb = new StringBuilder();
        String ls = System.getProperty("line.separator");
        sb.append(indent).append("Extended Capabilities:").append(ls);
        sb.append(indent).append("  Element ID: ").append(this.getElementId()).append(ls);
        sb.append(indent).append("  Length: ").append(this.getLengthAsInt()).append(" bytes").append(ls);
        if (this.actualLength > 0) {
            sb.append(indent).append("  20/40 BSS Coexistence Management Supported: ").append(this.twentyFortyBssCoexistenceManagementSupported).append(ls);
            sb.append(indent).append("  Bit1: ").append(this.bit1).append(ls);
            sb.append(indent).append("  Extended Channel Switching Supported: ").append(this.extendedChannelSwitchingSupported).append(ls);
            sb.append(indent).append("  Bit3: ").append(this.bit3).append(ls);
            sb.append(indent).append("  PSMP Operation Supported: ").append(this.psmpOperationSupported).append(ls);
            sb.append(indent).append("  Bit5: ").append(this.bit5).append(ls);
            sb.append(indent).append("  Scheduled PSMP Supported: ").append(this.scheduledPsmpSupported).append(ls);
            sb.append(indent).append("  Event Activated: ").append(this.eventActivated).append(ls);
        }
        if (this.actualLength > 1) {
            sb.append(indent).append("  Diagnostics Activated: ").append(this.diagnosticsActivated).append(ls);
            sb.append(indent).append("  Multicast Diagnostics Activated: ").append(this.multicastDiagnosticsActivated).append(ls);
            sb.append(indent).append("  Location Tracking Activated: ").append(this.locationTrackingActivated).append(ls);
            sb.append(indent).append("  FMS Activated: ").append(this.fmsActivated).append(ls);
            sb.append(indent).append("  Proxy ARP Service Activated: ").append(this.proxyArpServiceActivated).append(ls);
            sb.append(indent).append("  Collocated Interference Reporting Activated: ").append(this.collocatedInterferenceReportingActivated).append(ls);
            sb.append(indent).append("  RM Civic Measurement Activated: ").append(this.rmCivicMeasurementActivated).append(ls);
            sb.append(indent).append("  RM LCI Measurement Activated: ").append(this.rmLciMeasurementActivated).append(ls);
        }
        if (this.actualLength > 2) {
            sb.append(indent).append("  TFS Activated: ").append(this.tfsActivated).append(ls);
            sb.append(indent).append("  WNM Sleep Mode Activated: ").append(this.wnmSleepModeActivated).append(ls);
            sb.append(indent).append("  TIM Broadcast Activated: ").append(this.timBroadcastActivated).append(ls);
            sb.append(indent).append("  BSS Transition Activated: ").append(this.bssTransitionActivated).append(ls);
            sb.append(indent).append("  QoS Traffic Capability Activated: ").append(this.qosTrafficCapabilityActivated).append(ls);
            sb.append(indent).append("  AC Station Count Activated: ").append(this.acStationCountActivated).append(ls);
            sb.append(indent).append("  Multi BSS ID Activated: ").append(this.multiBssIdActivated).append(ls);
            sb.append(indent).append("  Timing Measurement Activated: ").append(this.timingMeasurementActivated).append(ls);
        }
        if (this.actualLength > 3) {
            sb.append(indent).append("  Channel Usage Activated: ").append(this.channelUsageActivated).append(ls);
            sb.append(indent).append("  SSID List Activated: ").append(this.ssidListActivated).append(ls);
            sb.append(indent).append("  DMS Activated: ").append(this.dmsActivated).append(ls);
            sb.append(indent).append("  UTC TSF Offset Activated: ").append(this.utcTsfOffsetActivated).append(ls);
            sb.append(indent).append("  TDLS Peer U-APSD Buffer STA Supported: ").append(this.tdlsPeerUapsdBufferStaSupported).append(ls);
            sb.append(indent).append("  TDLS Peer PSM Supported: ").append(this.tdlsPeerPsmSupported).append(ls);
            sb.append(indent).append("  TDLS Channel Switching Activated: ").append(this.tdlsChannelSwitchingActivated).append(ls);
            sb.append(indent).append("  Interworking Service Activated: ").append(this.interworkingServiceActivated).append(ls);
        }
        if (this.actualLength > 4) {
            sb.append(indent).append("  QoS Map Activated: ").append(this.qosMapActivated).append(ls);
            sb.append(indent).append("  EBR Activated: ").append(this.ebrActivated).append(ls);
            sb.append(indent).append("  SSPN Interface Activated: ").append(this.sspnInterfaceActivated).append(ls);
            sb.append(indent).append("  Bit35: ").append(this.bit35).append(ls);
            sb.append(indent).append("  MSGCF Activated: ").append(this.msgcfActivated).append(ls);
            sb.append(indent).append("  TDLS Supported: ").append(this.tdlsSupported).append(ls);
            sb.append(indent).append("  TDLS Prohibited: ").append(this.tdlsProhibited).append(ls);
            sb.append(indent).append("  TDLS Channel Switching Prohibited: ").append(this.tdlsChannelSwitchingProhibited).append(ls);
        }
        if (this.actualLength > 5) {
            sb.append(indent).append("  Rejecting Unadmitted Traffic: ").append(this.rejectingUnadmittedTraffic).append(ls);
            sb.append(indent).append("  Service Interval Granularity: ").append(this.serviceIntervalGranularity).append(ls);
            sb.append(indent).append("  RM Identifier Measurement Activated: ").append(this.rmIdentifierMeasurementActivated).append(ls);
            sb.append(indent).append("  U-APSD Coexistence Activated: ").append(this.uapsdCoexistenceActivated).append(ls);
            sb.append(indent).append("  WNM-Notification Activated: ").append(this.wnmNotificationActivated).append(ls);
            sb.append(indent).append("  Bit47: ").append(this.bit47).append(ls);
        }
        if (this.actualLength > 6) {
            sb.append(indent).append("  UTF-8 SSID: ").append(this.utf8Ssid).append(ls);
            sb.append(indent).append("  Bit49: ").append(this.bit49).append(ls);
            sb.append(indent).append("  Bit50: ").append(this.bit50).append(ls);
            sb.append(indent).append("  Bit51: ").append(this.bit51).append(ls);
            sb.append(indent).append("  Bit52: ").append(this.bit52).append(ls);
            sb.append(indent).append("  Bit53: ").append(this.bit53).append(ls);
            sb.append(indent).append("  Bit54: ").append(this.bit54).append(ls);
            sb.append(indent).append("  Bit55: ").append(this.bit55).append(ls);
        }
        if (this.actualLength > 7) {
            sb.append(indent).append("  Trailing Data: 0x").append(ByteArrays.toHexString(this.trailingData, "")).append(ls);
        }
        return sb.toString();
    }

    public static final class Builder
    extends Dot11InformationElement.Builder {
        private Boolean twentyFortyBssCoexistenceManagementSupported;
        private Boolean bit1;
        private Boolean extendedChannelSwitchingSupported;
        private Boolean bit3;
        private Boolean psmpOperationSupported;
        private Boolean bit5;
        private Boolean scheduledPsmpSupported;
        private Boolean eventActivated;
        private Boolean diagnosticsActivated;
        private Boolean multicastDiagnosticsActivated;
        private Boolean locationTrackingActivated;
        private Boolean fmsActivated;
        private Boolean proxyArpServiceActivated;
        private Boolean collocatedInterferenceReportingActivated;
        private Boolean rmCivicMeasurementActivated;
        private Boolean rmLciMeasurementActivated;
        private Boolean tfsActivated;
        private Boolean wnmSleepModeActivated;
        private Boolean timBroadcastActivated;
        private Boolean bssTransitionActivated;
        private Boolean qosTrafficCapabilityActivated;
        private Boolean acStationCountActivated;
        private Boolean multiBssIdActivated;
        private Boolean timingMeasurementActivated;
        private Boolean channelUsageActivated;
        private Boolean ssidListActivated;
        private Boolean dmsActivated;
        private Boolean utcTsfOffsetActivated;
        private Boolean tdlsPeerUapsdBufferStaSupported;
        private Boolean tdlsPeerPsmSupported;
        private Boolean tdlsChannelSwitchingActivated;
        private Boolean interworkingServiceActivated;
        private Boolean qosMapActivated;
        private Boolean ebrActivated;
        private Boolean sspnInterfaceActivated;
        private Boolean bit35;
        private Boolean msgcfActivated;
        private Boolean tdlsSupported;
        private Boolean tdlsProhibited;
        private Boolean tdlsChannelSwitchingProhibited;
        private Boolean rejectingUnadmittedTraffic;
        private Dot11ServiceIntervalGranularity serviceIntervalGranularity;
        private Boolean rmIdentifierMeasurementActivated;
        private Boolean uapsdCoexistenceActivated;
        private Boolean wnmNotificationActivated;
        private Boolean bit47;
        private Boolean utf8Ssid;
        private Boolean bit49;
        private Boolean bit50;
        private Boolean bit51;
        private Boolean bit52;
        private Boolean bit53;
        private Boolean bit54;
        private Boolean bit55;
        private byte[] trailingData;

        public Builder() {
            this.elementId(Dot11InformationElementId.getInstance((Byte)Dot11InformationElementId.EXTENDED_CAPABILITIES.value()));
        }

        private Builder(Dot11ExtendedCapabilitiesElement elem) {
            super(elem);
            this.twentyFortyBssCoexistenceManagementSupported = elem.twentyFortyBssCoexistenceManagementSupported;
            this.bit1 = elem.bit1;
            this.extendedChannelSwitchingSupported = elem.extendedChannelSwitchingSupported;
            this.bit3 = elem.bit3;
            this.psmpOperationSupported = elem.psmpOperationSupported;
            this.bit5 = elem.bit5;
            this.scheduledPsmpSupported = elem.scheduledPsmpSupported;
            this.eventActivated = elem.eventActivated;
            this.diagnosticsActivated = elem.diagnosticsActivated;
            this.multicastDiagnosticsActivated = elem.multicastDiagnosticsActivated;
            this.locationTrackingActivated = elem.locationTrackingActivated;
            this.fmsActivated = elem.fmsActivated;
            this.proxyArpServiceActivated = elem.proxyArpServiceActivated;
            this.collocatedInterferenceReportingActivated = elem.collocatedInterferenceReportingActivated;
            this.rmCivicMeasurementActivated = elem.rmCivicMeasurementActivated;
            this.rmLciMeasurementActivated = elem.rmLciMeasurementActivated;
            this.tfsActivated = elem.tfsActivated;
            this.wnmSleepModeActivated = elem.wnmSleepModeActivated;
            this.timBroadcastActivated = elem.timBroadcastActivated;
            this.bssTransitionActivated = elem.bssTransitionActivated;
            this.qosTrafficCapabilityActivated = elem.qosTrafficCapabilityActivated;
            this.acStationCountActivated = elem.acStationCountActivated;
            this.multiBssIdActivated = elem.multiBssIdActivated;
            this.timingMeasurementActivated = elem.timingMeasurementActivated;
            this.channelUsageActivated = elem.channelUsageActivated;
            this.ssidListActivated = elem.ssidListActivated;
            this.dmsActivated = elem.dmsActivated;
            this.utcTsfOffsetActivated = elem.utcTsfOffsetActivated;
            this.tdlsPeerUapsdBufferStaSupported = elem.tdlsPeerUapsdBufferStaSupported;
            this.tdlsPeerPsmSupported = elem.tdlsPeerPsmSupported;
            this.tdlsChannelSwitchingActivated = elem.tdlsChannelSwitchingActivated;
            this.interworkingServiceActivated = elem.interworkingServiceActivated;
            this.qosMapActivated = elem.qosMapActivated;
            this.ebrActivated = elem.ebrActivated;
            this.sspnInterfaceActivated = elem.sspnInterfaceActivated;
            this.bit35 = elem.bit35;
            this.msgcfActivated = elem.msgcfActivated;
            this.tdlsSupported = elem.tdlsSupported;
            this.tdlsProhibited = elem.tdlsProhibited;
            this.tdlsChannelSwitchingProhibited = elem.tdlsChannelSwitchingProhibited;
            this.rejectingUnadmittedTraffic = elem.rejectingUnadmittedTraffic;
            this.serviceIntervalGranularity = elem.serviceIntervalGranularity;
            this.rmIdentifierMeasurementActivated = elem.rmIdentifierMeasurementActivated;
            this.uapsdCoexistenceActivated = elem.uapsdCoexistenceActivated;
            this.wnmNotificationActivated = elem.wnmNotificationActivated;
            this.bit47 = elem.bit47;
            this.utf8Ssid = elem.utf8Ssid;
            this.bit49 = elem.bit49;
            this.bit50 = elem.bit50;
            this.bit51 = elem.bit51;
            this.bit52 = elem.bit52;
            this.bit53 = elem.bit53;
            this.bit54 = elem.bit54;
            this.bit55 = elem.bit55;
            this.trailingData = elem.trailingData;
        }

        public Builder twentyFortyBssCoexistenceManagementSupported(Boolean twentyFortyBssCoexistenceManagementSupported) {
            this.twentyFortyBssCoexistenceManagementSupported = twentyFortyBssCoexistenceManagementSupported;
            return this;
        }

        public Builder bit1(Boolean bit1) {
            this.bit1 = bit1;
            return this;
        }

        public Builder extendedChannelSwitchingSupported(Boolean extendedChannelSwitchingSupported) {
            this.extendedChannelSwitchingSupported = extendedChannelSwitchingSupported;
            return this;
        }

        public Builder bit3(Boolean bit3) {
            this.bit3 = bit3;
            return this;
        }

        public Builder psmpOperationSupported(Boolean psmpOperationSupported) {
            this.psmpOperationSupported = psmpOperationSupported;
            return this;
        }

        public Builder bit5(Boolean bit5) {
            this.bit5 = bit5;
            return this;
        }

        public Builder scheduledPsmpSupported(Boolean scheduledPsmpSupported) {
            this.scheduledPsmpSupported = scheduledPsmpSupported;
            return this;
        }

        public Builder eventActivated(Boolean eventActivated) {
            this.eventActivated = eventActivated;
            return this;
        }

        public Builder diagnosticsActivated(Boolean diagnosticsActivated) {
            this.diagnosticsActivated = diagnosticsActivated;
            return this;
        }

        public Builder multicastDiagnosticsActivated(Boolean multicastDiagnosticsActivated) {
            this.multicastDiagnosticsActivated = multicastDiagnosticsActivated;
            return this;
        }

        public Builder locationTrackingActivated(Boolean locationTrackingActivated) {
            this.locationTrackingActivated = locationTrackingActivated;
            return this;
        }

        public Builder fmsActivated(Boolean fmsActivated) {
            this.fmsActivated = fmsActivated;
            return this;
        }

        public Builder proxyArpServiceActivated(Boolean proxyArpServiceActivated) {
            this.proxyArpServiceActivated = proxyArpServiceActivated;
            return this;
        }

        public Builder collocatedInterferenceReportingActivated(Boolean collocatedInterferenceReportingActivated) {
            this.collocatedInterferenceReportingActivated = collocatedInterferenceReportingActivated;
            return this;
        }

        public Builder rmCivicMeasurementActivated(Boolean rmCivicMeasurementActivated) {
            this.rmCivicMeasurementActivated = rmCivicMeasurementActivated;
            return this;
        }

        public Builder rmLciMeasurementActivated(Boolean rmLciMeasurementActivated) {
            this.rmLciMeasurementActivated = rmLciMeasurementActivated;
            return this;
        }

        public Builder tfsActivated(Boolean tfsActivated) {
            this.tfsActivated = tfsActivated;
            return this;
        }

        public Builder wnmSleepModeActivated(Boolean wnmSleepModeActivated) {
            this.wnmSleepModeActivated = wnmSleepModeActivated;
            return this;
        }

        public Builder timBroadcastActivated(Boolean timBroadcastActivated) {
            this.timBroadcastActivated = timBroadcastActivated;
            return this;
        }

        public Builder bssTransitionActivated(Boolean bssTransitionActivated) {
            this.bssTransitionActivated = bssTransitionActivated;
            return this;
        }

        public Builder qosTrafficCapabilityActivated(Boolean qosTrafficCapabilityActivated) {
            this.qosTrafficCapabilityActivated = qosTrafficCapabilityActivated;
            return this;
        }

        public Builder acStationCountActivated(Boolean acStationCountActivated) {
            this.acStationCountActivated = acStationCountActivated;
            return this;
        }

        public Builder multiBssIdActivated(Boolean multiBssIdActivated) {
            this.multiBssIdActivated = multiBssIdActivated;
            return this;
        }

        public Builder timingMeasurementActivated(Boolean timingMeasurementActivated) {
            this.timingMeasurementActivated = timingMeasurementActivated;
            return this;
        }

        public Builder channelUsageActivated(Boolean channelUsageActivated) {
            this.channelUsageActivated = channelUsageActivated;
            return this;
        }

        public Builder ssidListActivated(Boolean ssidListActivated) {
            this.ssidListActivated = ssidListActivated;
            return this;
        }

        public Builder dmsActivated(Boolean dmsActivated) {
            this.dmsActivated = dmsActivated;
            return this;
        }

        public Builder utcTsfOffsetActivated(Boolean utcTsfOffsetActivated) {
            this.utcTsfOffsetActivated = utcTsfOffsetActivated;
            return this;
        }

        public Builder tdlsPeerUapsdBufferStaSupported(Boolean tdlsPeerUapsdBufferStaSupported) {
            this.tdlsPeerUapsdBufferStaSupported = tdlsPeerUapsdBufferStaSupported;
            return this;
        }

        public Builder tdlsPeerPsmSupported(Boolean tdlsPeerPsmSupported) {
            this.tdlsPeerPsmSupported = tdlsPeerPsmSupported;
            return this;
        }

        public Builder tdlsChannelSwitchingActivated(Boolean tdlsChannelSwitchingActivated) {
            this.tdlsChannelSwitchingActivated = tdlsChannelSwitchingActivated;
            return this;
        }

        public Builder interworkingServiceActivated(Boolean interworkingServiceActivated) {
            this.interworkingServiceActivated = interworkingServiceActivated;
            return this;
        }

        public Builder qosMapActivated(Boolean qosMapActivated) {
            this.qosMapActivated = qosMapActivated;
            return this;
        }

        public Builder ebrActivated(Boolean ebrActivated) {
            this.ebrActivated = ebrActivated;
            return this;
        }

        public Builder sspnInterfaceActivated(Boolean sspnInterfaceActivated) {
            this.sspnInterfaceActivated = sspnInterfaceActivated;
            return this;
        }

        public Builder bit35(Boolean bit35) {
            this.bit35 = bit35;
            return this;
        }

        public Builder msgcfActivated(Boolean msgcfActivated) {
            this.msgcfActivated = msgcfActivated;
            return this;
        }

        public Builder tdlsSupported(Boolean tdlsSupported) {
            this.tdlsSupported = tdlsSupported;
            return this;
        }

        public Builder tdlsProhibited(Boolean tdlsProhibited) {
            this.tdlsProhibited = tdlsProhibited;
            return this;
        }

        public Builder tdlsChannelSwitchingProhibited(Boolean tdlsChannelSwitchingProhibited) {
            this.tdlsChannelSwitchingProhibited = tdlsChannelSwitchingProhibited;
            return this;
        }

        public Builder rejectingUnadmittedTraffic(Boolean rejectingUnadmittedTraffic) {
            this.rejectingUnadmittedTraffic = rejectingUnadmittedTraffic;
            return this;
        }

        public Builder serviceIntervalGranularity(Dot11ServiceIntervalGranularity serviceIntervalGranularity) {
            this.serviceIntervalGranularity = serviceIntervalGranularity;
            return this;
        }

        public Builder rmIdentifierMeasurementActivated(Boolean rmIdentifierMeasurementActivated) {
            this.rmIdentifierMeasurementActivated = rmIdentifierMeasurementActivated;
            return this;
        }

        public Builder uapsdCoexistenceActivated(Boolean uapsdCoexistenceActivated) {
            this.uapsdCoexistenceActivated = uapsdCoexistenceActivated;
            return this;
        }

        public Builder wnmNotificationActivated(Boolean wnmNotificationActivated) {
            this.wnmNotificationActivated = wnmNotificationActivated;
            return this;
        }

        public Builder bit47(Boolean bit47) {
            this.bit47 = bit47;
            return this;
        }

        public Builder utf8Ssid(Boolean utf8Ssid) {
            this.utf8Ssid = utf8Ssid;
            return this;
        }

        public Builder bit49(Boolean bit49) {
            this.bit49 = bit49;
            return this;
        }

        public Builder bit50(Boolean bit50) {
            this.bit50 = bit50;
            return this;
        }

        public Builder bit51(Boolean bit51) {
            this.bit51 = bit51;
            return this;
        }

        public Builder bit52(Boolean bit52) {
            this.bit52 = bit52;
            return this;
        }

        public Builder bit53(Boolean bit53) {
            this.bit53 = bit53;
            return this;
        }

        public Builder bit54(Boolean bit54) {
            this.bit54 = bit54;
            return this;
        }

        public Builder bit55(Boolean bit55) {
            this.bit55 = bit55;
            return this;
        }

        public Builder trailingData(byte[] trailingData) {
            this.trailingData = trailingData;
            return this;
        }

        @Override
        public Builder length(byte length) {
            super.length(length);
            return this;
        }

        @Override
        public Builder correctLengthAtBuild(boolean correctLengthAtBuild) {
            super.correctLengthAtBuild(correctLengthAtBuild);
            return this;
        }

        @Override
        public Dot11ExtendedCapabilitiesElement build() {
            if (this.getCorrectLengthAtBuild()) {
                this.length((byte)Dot11ExtendedCapabilitiesElement.calcActualLength(this));
            }
            return new Dot11ExtendedCapabilitiesElement(this);
        }
    }
}

