/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hertzbeat.common.util;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.hertzbeat.common.support.ResourceBundleUtf8Control;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ResourceBundleUtil {
    private static final Logger log = LoggerFactory.getLogger(ResourceBundleUtil.class);
    private static final ResourceBundleUtf8Control BUNDLE_UTF_8_CONTROL = new ResourceBundleUtf8Control();
    private static final Integer LANG_REGION_LENGTH = 2;

    private ResourceBundleUtil() {
    }

    public static ResourceBundle getBundle(String bundleName) {
        try {
            return ResourceBundle.getBundle(bundleName, BUNDLE_UTF_8_CONTROL);
        }
        catch (MissingResourceException resourceException) {
            return ResourceBundle.getBundle(bundleName, Locale.US, BUNDLE_UTF_8_CONTROL);
        }
    }

    static {
        try {
            String[] regionArr;
            String[] langArr;
            String langEnv = System.getenv("LANG");
            if (langEnv != null && (langArr = langEnv.split("\\.")).length >= 1 && (regionArr = langArr[0].split("_")).length == LANG_REGION_LENGTH) {
                String language = regionArr[0];
                String region = regionArr[1];
                Locale locale = new Locale(language, region);
                Locale.setDefault(locale);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }
}

