/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.apache.hertzbeat.common.entity.job.protocol;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

/**
 * Mongodb Protocol
 * @version 1.0
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class MongodbProtocol implements CommonRequestProtocol, Protocol {

    /**
     * IP ADDRESS OR DOMAIN NAME OF THE PEER HOST
     */
    private String host;

    /**
     * Port number
     */
    private String port;

    /**
     * Mongodb model
     */
    private String model;

    /**
     * Mongodb User name (optional)
     */
    private String username;

    /**
     * Mongodb Password (optional)
     */
    private String password;

    /**
     * Mongodb database name (optional)
     */
    private String database;

    /**
     * Mongodb Authentication Database name (optional)
     */
    private String authenticationDatabase;

    /**
     * run command
     */
    private String command;

    /**
     * TIME OUT PERIOD
     */
    private String timeout;

}
