/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.metrics;

import org.apache.hadoop.hbase.metrics.MetricRegistry;
import org.apache.hadoop.hbase.quotas.RpcThrottlingException;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MetricsThrottleExceptions {
    private static final String METRICS_NAME = "ThrottleExceptions";
    private static final String METRICS_CONTEXT = "regionserver";
    private static final String METRICS_DESCRIPTION = "Metrics about RPC throttling exceptions";
    private static final String METRICS_JMX_CONTEXT = "RegionServer,sub=ThrottleExceptions";
    private final MetricRegistry registry;

    public MetricsThrottleExceptions(MetricRegistry sharedRegistry) {
        this.registry = sharedRegistry;
    }

    public void recordThrottleException(RpcThrottlingException.Type throttleType, String user, String table) {
        String metricName = MetricsThrottleExceptions.qualifyThrottleMetric(throttleType, user, table);
        this.registry.counter(metricName).increment();
    }

    private static String qualifyThrottleMetric(RpcThrottlingException.Type throttleType, String user, String table) {
        return String.format("RpcThrottlingException_Type_%s_User_%s_Table_%s", throttleType.name(), MetricsThrottleExceptions.sanitizeMetricName(user), MetricsThrottleExceptions.sanitizeMetricName(table));
    }

    private static String sanitizeMetricName(String name) {
        if (name == null) {
            return "unknown";
        }
        return name.replaceAll("[,=:*?\"\\n]", "_");
    }
}

