/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.hbtop.screen.field;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumMap;
import java.util.List;
import java.util.Objects;
import org.apache.hadoop.hbase.hbtop.field.Field;
import org.apache.hadoop.hbase.hbtop.screen.ScreenView;
import org.apache.hadoop.hbase.hbtop.screen.field.FieldScreenView;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class FieldScreenPresenter {
    private final FieldScreenView fieldScreenView;
    private Field sortField;
    private final List<Field> fields;
    private final EnumMap<Field, Boolean> fieldDisplayMap;
    private final ResultListener resultListener;
    private final ScreenView nextScreenView;
    private final int headerMaxLength;
    private final int descriptionMaxLength;
    private int currentPosition;
    private boolean moveMode;

    public FieldScreenPresenter(FieldScreenView fieldScreenView, Field sortField, List<Field> fields, EnumMap<Field, Boolean> fieldDisplayMap, ResultListener resultListener, ScreenView nextScreenView) {
        this.fieldScreenView = Objects.requireNonNull(fieldScreenView);
        this.sortField = Objects.requireNonNull(sortField);
        this.fields = new ArrayList<Field>((Collection)Objects.requireNonNull(fields));
        this.fieldDisplayMap = new EnumMap<Field, Boolean>(Objects.requireNonNull(fieldDisplayMap));
        this.resultListener = Objects.requireNonNull(resultListener);
        this.nextScreenView = Objects.requireNonNull(nextScreenView);
        int headerLength = 0;
        int descriptionLength = 0;
        for (int i = 0; i < fields.size(); ++i) {
            Field field = fields.get(i);
            if (field == sortField) {
                this.currentPosition = i;
            }
            if (headerLength < field.getHeader().length()) {
                headerLength = field.getHeader().length();
            }
            if (descriptionLength >= field.getDescription().length()) continue;
            descriptionLength = field.getDescription().length();
        }
        this.headerMaxLength = headerLength;
        this.descriptionMaxLength = descriptionLength;
    }

    public void init() {
        this.fieldScreenView.hideCursor();
        this.fieldScreenView.clearTerminal();
        this.fieldScreenView.showFieldScreen(this.sortField.getHeader(), this.fields, this.fieldDisplayMap, this.currentPosition, this.headerMaxLength, this.descriptionMaxLength, this.moveMode);
        this.fieldScreenView.refreshTerminal();
    }

    public void arrowUp() {
        if (this.currentPosition > 0) {
            --this.currentPosition;
            if (this.moveMode) {
                Field tmp = this.fields.remove(this.currentPosition);
                this.fields.add(this.currentPosition + 1, tmp);
            }
            this.showField(this.currentPosition);
            this.showField(this.currentPosition + 1);
            this.fieldScreenView.refreshTerminal();
        }
    }

    public void arrowDown() {
        if (this.currentPosition < this.fields.size() - 1) {
            ++this.currentPosition;
            if (this.moveMode) {
                Field tmp = this.fields.remove(this.currentPosition - 1);
                this.fields.add(this.currentPosition, tmp);
            }
            this.showField(this.currentPosition);
            this.showField(this.currentPosition - 1);
            this.fieldScreenView.refreshTerminal();
        }
    }

    public void pageUp() {
        if (this.currentPosition > 0 && !this.moveMode) {
            int previousPosition = this.currentPosition;
            this.currentPosition = 0;
            this.showField(previousPosition);
            this.showField(this.currentPosition);
            this.fieldScreenView.refreshTerminal();
        }
    }

    public void pageDown() {
        if (this.currentPosition < this.fields.size() - 1 && !this.moveMode) {
            int previousPosition = this.currentPosition;
            this.currentPosition = this.fields.size() - 1;
            this.showField(previousPosition);
            this.showField(this.currentPosition);
            this.fieldScreenView.refreshTerminal();
        }
    }

    public void turnOnMoveMode() {
        this.moveMode = true;
        this.showField(this.currentPosition);
        this.fieldScreenView.refreshTerminal();
    }

    public void turnOffMoveMode() {
        this.moveMode = false;
        this.showField(this.currentPosition);
        this.fieldScreenView.refreshTerminal();
    }

    public void switchFieldDisplay() {
        if (!this.moveMode) {
            Field field;
            this.fieldDisplayMap.put(field, this.fieldDisplayMap.get((Object)(field = this.fields.get(this.currentPosition))) == false);
            this.showField(this.currentPosition);
            this.fieldScreenView.refreshTerminal();
        }
    }

    private void showField(int pos) {
        Field field = this.fields.get(pos);
        this.fieldScreenView.showField(pos, field, this.fieldDisplayMap.get((Object)field), pos == this.currentPosition, this.headerMaxLength, this.descriptionMaxLength, this.moveMode);
    }

    public void setSortField() {
        Field newSortField;
        if (!this.moveMode && (newSortField = this.fields.get(this.currentPosition)) != this.sortField) {
            this.sortField = newSortField;
            this.fieldScreenView.showScreenDescription(this.sortField.getHeader());
            this.fieldScreenView.refreshTerminal();
        }
    }

    public ScreenView transitionToNextScreen() {
        this.resultListener.accept(this.sortField, this.fields, this.fieldDisplayMap);
        return this.nextScreenView;
    }

    @FunctionalInterface
    public static interface ResultListener {
        public void accept(Field var1, List<Field> var2, EnumMap<Field, Boolean> var3);
    }
}

