/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseClassTestRule;
import org.apache.hadoop.hbase.IntegrationTestingUtility;
import org.apache.hadoop.hbase.client.ConnectionImplementation;
import org.apache.hadoop.hbase.security.UserProvider;
import org.apache.hadoop.hbase.testclassification.ClientTests;
import org.apache.hadoop.hbase.testclassification.MediumTests;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.ClassRule;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@Category(value={ClientTests.class, MediumTests.class})
@RunWith(value=MockitoJUnitRunner.class)
public class TestConnectionImplementationCacheMasterState {
    @ClassRule
    public static final HBaseClassTestRule CLASS_RULE = HBaseClassTestRule.forClass(TestConnectionImplementationCacheMasterState.class);
    private static final IntegrationTestingUtility TEST_UTIL = new IntegrationTestingUtility();

    @BeforeClass
    public static void beforeClass() throws Exception {
        TEST_UTIL.startMiniCluster(1);
    }

    @AfterClass
    public static void afterClass() throws Exception {
        TEST_UTIL.shutdownMiniCluster();
    }

    @Test
    public void testGetMaster_noCachedMasterState() throws IOException, IllegalAccessException {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setLong("hbase.client.master.state.cache.timeout.sec", 0L);
        ConnectionImplementation conn = new ConnectionImplementation(conf, null, UserProvider.instantiate((Configuration)conf).getCurrent());
        ConnectionImplementation.MasterServiceState masterServiceState = this.spyMasterServiceState(conn);
        conn.getMaster();
        conn.getMaster();
        conn.getMaster();
        ((ConnectionImplementation.MasterServiceState)Mockito.verify((Object)masterServiceState, (VerificationMode)Mockito.times((int)2))).isMasterRunning();
        conn.close();
    }

    @Test
    public void testGetMaster_masterStateCacheHit() throws IOException, IllegalAccessException {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setLong("hbase.client.master.state.cache.timeout.sec", 15L);
        ConnectionImplementation conn = new ConnectionImplementation(conf, null, UserProvider.instantiate((Configuration)conf).getCurrent());
        ConnectionImplementation.MasterServiceState masterServiceState = this.spyMasterServiceState(conn);
        conn.getMaster();
        conn.getMaster();
        conn.getMaster();
        ((ConnectionImplementation.MasterServiceState)Mockito.verify((Object)masterServiceState, (VerificationMode)Mockito.times((int)0))).isMasterRunning();
        conn.close();
    }

    @Test
    public void testGetMaster_masterStateCacheMiss() throws IOException, InterruptedException, IllegalAccessException {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setLong("hbase.client.master.state.cache.timeout.sec", 5L);
        ConnectionImplementation conn = new ConnectionImplementation(conf, null, UserProvider.instantiate((Configuration)conf).getCurrent());
        ConnectionImplementation.MasterServiceState masterServiceState = this.spyMasterServiceState(conn);
        conn.getMaster();
        conn.getMaster();
        conn.getMaster();
        Thread.sleep(10000L);
        conn.getMaster();
        ((ConnectionImplementation.MasterServiceState)Mockito.verify((Object)masterServiceState, (VerificationMode)Mockito.times((int)1))).isMasterRunning();
        conn.close();
    }

    @Test
    public void testIsKeepAliveMasterConnectedAndRunning_UndeclaredThrowableException() throws IOException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setLong("hbase.client.master.state.cache.timeout.sec", 0L);
        ConnectionImplementation conn = new ConnectionImplementation(conf, null, UserProvider.instantiate((Configuration)conf).getCurrent());
        conn.getMaster();
        ConnectionImplementation.MasterServiceState masterServiceState = this.spyMasterServiceState(conn);
        ((ConnectionImplementation.MasterServiceState)Mockito.doThrow((Throwable[])new Throwable[]{new UndeclaredThrowableException(new Exception("DUMMY EXCEPTION"))}).when((Object)masterServiceState)).isMasterRunning();
        boolean isKeepAliveMasterRunning = (Boolean)this.getIsKeepAliveMasterConnectedAndRunningMethod().invoke((Object)conn, new Object[0]);
        Assert.assertFalse((boolean)isKeepAliveMasterRunning);
        conn.close();
    }

    @Test
    public void testIsKeepAliveMasterConnectedAndRunning_IOException() throws IOException, IllegalAccessException, NoSuchMethodException, InvocationTargetException {
        Configuration conf = TEST_UTIL.getConfiguration();
        conf.setLong("hbase.client.master.state.cache.timeout.sec", 0L);
        ConnectionImplementation conn = new ConnectionImplementation(conf, null, UserProvider.instantiate((Configuration)conf).getCurrent());
        conn.getMaster();
        ConnectionImplementation.MasterServiceState masterServiceState = this.spyMasterServiceState(conn);
        ((ConnectionImplementation.MasterServiceState)Mockito.doThrow((Throwable[])new Throwable[]{new IOException("DUMMY EXCEPTION")}).when((Object)masterServiceState)).isMasterRunning();
        boolean isKeepAliveMasterRunning = (Boolean)this.getIsKeepAliveMasterConnectedAndRunningMethod().invoke((Object)conn, new Object[0]);
        Assert.assertFalse((boolean)isKeepAliveMasterRunning);
        conn.close();
    }

    private ConnectionImplementation.MasterServiceState spyMasterServiceState(ConnectionImplementation conn) throws IllegalAccessException {
        ConnectionImplementation.MasterServiceState spiedMasterServiceState = (ConnectionImplementation.MasterServiceState)Mockito.spy((Object)conn.getMasterServiceState());
        FieldUtils.writeDeclaredField((Object)conn, (String)"masterServiceState", (Object)spiedMasterServiceState, (boolean)true);
        return spiedMasterServiceState;
    }

    private Method getIsKeepAliveMasterConnectedAndRunningMethod() throws NoSuchMethodException {
        Method method = ConnectionImplementation.class.getDeclaredMethod("isKeepAliveMasterConnectedAndRunning", new Class[0]);
        method.setAccessible(true);
        return method;
    }
}

