/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.logging;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public final class Log4jUtils {
    private static final String INTERNAL_UTILS_CLASS_NAME = "org.apache.hadoop.hbase.logging.InternalLog4jUtils";

    private Log4jUtils() {
    }

    private static Method getMethod(String methodName, Class<?> ... args) {
        try {
            Class<?> clazz = Class.forName(INTERNAL_UTILS_CLASS_NAME);
            return clazz.getDeclaredMethod(methodName, args);
        }
        catch (ClassNotFoundException | NoSuchMethodException e) {
            throw new AssertionError("should not happen", e);
        }
    }

    private static void throwUnchecked(Throwable throwable) {
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
    }

    private static void invoke(Method method, Object ... args) throws AssertionError {
        try {
            method.invoke(null, args);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError("should not happen", e);
        }
        catch (InvocationTargetException e) {
            Log4jUtils.throwUnchecked(e.getCause());
            throw new AssertionError("should not happen", e.getCause());
        }
    }

    public static void setAllLevels(String loggerName, String levelName) {
        Method method = Log4jUtils.getMethod("setAllLevels", String.class, String.class);
        Log4jUtils.invoke(method, loggerName, levelName);
    }

    public static void setLogLevel(String loggerName, String levelName) {
        Method method = Log4jUtils.getMethod("setLogLevel", String.class, String.class);
        Log4jUtils.invoke(method, loggerName, levelName);
    }

    public static void setRootLevel(String levelName) {
        Method method = Log4jUtils.getMethod("setRootLevel", String.class);
        Log4jUtils.invoke(method, levelName);
    }

    public static String getEffectiveLevel(String loggerName) {
        Method method = Log4jUtils.getMethod("getEffectiveLevel", String.class);
        try {
            return (String)method.invoke(null, loggerName);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError("should not happen", e);
        }
        catch (InvocationTargetException e) {
            Log4jUtils.throwUnchecked(e.getCause());
            throw new AssertionError("should not happen", e.getCause());
        }
    }

    public static Set<File> getActiveLogFiles() throws IOException {
        Method method = Log4jUtils.getMethod("getActiveLogFiles", new Class[0]);
        try {
            return (Set)method.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError("should not happen", e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            Log4jUtils.throwUnchecked(cause);
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new AssertionError("should not happen", cause);
        }
    }

    public static void disableZkAndClientLoggers() {
        Log4jUtils.setLogLevel("org.apache.zookeeper", "OFF");
        Log4jUtils.setLogLevel("org.apache.hadoop.hbase.zookeeper", "OFF");
        Log4jUtils.setLogLevel("org.apache.hadoop.hbase.client", "OFF");
    }

    public static void enableDebug(Class<?> clazz) {
        Log4jUtils.setLogLevel(clazz.getName(), "DEBUG");
    }
}

