/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.rx.internal.operators;

import java.util.concurrent.atomic.AtomicBoolean;
import rx.Observable;
import rx.Subscriber;

public final class OnSubscribeCacheResetable<T>
implements Observable.OnSubscribe<T> {
    private final AtomicBoolean refresh = new AtomicBoolean(true);
    private final Observable<T> source;
    private volatile Observable<T> current;

    public OnSubscribeCacheResetable(Observable<T> source) {
        this.source = source;
        this.current = source;
    }

    public void call(Subscriber<? super T> subscriber) {
        if (this.refresh.compareAndSet(true, false)) {
            this.current = this.source.cache();
        }
        this.current.unsafeSubscribe(subscriber);
    }

    public void reset() {
        this.refresh.set(true);
    }
}

