/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.web.resources;

import java.io.IOException;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Options;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.StorageType;
import org.apache.hadoop.fs.XAttrCodec;
import org.apache.hadoop.fs.XAttrSetFlag;
import org.apache.hadoop.fs.permission.AclEntry;
import org.apache.hadoop.fs.permission.FsPermission;
import org.apache.hadoop.hdfs.web.resources.AccessTimeParam;
import org.apache.hadoop.hdfs.web.resources.AclPermissionParam;
import org.apache.hadoop.hdfs.web.resources.BlockSizeParam;
import org.apache.hadoop.hdfs.web.resources.BufferSizeParam;
import org.apache.hadoop.hdfs.web.resources.ConcatSourcesParam;
import org.apache.hadoop.hdfs.web.resources.DelegationParam;
import org.apache.hadoop.hdfs.web.resources.DeleteOpParam;
import org.apache.hadoop.hdfs.web.resources.DestinationParam;
import org.apache.hadoop.hdfs.web.resources.ECPolicyParam;
import org.apache.hadoop.hdfs.web.resources.FsActionParam;
import org.apache.hadoop.hdfs.web.resources.GetOpParam;
import org.apache.hadoop.hdfs.web.resources.GroupParam;
import org.apache.hadoop.hdfs.web.resources.ModificationTimeParam;
import org.apache.hadoop.hdfs.web.resources.NameSpaceQuotaParam;
import org.apache.hadoop.hdfs.web.resources.OldSnapshotNameParam;
import org.apache.hadoop.hdfs.web.resources.OverwriteParam;
import org.apache.hadoop.hdfs.web.resources.OwnerParam;
import org.apache.hadoop.hdfs.web.resources.Param;
import org.apache.hadoop.hdfs.web.resources.PermissionParam;
import org.apache.hadoop.hdfs.web.resources.PostOpParam;
import org.apache.hadoop.hdfs.web.resources.PutOpParam;
import org.apache.hadoop.hdfs.web.resources.RecursiveParam;
import org.apache.hadoop.hdfs.web.resources.RenameOptionSetParam;
import org.apache.hadoop.hdfs.web.resources.RenewerParam;
import org.apache.hadoop.hdfs.web.resources.ReplicationParam;
import org.apache.hadoop.hdfs.web.resources.SnapshotNameParam;
import org.apache.hadoop.hdfs.web.resources.StartAfterParam;
import org.apache.hadoop.hdfs.web.resources.StoragePolicyParam;
import org.apache.hadoop.hdfs.web.resources.StorageSpaceQuotaParam;
import org.apache.hadoop.hdfs.web.resources.StorageTypeParam;
import org.apache.hadoop.hdfs.web.resources.StringParam;
import org.apache.hadoop.hdfs.web.resources.TokenArgumentParam;
import org.apache.hadoop.hdfs.web.resources.UserParam;
import org.apache.hadoop.hdfs.web.resources.XAttrEncodingParam;
import org.apache.hadoop.hdfs.web.resources.XAttrNameParam;
import org.apache.hadoop.hdfs.web.resources.XAttrSetFlagParam;
import org.apache.hadoop.hdfs.web.resources.XAttrValueParam;
import org.apache.hadoop.test.GenericTestUtils;
import org.apache.hadoop.util.StringUtils;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestParam {
    public static final Logger LOG = LoggerFactory.getLogger(TestParam.class);
    final Configuration conf = new Configuration();

    @Test
    public void testAccessTimeParam() {
        AccessTimeParam p = new AccessTimeParam("-1");
        Assert.assertEquals((long)-1L, (long)((Long)p.getValue()));
        new AccessTimeParam(Long.valueOf(-1L));
        try {
            new AccessTimeParam(Long.valueOf(-2L));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            LOG.info("EXPECTED: " + e);
        }
    }

    @Test
    public void testBlockSizeParam() {
        BlockSizeParam p = new BlockSizeParam("null");
        Assert.assertEquals(null, (Object)p.getValue());
        Assert.assertEquals((long)this.conf.getLongBytes("dfs.blocksize", 0x8000000L), (long)p.getValue(this.conf));
        new BlockSizeParam(Long.valueOf(1L));
        try {
            new BlockSizeParam(Long.valueOf(0L));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            LOG.info("EXPECTED: " + e);
        }
    }

    @Test
    public void testBufferSizeParam() {
        BufferSizeParam p = new BufferSizeParam("null");
        Assert.assertEquals(null, (Object)p.getValue());
        Assert.assertEquals((long)this.conf.getInt("io.file.buffer.size", 4096), (long)p.getValue(this.conf));
        new BufferSizeParam(Integer.valueOf(1));
        try {
            new BufferSizeParam(Integer.valueOf(0));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            LOG.info("EXPECTED: " + e);
        }
    }

    @Test
    public void testDelegationParam() {
        DelegationParam p = new DelegationParam("");
        Assert.assertEquals(null, (Object)p.getValue());
    }

    @Test
    public void testDestinationParam() {
        DestinationParam p = new DestinationParam("");
        Assert.assertEquals(null, (Object)p.getValue());
        new DestinationParam("/abc");
        try {
            new DestinationParam("abc");
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            LOG.info("EXPECTED: " + e);
        }
    }

    @Test
    public void testGroupParam() {
        GroupParam p = new GroupParam("");
        Assert.assertEquals(null, (Object)p.getValue());
    }

    @Test
    public void testModificationTimeParam() {
        ModificationTimeParam p = new ModificationTimeParam("-1");
        Assert.assertEquals((long)-1L, (long)((Long)p.getValue()));
        new ModificationTimeParam(Long.valueOf(-1L));
        try {
            new ModificationTimeParam(Long.valueOf(-2L));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            LOG.info("EXPECTED: " + e);
        }
    }

    @Test
    public void testOverwriteParam() {
        OverwriteParam p = new OverwriteParam("false");
        Assert.assertEquals((Object)false, (Object)p.getValue());
        new OverwriteParam("trUe");
        try {
            new OverwriteParam("abc");
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            LOG.info("EXPECTED: " + e);
        }
    }

    @Test
    public void testOwnerParam() {
        OwnerParam p = new OwnerParam("");
        Assert.assertEquals(null, (Object)p.getValue());
    }

    @Test
    public void testPermissionParam() {
        PermissionParam p = new PermissionParam("null");
        Assert.assertEquals((Object)new FsPermission(493), (Object)p.getDirFsPermission());
        Assert.assertEquals((Object)new FsPermission(420), (Object)p.getFileFsPermission());
        new PermissionParam("0");
        try {
            new PermissionParam("-1");
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            LOG.info("EXPECTED: " + e);
        }
        new PermissionParam("1777");
        try {
            new PermissionParam("2000");
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            LOG.info("EXPECTED: " + e);
        }
        try {
            new PermissionParam("8");
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            LOG.info("EXPECTED: " + e);
        }
        try {
            new PermissionParam("abc");
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            LOG.info("EXPECTED: " + e);
        }
    }

    @Test
    public void testRecursiveParam() {
        RecursiveParam p = new RecursiveParam("false");
        Assert.assertEquals((Object)false, (Object)p.getValue());
        new RecursiveParam("falSe");
        try {
            new RecursiveParam("abc");
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            LOG.info("EXPECTED: " + e);
        }
    }

    @Test
    public void testRenewerParam() {
        RenewerParam p = new RenewerParam("null");
        Assert.assertEquals(null, (Object)p.getValue());
    }

    @Test
    public void testReplicationParam() {
        ReplicationParam p = new ReplicationParam("null");
        Assert.assertEquals(null, (Object)p.getValue());
        Assert.assertEquals((long)((short)this.conf.getInt("dfs.replication", 3)), (long)p.getValue(this.conf));
        new ReplicationParam(Short.valueOf((short)1));
        try {
            new ReplicationParam(Short.valueOf((short)0));
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            LOG.info("EXPECTED: " + e);
        }
    }

    @Test
    public void testToSortedStringEscapesURICharacters() {
        String sep = "&";
        TokenArgumentParam ampParam = new TokenArgumentParam("token&ampersand");
        RenewerParam equalParam = new RenewerParam("renewer=equal");
        String expected = "&renewer=renewer%3Dequal&token=token%26ampersand";
        String actual = Param.toSortedString((String)"&", (Param[])new Param[]{equalParam, ampParam});
        Assert.assertEquals((Object)"&renewer=renewer%3Dequal&token=token%26ampersand", (Object)actual);
    }

    @Test
    public void userNameEmpty() {
        UserParam userParam = new UserParam("");
        Assert.assertNull((Object)userParam.getValue());
    }

    @Test(expected=IllegalArgumentException.class)
    public void userNameInvalidStart() {
        new UserParam("1x");
    }

    @Test(expected=IllegalArgumentException.class)
    public void userNameInvalidDollarSign() {
        new UserParam("1$x");
    }

    @Test
    public void userNameMinLength() {
        UserParam userParam = new UserParam("a");
        Assert.assertNotNull((Object)userParam.getValue());
    }

    @Test
    public void userNameValidDollarSign() {
        UserParam userParam = new UserParam("a$");
        Assert.assertNotNull((Object)userParam.getValue());
    }

    @Test
    public void testConcatSourcesParam() {
        String[] strings = new String[]{"/", "/foo", "/bar"};
        for (int n = 0; n < strings.length; ++n) {
            String[] sub = new String[n];
            Path[] paths = new Path[n];
            for (int i = 0; i < paths.length; ++i) {
                sub[i] = strings[i];
                paths[i] = new Path(sub[i]);
            }
            String expected = StringUtils.join((CharSequence)",", Arrays.asList(sub));
            ConcatSourcesParam computed = new ConcatSourcesParam(paths);
            Assert.assertEquals((Object)expected, (Object)computed.getValue());
        }
    }

    @Test
    public void testUserNameOkAfterResettingPattern() {
        StringParam.Domain oldDomain = UserParam.getUserPatternDomain();
        String newPattern = "^[A-Za-z0-9_][A-Za-z0-9._-]*[$]?$";
        UserParam.setUserPattern((String)newPattern);
        UserParam userParam = new UserParam("1x");
        Assert.assertNotNull((Object)userParam.getValue());
        userParam = new UserParam("123");
        Assert.assertNotNull((Object)userParam.getValue());
        UserParam.setUserPatternDomain((StringParam.Domain)oldDomain);
    }

    @Test
    public void testAclPermissionParam() {
        AclPermissionParam p = new AclPermissionParam("user::rwx,group::r--,other::rwx,user:user1:rwx");
        List setAclList = AclEntry.parseAclSpec((String)"user::rwx,group::r--,other::rwx,user:user1:rwx", (boolean)true);
        Assert.assertEquals((Object)setAclList.toString(), (Object)p.getAclPermission(true).toString());
        new AclPermissionParam("user::rw-,group::rwx,other::rw-,user:user1:rwx");
        try {
            new AclPermissionParam("user::rw--,group::rwx-,other::rw-");
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            LOG.info("EXPECTED: " + e);
        }
        new AclPermissionParam("user::rw-,group::rwx,other::rw-,user:user1:rwx,group:group1:rwx,other::rwx,mask::rwx,default:user:user1:rwx");
        try {
            new AclPermissionParam("user:r-,group:rwx,other:rw-");
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            LOG.info("EXPECTED: " + e);
        }
        try {
            new AclPermissionParam("default:::r-,default:group::rwx,other::rw-");
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            LOG.info("EXPECTED: " + e);
        }
        try {
            new AclPermissionParam("user:r-,group::rwx,other:rw-,mask:rw-,temp::rwx");
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            LOG.info("EXPECTED: " + e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testUserGroupOkAfterAlteringAclPattern() {
        StringParam.Domain oldDomain = AclPermissionParam.getAclPermissionPattern();
        String newPattern = "^(default:)?(user|group|mask|other):[[0-9A-Za-z_][@A-Za-z0-9._-]]*:([rwx-]{3})?(,(default:)?(user|group|mask|other):[[0-9A-Za-z_][@A-Za-z0-9._-]]*:([rwx-]{3})?)*$";
        try {
            AclPermissionParam.setAclPermissionPattern((String)newPattern);
            String numericUserSpec = "user:110201:rwx";
            AclPermissionParam aclNumericUserParam = new AclPermissionParam(numericUserSpec);
            Assert.assertEquals((Object)numericUserSpec, (Object)aclNumericUserParam.getValue());
            String oddGroupSpec = "group:foo@bar:rwx";
            AclPermissionParam aclGroupWithDomainParam = new AclPermissionParam(oddGroupSpec);
            Assert.assertEquals((Object)oddGroupSpec, (Object)aclGroupWithDomainParam.getValue());
        }
        finally {
            AclPermissionParam.setAclPermissionPattern((StringParam.Domain)oldDomain);
        }
    }

    @Test
    public void testXAttrNameParam() {
        XAttrNameParam p = new XAttrNameParam("user.a1");
        Assert.assertEquals((Object)p.getXAttrName(), (Object)"user.a1");
    }

    @Test
    public void testXAttrValueParam() throws IOException {
        XAttrValueParam p = new XAttrValueParam("0x313233");
        Assert.assertArrayEquals((byte[])p.getXAttrValue(), (byte[])XAttrCodec.decodeValue((String)"0x313233"));
    }

    @Test
    public void testXAttrEncodingParam() {
        XAttrEncodingParam p = new XAttrEncodingParam(XAttrCodec.BASE64);
        Assert.assertEquals((Object)p.getEncoding(), (Object)XAttrCodec.BASE64);
        XAttrEncodingParam p1 = new XAttrEncodingParam(p.getValueString());
        Assert.assertEquals((Object)p1.getEncoding(), (Object)XAttrCodec.BASE64);
    }

    @Test
    public void testXAttrSetFlagParam() {
        EnumSet<XAttrSetFlag> flag = EnumSet.of(XAttrSetFlag.CREATE, XAttrSetFlag.REPLACE);
        XAttrSetFlagParam p = new XAttrSetFlagParam(flag);
        Assert.assertEquals((Object)p.getFlag(), flag);
        XAttrSetFlagParam p1 = new XAttrSetFlagParam(p.getValueString());
        Assert.assertEquals((Object)p1.getFlag(), flag);
    }

    @Test
    public void testRenameOptionSetParam() {
        RenameOptionSetParam p = new RenameOptionSetParam(new Options.Rename[]{Options.Rename.OVERWRITE, Options.Rename.NONE});
        RenameOptionSetParam p1 = new RenameOptionSetParam(p.getValueString());
        Assert.assertEquals((Object)p1.getValue(), EnumSet.of(Options.Rename.OVERWRITE, Options.Rename.NONE));
    }

    @Test
    public void testSnapshotNameParam() {
        OldSnapshotNameParam s1 = new OldSnapshotNameParam("s1");
        SnapshotNameParam s2 = new SnapshotNameParam("s2");
        Assert.assertEquals((Object)"s1", (Object)s1.getValue());
        Assert.assertEquals((Object)"s2", (Object)s2.getValue());
    }

    @Test
    public void testFsActionParam() {
        new FsActionParam("rwx");
        new FsActionParam("rw-");
        new FsActionParam("r-x");
        new FsActionParam("-wx");
        new FsActionParam("r--");
        new FsActionParam("-w-");
        new FsActionParam("--x");
        new FsActionParam("---");
        try {
            new FsActionParam("rw");
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            LOG.info("EXPECTED: " + e);
        }
        try {
            new FsActionParam("qwx");
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            LOG.info("EXPECTED: " + e);
        }
        try {
            new FsActionParam("qrwx");
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            LOG.info("EXPECTED: " + e);
        }
        try {
            new FsActionParam("rwxx");
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            LOG.info("EXPECTED: " + e);
        }
        try {
            new FsActionParam("xwr");
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            LOG.info("EXPECTED: " + e);
        }
        try {
            new FsActionParam("r-w");
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            LOG.info("EXPECTED: " + e);
        }
    }

    @Test
    public void testStartAfterParam() throws Exception {
        String s = "/helloWorld";
        StartAfterParam param = new StartAfterParam(s);
        Assert.assertEquals((Object)s, (Object)param.getValue());
    }

    @Test
    public void testStoragePolicyParam() {
        StoragePolicyParam p = new StoragePolicyParam("");
        Assert.assertEquals(null, (Object)p.getValue());
        p = new StoragePolicyParam("COLD");
        Assert.assertEquals((Object)"COLD", (Object)p.getValue());
    }

    @Test
    public void testNamespaceQuotaParam() {
        NameSpaceQuotaParam p = new NameSpaceQuotaParam("9223372036854775807");
        Assert.assertEquals((Object)Long.valueOf("9223372036854775807"), (Object)p.getValue());
        p = new NameSpaceQuotaParam(Long.valueOf(100L));
        Assert.assertEquals((long)100L, (long)((Long)p.getValue()));
    }

    @Test
    public void testStorageSpaceQuotaParam() {
        StorageSpaceQuotaParam sp = new StorageSpaceQuotaParam("9223372036854775807");
        Assert.assertEquals((Object)Long.valueOf("9223372036854775807"), (Object)sp.getValue());
        sp = new StorageSpaceQuotaParam(Long.valueOf(100L));
        Assert.assertEquals((long)100L, (long)((Long)sp.getValue()));
    }

    @Test
    public void testStorageTypeParam() {
        StorageTypeParam p = new StorageTypeParam("");
        Assert.assertNull((Object)p.getValue());
        p = new StorageTypeParam(StorageType.DISK.name());
        Assert.assertEquals((Object)StorageType.DISK.name(), (Object)p.getValue());
    }

    @Test
    public void testECPolicyParam() {
        ECPolicyParam p = new ECPolicyParam("");
        Assert.assertEquals(null, (Object)p.getValue());
        p = new ECPolicyParam("RS-6-3-1024k");
        Assert.assertEquals((Object)"RS-6-3-1024k", (Object)p.getValue());
    }

    @Test
    public void testHttpOpParams() {
        try {
            new PostOpParam("TEST");
            Assert.fail((String)"Construct the PostOpParam with param value 'TEST' should be failed.");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"TEST is not a valid POST operation.", (Throwable)e);
        }
        try {
            new PutOpParam("TEST");
            Assert.fail((String)"Construct the PutOpParam with param value 'TEST' should be failed.");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"TEST is not a valid PUT operation.", (Throwable)e);
        }
        try {
            new DeleteOpParam("TEST");
            Assert.fail((String)"Construct the DeleteOpParam with param value 'TEST' should be failed.");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"TEST is not a valid DELETE operation.", (Throwable)e);
        }
        try {
            new GetOpParam("TEST");
            Assert.fail((String)"Construct the GetOpParam with param value 'TEST' should be failed.");
        }
        catch (IllegalArgumentException e) {
            GenericTestUtils.assertExceptionContains((String)"TEST is not a valid GET operation.", (Throwable)e);
        }
    }
}

