/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.datanode;

import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hdfs.HdfsConfiguration;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.datanode.SecureDataNodeStarter;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SecurityUtilTestHelper;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;

public class TestStartSecureDataNode {
    @Rule
    public ExpectedException thrown = ExpectedException.none();
    private static final int NUM_OF_DATANODES = 1;

    private void testExternalKdcRunning() {
        Assume.assumeTrue((boolean)SecurityUtilTestHelper.isExternalKdcRunning());
    }

    @Test
    public void testSecureNameNode() throws Exception {
        this.testExternalKdcRunning();
        MiniDFSCluster cluster = null;
        try {
            String nnPrincipal = System.getProperty("dfs.namenode.kerberos.principal");
            String nnSpnegoPrincipal = System.getProperty("dfs.namenode.kerberos.internal.spnego.principal");
            String nnKeyTab = System.getProperty("dfs.namenode.keytab.file");
            Assert.assertNotNull((String)"NameNode principal was not specified", (Object)nnPrincipal);
            Assert.assertNotNull((String)"NameNode SPNEGO principal was not specified", (Object)nnSpnegoPrincipal);
            Assert.assertNotNull((String)"NameNode keytab was not specified", (Object)nnKeyTab);
            String dnPrincipal = System.getProperty("dfs.datanode.kerberos.principal");
            String dnKeyTab = System.getProperty("dfs.datanode.keytab.file");
            Assert.assertNotNull((String)"DataNode principal was not specified", (Object)dnPrincipal);
            Assert.assertNotNull((String)"DataNode keytab was not specified", (Object)dnKeyTab);
            HdfsConfiguration conf = new HdfsConfiguration();
            conf.set("hadoop.security.authentication", "kerberos");
            conf.set("dfs.namenode.kerberos.principal", nnPrincipal);
            conf.set("dfs.namenode.kerberos.internal.spnego.principal", nnSpnegoPrincipal);
            conf.set("dfs.namenode.keytab.file", nnKeyTab);
            conf.set("dfs.datanode.kerberos.principal", dnPrincipal);
            conf.set("dfs.datanode.keytab.file", dnKeyTab);
            conf.set("dfs.datanode.address", "127.0.0.1:1004");
            conf.set("dfs.datanode.http.address", "127.0.0.1:1006");
            conf.set("dfs.datanode.data.dir", "700");
            cluster = new MiniDFSCluster.Builder((Configuration)conf).numDataNodes(1).checkDataNodeAddrConfig(true).build();
            cluster.waitActive();
            Assert.assertTrue((boolean)cluster.isDataNodeUp());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
        finally {
            if (cluster != null) {
                cluster.shutdown();
            }
        }
    }

    @Test
    public void testStreamingAddrBindException() throws Exception {
        try (ServerSocket ss = new ServerSocket();){
            ss.bind(new InetSocketAddress("localhost", 0));
            this.thrown.expect(BindException.class);
            this.thrown.expectMessage("localhost/127.0.0.1:" + ss.getLocalPort());
            HdfsConfiguration conf = new HdfsConfiguration();
            conf.set("dfs.datanode.address", "localhost:" + ss.getLocalPort());
            SecureDataNodeStarter.getSecureResources((Configuration)conf);
        }
    }

    @Test
    public void testWebServerAddrBindException() throws Exception {
        try (ServerSocket ss = new ServerSocket();){
            ss.bind(new InetSocketAddress("localhost", 0));
            this.thrown.expect(BindException.class);
            this.thrown.expectMessage("localhost/127.0.0.1:" + ss.getLocalPort());
            HdfsConfiguration conf = new HdfsConfiguration();
            conf.set("dfs.datanode.address", "localhost:" + NetUtils.getFreeSocketPort());
            conf.set("dfs.datanode.http.address", "localhost:" + ss.getLocalPort());
            SecureDataNodeStarter.getSecureResources((Configuration)conf);
        }
    }
}

