/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.fs.contract.router;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.contract.hdfs.HDFSContract;
import org.apache.hadoop.fs.contract.router.SecurityConfUtil;
import org.apache.hadoop.hdfs.MiniDFSCluster;
import org.apache.hadoop.hdfs.server.federation.FederationTestUtils;
import org.apache.hadoop.hdfs.server.federation.MiniRouterDFSCluster;
import org.junit.Assert;

public class RouterHDFSContract
extends HDFSContract {
    public static final int BLOCK_SIZE = 1024;
    private static MiniRouterDFSCluster cluster;

    public RouterHDFSContract(Configuration conf) {
        super(conf);
    }

    public static void createCluster() throws IOException {
        RouterHDFSContract.createCluster(false);
    }

    public static void createCluster(boolean security) throws IOException {
        RouterHDFSContract.createCluster(true, 2, security);
    }

    public static void createCluster(boolean ha, int numNameServices, boolean security) throws IOException {
        try {
            Configuration conf = null;
            if (security) {
                conf = SecurityConfUtil.initSecurity();
            }
            cluster = new MiniRouterDFSCluster(ha, numNameServices, conf);
            cluster.startCluster(conf);
            cluster.startRouters();
            cluster.registerNamenodes();
            cluster.waitNamenodeRegistration();
            cluster.installMockLocations();
            if (cluster.isHighAvailability()) {
                for (String ns : cluster.getNameservices()) {
                    cluster.switchToActive(ns, FederationTestUtils.NAMENODES[0]);
                    cluster.switchToStandby(ns, FederationTestUtils.NAMENODES[1]);
                }
            }
            cluster.waitActiveNamespaces();
        }
        catch (Exception e) {
            RouterHDFSContract.destroyCluster();
            throw new IOException("Cannot start federated cluster", e);
        }
    }

    public static void destroyCluster() throws IOException {
        if (cluster != null) {
            cluster.shutdown();
            cluster = null;
        }
        try {
            SecurityConfUtil.destroy();
        }
        catch (Exception e) {
            throw new IOException("Cannot destroy security context", e);
        }
    }

    public static MiniDFSCluster getCluster() {
        return cluster.getCluster();
    }

    public static MiniRouterDFSCluster getRouterCluster() {
        return cluster;
    }

    public static FileSystem getFileSystem() throws IOException {
        Assert.assertNotNull((String)"cluster not created", (Object)cluster);
        return cluster.getRandomRouter().getFileSystem();
    }

    public FileSystem getTestFileSystem() throws IOException {
        return RouterHDFSContract.getFileSystem();
    }
}

