/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.server.api.protocolrecords;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.NodeAttribute;
import org.apache.hadoop.yarn.api.records.NodeLabel;
import org.apache.hadoop.yarn.server.api.protocolrecords.LogAggregationReport;
import org.apache.hadoop.yarn.server.api.records.AppCollectorData;
import org.apache.hadoop.yarn.server.api.records.MasterKey;
import org.apache.hadoop.yarn.server.api.records.NodeStatus;
import org.apache.hadoop.yarn.util.Records;

public abstract class NodeHeartbeatRequest {
    public static NodeHeartbeatRequest newInstance(NodeStatus nodeStatus, MasterKey lastKnownContainerTokenMasterKey, MasterKey lastKnownNMTokenMasterKey, Set<NodeLabel> nodeLabels) {
        NodeHeartbeatRequest nodeHeartbeatRequest = (NodeHeartbeatRequest)Records.newRecord(NodeHeartbeatRequest.class);
        nodeHeartbeatRequest.setNodeStatus(nodeStatus);
        nodeHeartbeatRequest.setLastKnownContainerTokenMasterKey(lastKnownContainerTokenMasterKey);
        nodeHeartbeatRequest.setLastKnownNMTokenMasterKey(lastKnownNMTokenMasterKey);
        nodeHeartbeatRequest.setNodeLabels(nodeLabels);
        return nodeHeartbeatRequest;
    }

    public static NodeHeartbeatRequest newInstance(NodeStatus nodeStatus, MasterKey lastKnownContainerTokenMasterKey, MasterKey lastKnownNMTokenMasterKey, Set<NodeLabel> nodeLabels, Map<ApplicationId, AppCollectorData> registeringCollectors) {
        NodeHeartbeatRequest nodeHeartbeatRequest = (NodeHeartbeatRequest)Records.newRecord(NodeHeartbeatRequest.class);
        nodeHeartbeatRequest.setNodeStatus(nodeStatus);
        nodeHeartbeatRequest.setLastKnownContainerTokenMasterKey(lastKnownContainerTokenMasterKey);
        nodeHeartbeatRequest.setLastKnownNMTokenMasterKey(lastKnownNMTokenMasterKey);
        nodeHeartbeatRequest.setNodeLabels(nodeLabels);
        nodeHeartbeatRequest.setRegisteringCollectors(registeringCollectors);
        return nodeHeartbeatRequest;
    }

    public static NodeHeartbeatRequest newInstance(NodeStatus nodeStatus, MasterKey lastKnownContainerTokenMasterKey, MasterKey lastKnownNMTokenMasterKey, Set<NodeLabel> nodeLabels, Set<NodeAttribute> nodeAttributes, Map<ApplicationId, AppCollectorData> registeringCollectors) {
        NodeHeartbeatRequest request = NodeHeartbeatRequest.newInstance(nodeStatus, lastKnownContainerTokenMasterKey, lastKnownNMTokenMasterKey, nodeLabels, registeringCollectors);
        request.setNodeAttributes(nodeAttributes);
        return request;
    }

    public abstract NodeStatus getNodeStatus();

    public abstract void setNodeStatus(NodeStatus var1);

    public abstract MasterKey getLastKnownContainerTokenMasterKey();

    public abstract void setLastKnownContainerTokenMasterKey(MasterKey var1);

    public abstract MasterKey getLastKnownNMTokenMasterKey();

    public abstract void setLastKnownNMTokenMasterKey(MasterKey var1);

    public abstract Set<NodeLabel> getNodeLabels();

    public abstract void setNodeLabels(Set<NodeLabel> var1);

    public abstract List<LogAggregationReport> getLogAggregationReportsForApps();

    public abstract void setLogAggregationReportsForApps(List<LogAggregationReport> var1);

    public abstract Map<ApplicationId, AppCollectorData> getRegisteringCollectors();

    public abstract void setRegisteringCollectors(Map<ApplicationId, AppCollectorData> var1);

    public abstract Set<NodeAttribute> getNodeAttributes();

    public abstract void setNodeAttributes(Set<NodeAttribute> var1);

    public abstract void setTokenSequenceNo(long var1);

    public abstract long getTokenSequenceNo();
}

