/*
 * Decompiled with CFR 0.152.
 */
package org.grails.cli.command.archive;

import groovy.lang.Grab;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.jar.Manifest;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import org.codehaus.groovy.ast.ASTNode;
import org.codehaus.groovy.ast.AnnotatedNode;
import org.codehaus.groovy.ast.AnnotationNode;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.transform.ASTTransformation;
import org.grails.cli.archive.PackagedSpringApplicationLauncher;
import org.grails.cli.boot.SpringApplicationLauncher;
import org.grails.cli.command.OptionParsingCommand;
import org.grails.cli.command.archive.ResourceMatcher;
import org.grails.cli.command.options.CompilerOptionHandler;
import org.grails.cli.command.options.OptionSetGroovyCompilerConfiguration;
import org.grails.cli.command.options.SourceOptions;
import org.grails.cli.compiler.GroovyCompiler;
import org.grails.cli.compiler.RepositoryConfigurationFactory;
import org.grails.cli.compiler.grape.RepositoryConfiguration;
import org.springframework.boot.cli.command.options.OptionHandler;
import org.springframework.boot.cli.command.status.ExitStatus;
import org.springframework.boot.loader.tools.JarWriter;
import org.springframework.boot.loader.tools.Layout;
import org.springframework.boot.loader.tools.Library;
import org.springframework.boot.loader.tools.LibraryScope;
import org.springframework.boot.loader.tools.Repackager;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.util.Assert;

abstract class ArchiveCommand
extends OptionParsingCommand {
    protected ArchiveCommand(String name, String description, OptionHandler optionHandler) {
        super(name, description, optionHandler);
    }

    @Override
    public String getUsageHelp() {
        return "[options] <" + this.getName() + "-name> <files>";
    }

    private static class GrabAnnotationTransform
    implements ASTTransformation {
        private GrabAnnotationTransform() {
        }

        @Override
        public void visit(ASTNode[] nodes, SourceUnit source) {
            for (ASTNode node : nodes) {
                if (!(node instanceof ModuleNode)) continue;
                this.visitModule((ModuleNode)node);
            }
        }

        private void visitModule(ModuleNode module) {
            Iterator<ClassNode> iterator = module.getClasses().iterator();
            if (iterator.hasNext()) {
                ClassNode classNode = iterator.next();
                AnnotationNode annotation = new AnnotationNode(new ClassNode(Grab.class));
                annotation.addMember("value", new ConstantExpression("groovy"));
                classNode.addAnnotation(annotation);
            }
            this.disableGrabResolvers(module.getClasses());
            this.disableGrabResolvers(module.getImports());
        }

        private void disableGrabResolvers(List<? extends AnnotatedNode> nodes) {
            for (AnnotatedNode annotatedNode : nodes) {
                List<AnnotationNode> annotations = annotatedNode.getAnnotations();
                for (AnnotationNode node : new ArrayList<AnnotationNode>(annotations)) {
                    if (!node.getClassNode().getNameWithoutPackage().equals("GrabResolver")) continue;
                    node.setMember("initClass", new ConstantExpression(false));
                }
            }
        }
    }

    protected static abstract class ArchiveOptionHandler
    extends CompilerOptionHandler {
        private final String type;
        private final Layout layout;
        private OptionSpec<String> includeOption;
        private OptionSpec<String> excludeOption;

        public ArchiveOptionHandler(String type, Layout layout) {
            this.type = type;
            this.layout = layout;
        }

        protected Layout getLayout() {
            return this.layout;
        }

        @Override
        protected void doOptions() {
            this.includeOption = this.option("include", "Pattern applied to directories on the classpath to find files to include in the resulting ").withRequiredArg().withValuesSeparatedBy(",").defaultsTo("", (String[])new String[0]);
            this.excludeOption = this.option("exclude", "Pattern applied to directories on the classpath to find files to exclude from the resulting " + this.type).withRequiredArg().withValuesSeparatedBy(",").defaultsTo("", (String[])new String[0]);
        }

        @Override
        protected ExitStatus run(OptionSet options) throws Exception {
            ArrayList nonOptionArguments = new ArrayList(options.nonOptionArguments());
            Assert.isTrue(nonOptionArguments.size() >= 2, () -> "The name of the resulting " + this.type + " and at least one source file must be specified");
            File output = new File((String)nonOptionArguments.remove(0));
            Assert.isTrue(output.getName().toLowerCase(Locale.ENGLISH).endsWith("." + this.type), () -> "The output '" + String.valueOf(output) + "' is not a " + this.type.toUpperCase(Locale.ENGLISH) + " file.");
            this.deleteIfExists(output);
            GroovyCompiler compiler = this.createCompiler(options);
            List<URL> classpath = this.getClassPathUrls(compiler);
            List<ResourceMatcher.MatchedResource> classpathEntries = this.findMatchingClasspathEntries(classpath, options);
            String[] sources = new SourceOptions(nonOptionArguments).getSourcesArray();
            Class<?>[] compiledClasses = compiler.compile(sources);
            List<URL> dependencies2 = this.getClassPathUrls(compiler);
            dependencies2.removeAll(classpath);
            this.writeJar(output, compiledClasses, classpathEntries, dependencies2);
            return ExitStatus.OK;
        }

        private void deleteIfExists(File file) {
            if (file.exists() && !file.delete()) {
                throw new IllegalStateException("Failed to delete existing file " + file.getPath());
            }
        }

        private GroovyCompiler createCompiler(OptionSet options) {
            List<RepositoryConfiguration> repositoryConfiguration = RepositoryConfigurationFactory.createDefaultRepositoryConfiguration();
            OptionSetGroovyCompilerConfiguration configuration = new OptionSetGroovyCompilerConfiguration(options, this, repositoryConfiguration);
            GroovyCompiler groovyCompiler = new GroovyCompiler(configuration);
            groovyCompiler.getAstTransformations().add(0, new GrabAnnotationTransform());
            return groovyCompiler;
        }

        private List<URL> getClassPathUrls(GroovyCompiler compiler) {
            return new ArrayList<URL>(Arrays.asList(compiler.getLoader().getURLs()));
        }

        private List<ResourceMatcher.MatchedResource> findMatchingClasspathEntries(List<URL> classpath, OptionSet options) throws IOException {
            ResourceMatcher matcher = new ResourceMatcher(options.valuesOf(this.includeOption), options.valuesOf(this.excludeOption));
            ArrayList<File> roots = new ArrayList<File>();
            for (URL classpathEntry : classpath) {
                roots.add(new File(URI.create(classpathEntry.toString())));
            }
            return matcher.find(roots);
        }

        private void writeJar(File file, Class<?>[] compiledClasses, List<ResourceMatcher.MatchedResource> classpathEntries, List<URL> dependencies2) throws IOException, URISyntaxException {
            List<Library> libraries;
            try (JarWriter writer = new JarWriter(file);){
                this.addManifest(writer, compiledClasses);
                this.addCliClasses(writer);
                for (Class<?> compiledClass : compiledClasses) {
                    this.addClass(writer, compiledClass);
                }
                libraries = this.addClasspathEntries(writer, classpathEntries);
            }
            libraries.addAll(this.createLibraries(dependencies2));
            Repackager repackager = new Repackager(file);
            repackager.setMainClass(PackagedSpringApplicationLauncher.class.getName());
            repackager.repackage(callback -> {
                for (Library library : libraries) {
                    callback.library(library);
                }
            });
        }

        private List<Library> createLibraries(List<URL> dependencies2) throws URISyntaxException {
            ArrayList<Library> libraries = new ArrayList<Library>();
            for (URL dependency : dependencies2) {
                File file = new File(dependency.toURI());
                libraries.add(new Library(null, file, this.getLibraryScope(file), null, false, false, true));
            }
            return libraries;
        }

        private void addManifest(JarWriter writer, Class<?>[] compiledClasses) throws IOException {
            Manifest manifest = new Manifest();
            manifest.getMainAttributes().putValue("Manifest-Version", "1.0");
            manifest.getMainAttributes().putValue("Spring-Application-Source-Classes", this.commaDelimitedClassNames(compiledClasses));
            writer.writeManifest(manifest);
        }

        private String commaDelimitedClassNames(Class<?>[] classes) {
            StringBuilder builder = new StringBuilder();
            for (int i2 = 0; i2 < classes.length; ++i2) {
                if (i2 != 0) {
                    builder.append(',');
                }
                builder.append(classes[i2].getName());
            }
            return builder.toString();
        }

        protected void addCliClasses(JarWriter writer) throws IOException {
            Resource[] resources;
            this.addClass(writer, PackagedSpringApplicationLauncher.class);
            this.addClass(writer, SpringApplicationLauncher.class);
            for (Resource resource : resources = new PathMatchingResourcePatternResolver().getResources("org/grails/cli/groovy/**")) {
                String url = resource.getURL().toString();
                this.addResource(writer, resource, url.substring(url.indexOf("org/grails/cli/groovy/")));
            }
        }

        protected final void addClass(JarWriter writer, Class<?> sourceClass) throws IOException {
            this.addClass(writer, sourceClass.getClassLoader(), sourceClass.getName());
        }

        protected final void addClass(JarWriter writer, ClassLoader classLoader, String sourceClass) throws IOException {
            if (classLoader == null) {
                classLoader = Thread.currentThread().getContextClassLoader();
            }
            String name = sourceClass.replace('.', '/') + ".class";
            InputStream stream = classLoader.getResourceAsStream(name);
            writer.writeEntry(this.layout.getClassesLocation() + name, stream);
        }

        private void addResource(JarWriter writer, Resource resource, String name) throws IOException {
            InputStream stream = resource.getInputStream();
            writer.writeEntry(name, stream);
        }

        private List<Library> addClasspathEntries(JarWriter writer, List<ResourceMatcher.MatchedResource> entries) throws IOException {
            ArrayList<Library> libraries = new ArrayList<Library>();
            for (ResourceMatcher.MatchedResource entry : entries) {
                if (entry.isRoot()) {
                    libraries.add(new Library(null, entry.getFile(), LibraryScope.COMPILE, null, false, false, true));
                    continue;
                }
                this.writeClasspathEntry(writer, entry);
            }
            return libraries;
        }

        protected void writeClasspathEntry(JarWriter writer, ResourceMatcher.MatchedResource entry) throws IOException {
            writer.writeEntry(entry.getName(), new FileInputStream(entry.getFile()));
        }

        protected abstract LibraryScope getLibraryScope(File var1);
    }
}

