/*
 * Decompiled with CFR 0.152.
 */
package org.grails.build.interactive;

import java.io.IOException;
import java.util.List;
import jline.console.ConsoleReader;
import jline.console.CursorBuffer;
import jline.console.completer.CompletionHandler;

public class CandidateListCompletionHandler
implements CompletionHandler {
    private boolean eagerNewlines = true;

    public void setAlwaysIncludeNewline(boolean eagerNewlines) {
        this.eagerNewlines = eagerNewlines;
    }

    @Override
    public boolean complete(ConsoleReader reader, List<CharSequence> candidates, int pos) throws IOException {
        CursorBuffer buf = reader.getCursorBuffer();
        if (candidates.size() == 1) {
            String value = candidates.get(0).toString();
            if (value.equals(buf.toString())) {
                return false;
            }
            jline.console.completer.CandidateListCompletionHandler.setBuffer(reader, value, pos);
            return true;
        }
        if (candidates.size() > 1) {
            String value = this.getUnambiguousCompletions(candidates);
            jline.console.completer.CandidateListCompletionHandler.setBuffer(reader, value, pos);
        }
        if (this.eagerNewlines) {
            reader.println();
        }
        jline.console.completer.CandidateListCompletionHandler.printCandidates(reader, candidates);
        reader.drawLine();
        return true;
    }

    private final String getUnambiguousCompletions(List<?> candidates) {
        if (candidates == null || candidates.isEmpty()) {
            return null;
        }
        String[] strings = candidates.toArray(new String[candidates.size()]);
        String first = strings[0];
        StringBuilder candidate = new StringBuilder();
        int count = first.length();
        for (int i2 = 0; i2 < count && this.startsWith(first.substring(0, i2 + 1), strings); ++i2) {
            candidate.append(first.charAt(i2));
        }
        return candidate.toString();
    }

    private final boolean startsWith(String starts, String[] candidates) {
        for (int i2 = 0; i2 < candidates.length; ++i2) {
            if (candidates[i2].startsWith(starts)) continue;
            return false;
        }
        return true;
    }
}

