/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.uri;

import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.annotation.Nullable;
import io.micronaut.core.convert.value.MutableConvertibleMultiValues;
import io.micronaut.core.convert.value.MutableConvertibleMultiValuesMap;
import io.micronaut.core.util.ArrayUtils;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.core.util.StringUtils;
import io.micronaut.http.exceptions.UriSyntaxException;
import io.micronaut.http.uri.QueryStringDecoder;
import io.micronaut.http.uri.UriBuilder;
import io.micronaut.http.uri.UriTemplate;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;

class DefaultUriBuilder
implements UriBuilder {
    private String authority;
    private final MutableConvertibleMultiValues<String> queryParams;
    private String scheme;
    private String userInfo;
    private String host;
    private int port = -1;
    private StringBuilder path = new StringBuilder();
    private String fragment;

    DefaultUriBuilder(URI uri) {
        this.scheme = uri.getScheme();
        this.userInfo = uri.getRawUserInfo();
        this.authority = uri.getRawAuthority();
        this.host = uri.getHost();
        this.port = uri.getPort();
        this.path = new StringBuilder();
        String rawPath = uri.getRawPath();
        if (rawPath != null) {
            this.path.append(rawPath);
        }
        this.fragment = uri.getRawFragment();
        String query = uri.getQuery();
        if (query != null) {
            Map parameters = new QueryStringDecoder(uri).parameters();
            this.queryParams = new MutableConvertibleMultiValuesMap<String>(parameters);
        } else {
            this.queryParams = new MutableConvertibleMultiValuesMap<String>();
        }
    }

    DefaultUriBuilder(CharSequence uri) {
        if (UriTemplate.PATTERN_SCHEME.matcher(uri).matches()) {
            Matcher matcher = UriTemplate.PATTERN_FULL_URI.matcher(uri);
            if (matcher.find()) {
                String scheme = matcher.group(2);
                if (scheme != null) {
                    this.scheme = scheme;
                }
                String userInfo = matcher.group(5);
                String host = matcher.group(6);
                String port = matcher.group(8);
                String path = matcher.group(9);
                String query = matcher.group(11);
                String fragment = matcher.group(13);
                if (userInfo != null) {
                    this.userInfo = userInfo;
                }
                if (host != null) {
                    this.host = host;
                }
                if (port != null) {
                    this.port = Integer.valueOf(port);
                }
                if (path != null) {
                    if (fragment != null) {
                        this.fragment = fragment;
                    }
                    this.path = new StringBuilder(path);
                }
                if (query != null) {
                    Map parameters = new QueryStringDecoder(query).parameters();
                    this.queryParams = new MutableConvertibleMultiValuesMap<String>(parameters);
                } else {
                    this.queryParams = new MutableConvertibleMultiValuesMap<String>();
                }
            } else {
                this.path = new StringBuilder(uri.toString());
                this.queryParams = new MutableConvertibleMultiValuesMap<String>();
            }
        } else {
            Matcher matcher = UriTemplate.PATTERN_FULL_PATH.matcher(uri);
            if (matcher.find()) {
                String path = matcher.group(1);
                String query = matcher.group(3);
                this.fragment = matcher.group(5);
                this.path = new StringBuilder(path);
                if (query != null) {
                    Map parameters = new QueryStringDecoder(uri.toString()).parameters();
                    this.queryParams = new MutableConvertibleMultiValuesMap<String>(parameters);
                } else {
                    this.queryParams = new MutableConvertibleMultiValuesMap<String>();
                }
            } else {
                this.path = new StringBuilder(uri.toString());
                this.queryParams = new MutableConvertibleMultiValuesMap<String>();
            }
        }
    }

    @Override
    @NonNull
    public UriBuilder fragment(@Nullable String fragment) {
        if (fragment != null) {
            this.fragment = fragment;
        }
        return this;
    }

    @Override
    @NonNull
    public UriBuilder scheme(@Nullable String scheme) {
        if (scheme != null) {
            this.scheme = scheme;
        }
        return this;
    }

    @Override
    @NonNull
    public UriBuilder userInfo(@Nullable String userInfo) {
        if (userInfo != null) {
            this.userInfo = userInfo;
        }
        return this;
    }

    @Override
    @NonNull
    public UriBuilder host(@Nullable String host) {
        if (host != null) {
            this.host = host;
        }
        return this;
    }

    @Override
    @NonNull
    public UriBuilder port(int port) {
        if (port < -1) {
            throw new IllegalArgumentException("Invalid port value");
        }
        this.port = port;
        return this;
    }

    @Override
    @NonNull
    public UriBuilder path(@Nullable String path) {
        if (StringUtils.isNotEmpty(path)) {
            boolean endsWithSlash;
            int len = this.path.length();
            boolean bl = endsWithSlash = len > 0 && this.path.charAt(len - 1) == '/';
            if (endsWithSlash) {
                if (path.charAt(0) == '/') {
                    this.path.append(path.substring(1));
                } else {
                    this.path.append(path);
                }
            } else if (path.charAt(0) == '/') {
                this.path.append(path);
            } else {
                this.path.append('/').append(path);
            }
        }
        return this;
    }

    @Override
    @NonNull
    public UriBuilder replacePath(@Nullable String path) {
        if (path != null) {
            this.path.setLength(0);
            this.path.append(path);
        }
        return this;
    }

    @Override
    @NonNull
    public UriBuilder queryParam(String name, Object ... values) {
        if (StringUtils.isNotEmpty(name) && ArrayUtils.isNotEmpty(values)) {
            List existing = this.queryParams.getAll(name);
            ArrayList strings = existing != null ? new ArrayList(existing) : new ArrayList(values.length);
            for (Object value : values) {
                if (value == null) continue;
                strings.add(value.toString());
            }
            if (CollectionUtils.isNotEmpty(strings)) {
                this.queryParams.put(name, (String)((Object)strings));
            }
        }
        return this;
    }

    @Override
    @NonNull
    public UriBuilder replaceQueryParam(String name, Object ... values) {
        if (StringUtils.isNotEmpty(name) && ArrayUtils.isNotEmpty(values)) {
            ArrayList<String> strings = new ArrayList<String>(values.length);
            for (Object value : values) {
                if (value == null) continue;
                strings.add(value.toString());
            }
            if (CollectionUtils.isNotEmpty(strings)) {
                this.queryParams.put(name, (String)((Object)strings));
            }
        }
        return this;
    }

    @Override
    @NonNull
    public URI build() {
        try {
            return new URI(this.reconstructAsString(null));
        }
        catch (URISyntaxException e) {
            throw new UriSyntaxException(e);
        }
    }

    @Override
    @NonNull
    public URI expand(Map<String, ? super Object> values) {
        String uri = this.reconstructAsString(values);
        return URI.create(uri);
    }

    public String toString() {
        return this.build().toString();
    }

    private String reconstructAsString(Map<String, ? super Object> values) {
        String fragment;
        StringBuilder path;
        StringBuilder builder = new StringBuilder();
        String scheme = this.scheme;
        String host = this.host;
        if (StringUtils.isNotEmpty(scheme)) {
            if (this.isTemplate(scheme, values)) {
                scheme = UriTemplate.of(scheme).expand(values);
            }
            builder.append(scheme).append(":");
        }
        boolean hasPort = this.port != -1;
        boolean hasHost = host != null;
        boolean hasUserInfo = StringUtils.isNotEmpty(this.userInfo);
        if (hasUserInfo || hasHost || hasPort) {
            builder.append("//");
            if (hasUserInfo) {
                String userInfo = this.userInfo;
                if (userInfo.contains(":")) {
                    String[] sa = userInfo.split(":");
                    userInfo = this.expandOrEncode(sa[0], values) + ":" + this.expandOrEncode(sa[1], values);
                } else {
                    userInfo = this.expandOrEncode(userInfo, values);
                }
                builder.append(userInfo);
                builder.append("@");
            }
            if (hasHost) {
                host = this.expandOrEncode(host, values);
                builder.append(host);
            }
            if (hasPort) {
                builder.append(":").append(this.port);
            }
        } else {
            String authority = this.authority;
            if (StringUtils.isNotEmpty(authority)) {
                authority = this.expandOrEncode(authority, values);
                builder.append("//").append(authority);
            }
        }
        if (StringUtils.isNotEmpty(path = this.path)) {
            String pathStr;
            if (builder.length() > 0 && path.charAt(0) != '/') {
                builder.append('/');
            }
            if (this.isTemplate(pathStr = path.toString(), values)) {
                pathStr = UriTemplate.of(pathStr).expand(values);
            }
            builder.append(pathStr);
        }
        if (!this.queryParams.isEmpty()) {
            builder.append('?');
            builder.append(this.buildQueryParams(values));
        }
        if (StringUtils.isNotEmpty(fragment = this.fragment)) {
            if ((fragment = this.expandOrEncode(fragment, values)).charAt(0) != '#') {
                builder.append('#');
            }
            builder.append(fragment);
        }
        return builder.toString();
    }

    private boolean isTemplate(String value, Map<String, ? super Object> values) {
        return values != null && value.indexOf(123) > -1;
    }

    private String buildQueryParams(Map<String, ? super Object> values) {
        if (!this.queryParams.isEmpty()) {
            StringBuilder builder = new StringBuilder();
            Iterator nameIterator = this.queryParams.iterator();
            while (nameIterator.hasNext()) {
                Map.Entry entry = nameIterator.next();
                String rawName = entry.getKey();
                String name = this.expandOrEncode(rawName, values);
                Iterator i2 = entry.getValue().iterator();
                while (i2.hasNext()) {
                    String v = this.expandOrEncode((String)i2.next(), values);
                    builder.append(name).append('=').append(v);
                    if (!i2.hasNext()) continue;
                    builder.append('&');
                }
                if (!nameIterator.hasNext()) continue;
                builder.append('&');
            }
            return builder.toString();
        }
        return null;
    }

    private String expandOrEncode(String value, Map<String, ? super Object> values) {
        value = this.isTemplate(value, values) ? UriTemplate.of(value).expand(values) : this.encode(value);
        return value;
    }

    private String encode(String userInfo) {
        try {
            return URLEncoder.encode(userInfo, StandardCharsets.UTF_8.name());
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException("No available charset: " + e.getMessage());
        }
    }
}

