/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.http.client;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.support.HttpComponentsHeadersAdapter;
import org.springframework.lang.Nullable;

final class HttpComponentsClientHttpResponse
implements ClientHttpResponse {
    private final ClassicHttpResponse httpResponse;
    @Nullable
    private HttpHeaders headers;

    HttpComponentsClientHttpResponse(ClassicHttpResponse httpResponse) {
        this.httpResponse = httpResponse;
    }

    @Override
    public HttpStatusCode getStatusCode() {
        return HttpStatusCode.valueOf(this.httpResponse.getCode());
    }

    @Override
    public String getStatusText() {
        return this.httpResponse.getReasonPhrase();
    }

    @Override
    public HttpHeaders getHeaders() {
        if (this.headers == null) {
            HttpComponentsHeadersAdapter adapter = new HttpComponentsHeadersAdapter(this.httpResponse);
            this.headers = HttpHeaders.readOnlyHttpHeaders(adapter);
        }
        return this.headers;
    }

    @Override
    public InputStream getBody() throws IOException {
        HttpEntity entity = this.httpResponse.getEntity();
        return entity != null ? entity.getContent() : InputStream.nullInputStream();
    }

    @Override
    public void close() {
        try {
            try {
                EntityUtils.consume(this.httpResponse.getEntity());
            }
            finally {
                this.httpResponse.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

