/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.autoconfigure.h2;

import java.sql.Connection;
import java.util.List;
import java.util.Objects;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.h2.server.web.JakartaWebServlet;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBooleanProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.autoconfigure.h2.H2ConsoleProperties;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.core.log.LogMessage;

@AutoConfiguration(after={DataSourceAutoConfiguration.class})
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
@ConditionalOnClass(value={JakartaWebServlet.class})
@ConditionalOnBooleanProperty(value={"spring.h2.console.enabled"})
@EnableConfigurationProperties(value={H2ConsoleProperties.class})
public class H2ConsoleAutoConfiguration {
    private static final Log logger = LogFactory.getLog(H2ConsoleAutoConfiguration.class);
    private final H2ConsoleProperties properties;

    H2ConsoleAutoConfiguration(H2ConsoleProperties properties) {
        this.properties = properties;
    }

    @Bean
    public ServletRegistrationBean<JakartaWebServlet> h2Console() {
        String path;
        String urlMapping = path + ((path = this.properties.getPath()).endsWith("/") ? "*" : "/*");
        ServletRegistrationBean<JakartaWebServlet> registration = new ServletRegistrationBean<JakartaWebServlet>(new JakartaWebServlet(), urlMapping);
        this.configureH2ConsoleSettings(registration, this.properties.getSettings());
        return registration;
    }

    @Bean
    H2ConsoleLogger h2ConsoleLogger(ObjectProvider<DataSource> dataSources) {
        return new H2ConsoleLogger(dataSources, this.properties.getPath());
    }

    private void configureH2ConsoleSettings(ServletRegistrationBean<JakartaWebServlet> registration, H2ConsoleProperties.Settings settings) {
        if (settings.isTrace()) {
            registration.addInitParameter("trace", "");
        }
        if (settings.isWebAllowOthers()) {
            registration.addInitParameter("webAllowOthers", "");
        }
        if (settings.getWebAdminPassword() != null) {
            registration.addInitParameter("webAdminPassword", settings.getWebAdminPassword());
        }
    }

    static class H2ConsoleLogger {
        H2ConsoleLogger(ObjectProvider<DataSource> dataSources, String path) {
            if (logger.isInfoEnabled()) {
                ClassLoader classLoader = this.getClass().getClassLoader();
                this.withThreadContextClassLoader(classLoader, () -> this.log(this.getConnectionUrls(dataSources), path));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void withThreadContextClassLoader(ClassLoader classLoader, Runnable action) {
            ClassLoader previous = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(classLoader);
                action.run();
            }
            finally {
                Thread.currentThread().setContextClassLoader(previous);
            }
        }

        private List<String> getConnectionUrls(ObjectProvider<DataSource> dataSources) {
            return dataSources.orderedStream(ObjectProvider.UNFILTERED).map(this::getConnectionUrl).filter(Objects::nonNull).toList();
        }

        private String getConnectionUrl(DataSource dataSource) {
            String string;
            block8: {
                Connection connection = dataSource.getConnection();
                try {
                    string = "'" + connection.getMetaData().getURL() + "'";
                    if (connection == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception ex) {
                        return null;
                    }
                }
                connection.close();
            }
            return string;
        }

        private void log(List<String> urls, String path) {
            if (!urls.isEmpty()) {
                logger.info(LogMessage.format("H2 console available at '%s'. %s available at %s", (Object)path, (Object)(urls.size() > 1 ? "Databases" : "Database"), (Object)String.join((CharSequence)", ", urls)));
            }
        }
    }
}

