/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.feature.other;

import io.micronaut.core.annotation.NonNull;
import jakarta.inject.Singleton;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.grails.forge.application.ApplicationType;
import org.grails.forge.application.generator.GeneratorContext;
import org.grails.forge.feature.DefaultFeature;
import org.grails.forge.feature.Feature;
import org.grails.forge.feature.FeaturePhase;
import org.grails.forge.feature.other.template.maindocs;
import org.grails.forge.feature.other.template.readme;
import org.grails.forge.options.Options;
import org.grails.forge.template.RockerWritable;
import org.grails.forge.template.Template;
import org.grails.forge.template.Writable;

@Singleton
public class Readme
implements DefaultFeature {
    @Override
    public boolean shouldApply(ApplicationType applicationType, Options options, Set<Feature> selectedFeatures) {
        return true;
    }

    @Override
    @NonNull
    public String getName() {
        return "readme";
    }

    @Override
    public void apply(final GeneratorContext generatorContext) {
        final List featuresWithDocumentationLinks = generatorContext.getFeatures().getFeatures().stream().filter(feature -> feature.getDocumentation() != null || feature.getThirdPartyDocumentation() != null).collect(Collectors.toList());
        List<Writable> helpTemplates = generatorContext.getHelpTemplates();
        if (!helpTemplates.isEmpty() || !featuresWithDocumentationLinks.isEmpty()) {
            generatorContext.addTemplate("readme", new Template(){

                @Override
                public String getPath() {
                    return "README.md";
                }

                @Override
                public void write(OutputStream outputStream) throws IOException {
                    RockerWritable mainDocsWritable = new RockerWritable(maindocs.template());
                    mainDocsWritable.write(outputStream);
                    for (Writable writable : generatorContext.getHelpTemplates()) {
                        writable.write(outputStream);
                    }
                    for (Feature feature : featuresWithDocumentationLinks) {
                        RockerWritable writable = new RockerWritable(readme.template(feature));
                        writable.write(outputStream);
                    }
                }
            });
        }
    }

    @Override
    public boolean supports(ApplicationType applicationType) {
        return true;
    }

    @Override
    public boolean isVisible() {
        return false;
    }

    @Override
    public int getOrder() {
        return FeaturePhase.HIGHEST.getOrder();
    }
}

