/*
 * Decompiled with CFR 0.152.
 */
package org.grails.forge.feature.config;

import jakarta.inject.Singleton;
import java.util.Map;
import java.util.function.Function;
import org.grails.forge.application.ApplicationType;
import org.grails.forge.feature.FeaturePhase;
import org.grails.forge.feature.config.Configuration;
import org.grails.forge.feature.config.ConfigurationFeature;
import org.grails.forge.template.PropertiesTemplate;
import org.grails.forge.template.Template;

@Singleton
public class Properties
implements ConfigurationFeature {
    private static final String EXTENSION = "properties";

    @Override
    public String getName() {
        return EXTENSION;
    }

    @Override
    public String getTitle() {
        return "Java Properties Configuration";
    }

    @Override
    public String getDescription() {
        return "Use Java properties for configuration instead of YAML.";
    }

    @Override
    public int getOrder() {
        return FeaturePhase.HIGHEST.getOrder();
    }

    @Override
    public Function<Configuration, Template> createTemplate() {
        return config -> new PropertiesTemplate(config.getFullPath(EXTENSION), (Map<String, Object>)config);
    }

    @Override
    public boolean supports(ApplicationType applicationType) {
        return true;
    }
}

