/*
 * Apache Fineract REST API
 * Apache Fineract is a secure, multi-tenanted microfinance platform. The goal of the Apache Fineract API is to empower developers to build apps on top of the Apache Fineract Platform. The [reference app](https://cui.fineract.dev) (username: mifos, password: password) works on the same demo tenant as the interactive links in this documentation. Until we complete the new REST API documentation you still have the legacy documentation available [here](https://fineract.apache.org/docs/legacy/). Please check [the current Fineract documentation](https://fineract.apache.org/docs/current/) for more information.
 *
 * The version of the OpenAPI document: 1.14.0
 * Contact: dev@fineract.apache.org
 *
 * NOTE: This class is auto generated by OpenAPI Generator (https://openapi-generator.tech).
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */


package org.apache.fineract.client.models;

import java.util.Objects;
import java.util.Arrays;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.fineract.client.models.Header;

/**
 * BatchRequest
 */
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaClientCodegen", comments = "Generator version: 7.8.0")
public class BatchRequest {
  public static final String SERIALIZED_NAME_BODY = "body";
  @SerializedName(SERIALIZED_NAME_BODY)
  private String body;

  public static final String SERIALIZED_NAME_HEADERS = "headers";
  @SerializedName(SERIALIZED_NAME_HEADERS)
  private Set<Header> headers;

  public static final String SERIALIZED_NAME_METHOD = "method";
  @SerializedName(SERIALIZED_NAME_METHOD)
  private String method;

  public static final String SERIALIZED_NAME_REFERENCE = "reference";
  @SerializedName(SERIALIZED_NAME_REFERENCE)
  private Long reference;

  public static final String SERIALIZED_NAME_RELATIVE_URL = "relativeUrl";
  @SerializedName(SERIALIZED_NAME_RELATIVE_URL)
  private String relativeUrl;

  public static final String SERIALIZED_NAME_REQUEST_ID = "requestId";
  @SerializedName(SERIALIZED_NAME_REQUEST_ID)
  private Long requestId;

  public BatchRequest() {
  }

  public BatchRequest body(String body) {
    
    this.body = body;
    return this;
  }

  /**
   * Get body
   * @return body
   */
  @javax.annotation.Nullable

  public String getBody() {
    return body;
  }


  public void setBody(String body) {
    this.body = body;
  }

  public BatchRequest headers(Set<Header> headers) {
    
    this.headers = headers;
    return this;
  }

  public BatchRequest addHeadersItem(Header headersItem) {
    if (this.headers == null) {
      this.headers = new LinkedHashSet<>();
    }
    this.headers.add(headersItem);
    return this;
  }

  /**
   * Get headers
   * @return headers
   */
  @javax.annotation.Nullable

  public Set<Header> getHeaders() {
    return headers;
  }


  public void setHeaders(Set<Header> headers) {
    this.headers = headers;
  }

  public BatchRequest method(String method) {
    
    this.method = method;
    return this;
  }

  /**
   * Get method
   * @return method
   */
  @javax.annotation.Nullable

  public String getMethod() {
    return method;
  }


  public void setMethod(String method) {
    this.method = method;
  }

  public BatchRequest reference(Long reference) {
    
    this.reference = reference;
    return this;
  }

  /**
   * Get reference
   * @return reference
   */
  @javax.annotation.Nullable

  public Long getReference() {
    return reference;
  }


  public void setReference(Long reference) {
    this.reference = reference;
  }

  public BatchRequest relativeUrl(String relativeUrl) {
    
    this.relativeUrl = relativeUrl;
    return this;
  }

  /**
   * Get relativeUrl
   * @return relativeUrl
   */
  @javax.annotation.Nullable

  public String getRelativeUrl() {
    return relativeUrl;
  }


  public void setRelativeUrl(String relativeUrl) {
    this.relativeUrl = relativeUrl;
  }

  public BatchRequest requestId(Long requestId) {
    
    this.requestId = requestId;
    return this;
  }

  /**
   * Get requestId
   * @return requestId
   */
  @javax.annotation.Nullable

  public Long getRequestId() {
    return requestId;
  }


  public void setRequestId(Long requestId) {
    this.requestId = requestId;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    BatchRequest batchRequest = (BatchRequest) o;
    return Objects.equals(this.body, batchRequest.body) &&
        Objects.equals(this.headers, batchRequest.headers) &&
        Objects.equals(this.method, batchRequest.method) &&
        Objects.equals(this.reference, batchRequest.reference) &&
        Objects.equals(this.relativeUrl, batchRequest.relativeUrl) &&
        Objects.equals(this.requestId, batchRequest.requestId);
  }

  @Override
  public int hashCode() {
    return Objects.hash(body, headers, method, reference, relativeUrl, requestId);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class BatchRequest {\n");
    sb.append("    body: ").append(toIndentedString(body)).append("\n");
    sb.append("    headers: ").append(toIndentedString(headers)).append("\n");
    sb.append("    method: ").append(toIndentedString(method)).append("\n");
    sb.append("    reference: ").append(toIndentedString(reference)).append("\n");
    sb.append("    relativeUrl: ").append(toIndentedString(relativeUrl)).append("\n");
    sb.append("    requestId: ").append(toIndentedString(requestId)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }

}

