/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.useradministration.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriInfo;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.api.ApiRequestParameterHelper;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.serialization.ApiRequestJsonSerializationSettings;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.useradministration.api.RolesApiResourceSwagger;
import org.apache.fineract.useradministration.data.RoleData;
import org.apache.fineract.useradministration.data.RolePermissionsData;
import org.apache.fineract.useradministration.service.PermissionReadPlatformService;
import org.apache.fineract.useradministration.service.RoleReadPlatformService;
import org.springframework.stereotype.Component;

@Path(value="/v1/roles")
@Component
@Tag(name="Roles", description="An API capability to support management of application roles for user administration.")
public class RolesApiResource {
    public static final String ID = "id";
    public static final String NAME = "name";
    public static final String DESCRIPTION = "description";
    public static final String AVAILABLE_PERMISSIONS = "availablePermissions";
    public static final String SELECTED_PERMISSIONS = "selectedPermissions";
    public static final String PERMISSION_USAGE_DATA = "permissionUsageData";
    public static final String DISABLE = "disable";
    public static final String ENABLE = "enable";
    private static final Set<String> RESPONSE_DATA_PARAMETERS = new HashSet<String>(Arrays.asList("id", "name", "description", "availablePermissions", "selectedPermissions"));
    private static final Set<String> PERMISSIONS_RESPONSE_PARAMETERS = new HashSet<String>(Arrays.asList("id", "name", "description", "permissionUsageData"));
    private static final String RESOURCE_NAME_FOR_PERMISSIONS = "ROLE";
    private final PlatformSecurityContext context;
    private final RoleReadPlatformService roleReadPlatformService;
    private final PermissionReadPlatformService permissionReadPlatformService;
    private final DefaultToApiJsonSerializer<RoleData> toApiJsonSerializer;
    private final DefaultToApiJsonSerializer<RolePermissionsData> permissionsToApiJsonSerializer;
    private final ApiRequestParameterHelper apiRequestParameterHelper;
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;

    @GET
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="List Roles", description="Example Requests:\n\nroles\n\n\nroles?fields=name")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(array=@ArraySchema(schema=@Schema(implementation=RolesApiResourceSwagger.GetRolesResponse.class)))})})
    public String retrieveAllRoles(@Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        Collection roles = this.roleReadPlatformService.retrieveAll();
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        return this.toApiJsonSerializer.serialize(settings, roles, RESPONSE_DATA_PARAMETERS);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Create a New Role", description="Mandatory Fields\nname, description")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=RolesApiResourceSwagger.PostRolesRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=RolesApiResourceSwagger.PostRolesResponse.class))})})
    public String createRole(@Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().createRole().withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @GET
    @Path(value="{roleId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a Role", description="Example Requests:\n\nroles/1\n\n\nroles/1?fields=name")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=RolesApiResourceSwagger.GetRolesRoleIdResponse.class))})})
    public String retrieveRole(@PathParam(value="roleId") @Parameter(description="roleId") Long roleId, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        RoleData role = this.roleReadPlatformService.retrieveOne(roleId);
        return this.toApiJsonSerializer.serialize(settings, (Object)role, RESPONSE_DATA_PARAMETERS);
    }

    @POST
    @Path(value="{roleId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Enable Role | Disable Role", description="Description : Enable role in case role is disabled. | Disable the role in case role is not associated with any users.\n\n\n\n\n\nExample Request:   https://DomainName/api/v1/roles/{roleId}?command=enable\n\n\n\n\n\nhttps://DomainName/api/v1/roles/{roleId}?command=disable")
    @Parameters(value={@Parameter(description="No Request Body", name="No Request Body")})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=RolesApiResourceSwagger.PostRolesRoleIdResponse.class))})})
    public String actionsOnRoles(@PathParam(value="roleId") @Parameter(description="roleId") Long roleId, @QueryParam(value="command") @Parameter(description="command") String commandParam, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapperBuilder builder = new CommandWrapperBuilder().withJson(apiRequestBodyAsJson);
        CommandProcessingResult result = null;
        if (this.is(commandParam, DISABLE)) {
            CommandWrapper commandRequest = builder.disableRole(roleId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        } else if (this.is(commandParam, ENABLE)) {
            CommandWrapper commandRequest = builder.enableRole(roleId).build();
            result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        }
        return this.toApiJsonSerializer.serialize(result);
    }

    @PUT
    @Path(value="{roleId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update a Role", description="")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=RolesApiResourceSwagger.PutRolesRoleIdRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=RolesApiResourceSwagger.PutRolesRoleIdResponse.class))})})
    public String updateRole(@PathParam(value="roleId") @Parameter(description="roleId") Long roleId, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateRole(roleId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @GET
    @Path(value="{roleId}/permissions")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Retrieve a Role's Permissions", description="Example Requests:\n\nroles/1/permissions")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=RolesApiResourceSwagger.GetRolesRoleIdPermissionsResponse.class))})})
    public String retrieveRolePermissions(@PathParam(value="roleId") @Parameter(description="roleId") Long roleId, @Context UriInfo uriInfo) {
        this.context.authenticatedUser().validateHasReadPermission(RESOURCE_NAME_FOR_PERMISSIONS);
        ApiRequestJsonSerializationSettings settings = this.apiRequestParameterHelper.process(uriInfo.getQueryParameters());
        RoleData role = this.roleReadPlatformService.retrieveOne(roleId);
        Collection permissionUsageData = this.permissionReadPlatformService.retrieveAllRolePermissions(roleId);
        RolePermissionsData permissionsData = role.toRolePermissionData(permissionUsageData);
        return this.permissionsToApiJsonSerializer.serialize(settings, (Object)permissionsData, PERMISSIONS_RESPONSE_PARAMETERS);
    }

    @PUT
    @Path(value="{roleId}/permissions")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Update a Role's Permissions", description="")
    @RequestBody(required=true, content={@Content(schema=@Schema(implementation=RolesApiResourceSwagger.PutRolesRoleIdPermissionsRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=RolesApiResourceSwagger.PutRolesRoleIdPermissionsResponse.class))})})
    public String updateRolePermissions(@PathParam(value="roleId") @Parameter(description="roleId") Long roleId, @Parameter(hidden=true) String apiRequestBodyAsJson) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().updateRolePermissions(roleId).withJson(apiRequestBodyAsJson).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    @DELETE
    @Path(value="{roleId}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Delete a Role", description="Description : Delete the role in case role is not associated with any users.")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=RolesApiResourceSwagger.DeleteRolesRoleIdResponse.class))})})
    public String deleteRole(@PathParam(value="roleId") @Parameter(description="roleId") Long roleId) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().deleteRole(roleId).build();
        CommandProcessingResult result = this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
        return this.toApiJsonSerializer.serialize((Object)result);
    }

    private boolean is(String commandParam, String commandValue) {
        return StringUtils.isNotBlank((CharSequence)commandParam) && commandParam.trim().equalsIgnoreCase(commandValue);
    }

    @Generated
    public RolesApiResource(PlatformSecurityContext context, RoleReadPlatformService roleReadPlatformService, PermissionReadPlatformService permissionReadPlatformService, DefaultToApiJsonSerializer<RoleData> toApiJsonSerializer, DefaultToApiJsonSerializer<RolePermissionsData> permissionsToApiJsonSerializer, ApiRequestParameterHelper apiRequestParameterHelper, PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService) {
        this.context = context;
        this.roleReadPlatformService = roleReadPlatformService;
        this.permissionReadPlatformService = permissionReadPlatformService;
        this.toApiJsonSerializer = toApiJsonSerializer;
        this.permissionsToApiJsonSerializer = permissionsToApiJsonSerializer;
        this.apiRequestParameterHelper = apiRequestParameterHelper;
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
    }
}

