/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.tax.service;

import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.portfolio.tax.domain.TaxComponent;
import org.apache.fineract.portfolio.tax.domain.TaxComponentRepository;
import org.apache.fineract.portfolio.tax.domain.TaxComponentRepositoryWrapper;
import org.apache.fineract.portfolio.tax.domain.TaxGroup;
import org.apache.fineract.portfolio.tax.domain.TaxGroupRepository;
import org.apache.fineract.portfolio.tax.domain.TaxGroupRepositoryWrapper;
import org.apache.fineract.portfolio.tax.serialization.TaxValidator;
import org.apache.fineract.portfolio.tax.service.TaxAssembler;
import org.apache.fineract.portfolio.tax.service.TaxWritePlatformService;

public class TaxWritePlatformServiceImpl
implements TaxWritePlatformService {
    private final TaxValidator validator;
    private final TaxAssembler taxAssembler;
    private final TaxComponentRepository taxComponentRepository;
    private final TaxComponentRepositoryWrapper taxComponentRepositoryWrapper;
    private final TaxGroupRepository taxGroupRepository;
    private final TaxGroupRepositoryWrapper taxGroupRepositoryWrapper;

    public CommandProcessingResult createTaxComponent(JsonCommand command) {
        this.validator.validateForTaxComponentCreate(command.json());
        TaxComponent taxComponent = this.taxAssembler.assembleTaxComponentFrom(command);
        this.taxComponentRepository.saveAndFlush((Object)taxComponent);
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)taxComponent.getId()).build();
    }

    public CommandProcessingResult updateTaxComponent(Long id, JsonCommand command) {
        this.validator.validateForTaxComponentUpdate(command.json());
        TaxComponent taxComponent = this.taxComponentRepositoryWrapper.findOneWithNotFoundDetection(id);
        this.validator.validateStartDate(taxComponent.startDate(), command);
        Map changes = taxComponent.update(command);
        this.validator.validateTaxComponentForUpdate(taxComponent);
        this.taxComponentRepository.saveAndFlush((Object)taxComponent);
        return new CommandProcessingResultBuilder().withEntityId(id).with(changes).build();
    }

    public CommandProcessingResult createTaxGroup(JsonCommand command) {
        this.validator.validateForTaxGroupCreate(command.json());
        TaxGroup taxGroup = this.taxAssembler.assembleTaxGroupFrom(command);
        this.validator.validateTaxGroup(taxGroup);
        this.taxGroupRepository.saveAndFlush((Object)taxGroup);
        return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)taxGroup.getId()).build();
    }

    public CommandProcessingResult updateTaxGroup(Long id, JsonCommand command) {
        this.validator.validateForTaxGroupUpdate(command.json());
        TaxGroup taxGroup = this.taxGroupRepositoryWrapper.findOneWithNotFoundDetection(id);
        boolean isUpdate = true;
        Set groupMappings = this.taxAssembler.assembleTaxGroupMappingsFrom(command, true);
        this.validator.validateTaxGroupEndDateAndTaxComponent(taxGroup, groupMappings);
        Map changes = taxGroup.update(command, groupMappings);
        this.validator.validateTaxGroup(taxGroup);
        this.taxGroupRepository.saveAndFlush((Object)taxGroup);
        return new CommandProcessingResultBuilder().withEntityId(id).with(changes).build();
    }

    @Generated
    public TaxWritePlatformServiceImpl(TaxValidator validator, TaxAssembler taxAssembler, TaxComponentRepository taxComponentRepository, TaxComponentRepositoryWrapper taxComponentRepositoryWrapper, TaxGroupRepository taxGroupRepository, TaxGroupRepositoryWrapper taxGroupRepositoryWrapper) {
        this.validator = validator;
        this.taxAssembler = taxAssembler;
        this.taxComponentRepository = taxComponentRepository;
        this.taxComponentRepositoryWrapper = taxComponentRepositoryWrapper;
        this.taxGroupRepository = taxGroupRepository;
        this.taxGroupRepositoryWrapper = taxGroupRepositoryWrapper;
    }
}

