/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.loanaccount.guarantor.service;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.fineract.infrastructure.codes.domain.CodeValue;
import org.apache.fineract.infrastructure.codes.domain.CodeValueRepositoryWrapper;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.core.exception.GeneralPlatformDomainRuleException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.organisation.staff.domain.StaffRepositoryWrapper;
import org.apache.fineract.portfolio.account.domain.AccountAssociationType;
import org.apache.fineract.portfolio.account.domain.AccountAssociations;
import org.apache.fineract.portfolio.account.domain.AccountAssociationsRepository;
import org.apache.fineract.portfolio.client.domain.ClientRepositoryWrapper;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanRepositoryWrapper;
import org.apache.fineract.portfolio.loanaccount.guarantor.GuarantorConstants;
import org.apache.fineract.portfolio.loanaccount.guarantor.command.GuarantorCommand;
import org.apache.fineract.portfolio.loanaccount.guarantor.domain.Guarantor;
import org.apache.fineract.portfolio.loanaccount.guarantor.domain.GuarantorFundStatusType;
import org.apache.fineract.portfolio.loanaccount.guarantor.domain.GuarantorFundingDetails;
import org.apache.fineract.portfolio.loanaccount.guarantor.domain.GuarantorRepository;
import org.apache.fineract.portfolio.loanaccount.guarantor.domain.GuarantorType;
import org.apache.fineract.portfolio.loanaccount.guarantor.exception.DuplicateGuarantorException;
import org.apache.fineract.portfolio.loanaccount.guarantor.exception.GuarantorNotFoundException;
import org.apache.fineract.portfolio.loanaccount.guarantor.exception.InvalidGuarantorException;
import org.apache.fineract.portfolio.loanaccount.guarantor.serialization.GuarantorCommandFromApiJsonDeserializer;
import org.apache.fineract.portfolio.loanaccount.guarantor.service.GuarantorDomainService;
import org.apache.fineract.portfolio.loanaccount.guarantor.service.GuarantorWritePlatformService;
import org.apache.fineract.portfolio.savings.domain.SavingsAccount;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountAssembler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.dao.NonTransientDataAccessException;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class GuarantorWritePlatformServiceJpaRepositoryIImpl
implements GuarantorWritePlatformService {
    private static final Logger LOG = LoggerFactory.getLogger(GuarantorWritePlatformServiceJpaRepositoryIImpl.class);
    private final ClientRepositoryWrapper clientRepositoryWrapper;
    private final StaffRepositoryWrapper staffRepositoryWrapper;
    private final LoanRepositoryWrapper loanRepositoryWrapper;
    private final GuarantorRepository guarantorRepository;
    private final GuarantorCommandFromApiJsonDeserializer fromApiJsonDeserializer;
    private final CodeValueRepositoryWrapper codeValueRepositoryWrapper;
    private final SavingsAccountAssembler savingsAccountAssembler;
    private final AccountAssociationsRepository accountAssociationsRepository;
    private final GuarantorDomainService guarantorDomainService;

    @Autowired
    public GuarantorWritePlatformServiceJpaRepositoryIImpl(LoanRepositoryWrapper loanRepositoryWrapper, GuarantorRepository guarantorRepository, ClientRepositoryWrapper clientRepositoryWrapper, StaffRepositoryWrapper staffRepositoryWrapper, GuarantorCommandFromApiJsonDeserializer fromApiJsonDeserializer, CodeValueRepositoryWrapper codeValueRepositoryWrapper, SavingsAccountAssembler savingsAccountAssembler, AccountAssociationsRepository accountAssociationsRepository, GuarantorDomainService guarantorDomainService) {
        this.loanRepositoryWrapper = loanRepositoryWrapper;
        this.clientRepositoryWrapper = clientRepositoryWrapper;
        this.fromApiJsonDeserializer = fromApiJsonDeserializer;
        this.guarantorRepository = guarantorRepository;
        this.staffRepositoryWrapper = staffRepositoryWrapper;
        this.codeValueRepositoryWrapper = codeValueRepositoryWrapper;
        this.savingsAccountAssembler = savingsAccountAssembler;
        this.accountAssociationsRepository = accountAssociationsRepository;
        this.guarantorDomainService = guarantorDomainService;
    }

    @Transactional
    public CommandProcessingResult createGuarantor(Long loanId, JsonCommand command) {
        GuarantorCommand guarantorCommand = this.fromApiJsonDeserializer.commandFromApiJson(command.json());
        Loan loan = this.loanRepositoryWrapper.findOneWithNotFoundDetection(loanId, true);
        List existGuarantorList = this.guarantorRepository.findByLoan(loan);
        return this.createGuarantor(loan, command, guarantorCommand, (Collection)existGuarantorList);
    }

    private CommandProcessingResult createGuarantor(Loan loan, JsonCommand command, GuarantorCommand guarantorCommand, Collection<Guarantor> existGuarantorList) {
        try {
            guarantorCommand.validateForCreate();
            this.validateLoanStatus(loan);
            ArrayList<GuarantorFundingDetails> guarantorFundingDetails = new ArrayList<GuarantorFundingDetails>();
            boolean backdatedTxnsAllowedTill = false;
            AccountAssociations accountAssociations = null;
            if (guarantorCommand.getSavingsId() != null) {
                SavingsAccount savingsAccount = this.savingsAccountAssembler.assembleFrom(guarantorCommand.getSavingsId(), false);
                this.validateGuarantorSavingsAccountActivationDateWithLoanSubmittedOnDate(loan, savingsAccount);
                accountAssociations = AccountAssociations.associateSavingsAccount((Loan)loan, (SavingsAccount)savingsAccount, (Integer)AccountAssociationType.GUARANTOR_ACCOUNT_ASSOCIATION.getValue(), (boolean)false);
                GuarantorFundingDetails fundingDetails = new GuarantorFundingDetails(accountAssociations, GuarantorFundStatusType.ACTIVE.getValue(), guarantorCommand.getAmount());
                guarantorFundingDetails.add(fundingDetails);
                if (loan.isDisbursed() || loan.isApproved() && (loan.getGuaranteeAmount() != null || loan.loanProduct().isHoldGuaranteeFunds())) {
                    this.guarantorDomainService.assignGuarantor(fundingDetails, DateUtils.getBusinessLocalDate());
                    loan.updateGuaranteeAmount(fundingDetails.getAmount());
                }
            }
            Long clientRelationshipId = guarantorCommand.getClientRelationshipTypeId();
            CodeValue clientRelationshipType = null;
            if (clientRelationshipId != null) {
                clientRelationshipType = this.codeValueRepositoryWrapper.findOneByCodeNameAndIdWithNotFoundDetection("GuarantorRelationship", clientRelationshipId);
            }
            Long entityId = guarantorCommand.getEntityId();
            Integer guarantorTypeId = guarantorCommand.getGuarantorTypeId();
            Guarantor guarantor = null;
            for (Guarantor avilableGuarantor : existGuarantorList) {
                if (entityId == null || avilableGuarantor.getEntityId() == null || !avilableGuarantor.getEntityId().equals(entityId) || !avilableGuarantor.getGurantorType().equals(guarantorTypeId) || !avilableGuarantor.isActive()) continue;
                if (guarantorCommand.getSavingsId() == null || avilableGuarantor.hasGuarantor(guarantorCommand.getSavingsId())) {
                    Object defaultUserMessage = null;
                    defaultUserMessage = guarantorTypeId.equals(GuarantorType.STAFF.getValue()) ? this.staffRepositoryWrapper.findOneWithNotFoundDetection(entityId).displayName() : this.clientRepositoryWrapper.findOneWithNotFoundDetection(entityId).getDisplayName();
                    defaultUserMessage = (String)defaultUserMessage + " is already exist as a guarantor for this loan";
                    String action = loan.client() != null ? "client.guarantor" : "group.guarantor";
                    throw new DuplicateGuarantorException(action, "is.already.exist.same.loan", (String)defaultUserMessage, new Object[]{entityId, loan.getId()});
                }
                guarantor = avilableGuarantor;
                break;
            }
            if (guarantor == null) {
                guarantor = Guarantor.fromJson((Loan)loan, (CodeValue)clientRelationshipType, (JsonCommand)command, guarantorFundingDetails);
            } else {
                guarantor.addFundingDetails(guarantorFundingDetails);
            }
            this.validateGuarantorBusinessRules(guarantor);
            for (GuarantorFundingDetails fundingDetails : guarantorFundingDetails) {
                fundingDetails.updateGuarantor(guarantor);
            }
            if (accountAssociations != null) {
                this.accountAssociationsRepository.saveAndFlush((Object)accountAssociations);
            }
            this.guarantorRepository.saveAndFlush((Object)guarantor);
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withOfficeId(guarantor.getOfficeId()).withEntityId((Long)guarantor.getId()).withLoanId((Long)loan.getId()).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            Throwable throwable = dve.getMostSpecificCause();
            this.handleGuarantorDataIntegrityIssues(throwable, (NonTransientDataAccessException)dve);
            return CommandProcessingResult.empty();
        }
    }

    private void validateGuarantorSavingsAccountActivationDateWithLoanSubmittedOnDate(Loan loan, SavingsAccount savingsAccount) {
        if (DateUtils.isBefore((LocalDate)loan.getSubmittedOnDate(), (LocalDate)savingsAccount.getActivationDate())) {
            throw new GeneralPlatformDomainRuleException("error.msg.guarantor.saving.account.activation.date.is.on.or.before.loan.submitted.on.date", "Guarantor saving account activation date [" + String.valueOf(savingsAccount.getActivationDate()) + "] is on or before the loan submitted on date [" + String.valueOf(loan.getSubmittedOnDate()) + "]", new Object[]{savingsAccount.getActivationDate(), loan.getSubmittedOnDate()});
        }
    }

    @Transactional
    public CommandProcessingResult updateGuarantor(Long loanId, Long guarantorId, JsonCommand command) {
        try {
            GuarantorCommand guarantorCommand = this.fromApiJsonDeserializer.commandFromApiJson(command.json());
            guarantorCommand.validateForUpdate();
            Loan loan = this.loanRepositoryWrapper.findOneWithNotFoundDetection(loanId, true);
            this.validateLoanStatus(loan);
            Guarantor guarantorForUpdate = this.guarantorRepository.findByLoanAndId(loan, guarantorId);
            if (guarantorForUpdate == null) {
                throw new GuarantorNotFoundException(loanId, guarantorId);
            }
            Map changesOnly = guarantorForUpdate.update(command);
            if (changesOnly.containsKey(GuarantorConstants.GuarantorJSONinputParams.CLIENT_RELATIONSHIP_TYPE_ID.getValue())) {
                Long clientRelationshipId = guarantorCommand.getClientRelationshipTypeId();
                CodeValue clientRelationshipType = null;
                if (clientRelationshipId != null) {
                    clientRelationshipType = this.codeValueRepositoryWrapper.findOneByCodeNameAndIdWithNotFoundDetection("GuarantorRelationship", clientRelationshipId);
                }
                guarantorForUpdate.updateClientRelationshipType(clientRelationshipType);
            }
            List existGuarantorList = this.guarantorRepository.findByLoan(loan);
            Integer guarantorTypeId = guarantorCommand.getGuarantorTypeId();
            GuarantorType guarantorType = GuarantorType.fromInt((int)guarantorTypeId);
            if (guarantorType.isCustomer() || guarantorType.isStaff()) {
                Long entityId = guarantorCommand.getEntityId();
                for (Guarantor guarantor : existGuarantorList) {
                    if (!guarantor.getEntityId().equals(entityId) || !guarantor.getGurantorType().equals(guarantorTypeId) || ((Long)guarantorForUpdate.getId()).equals(guarantor.getId())) continue;
                    Object defaultUserMessage = this.clientRepositoryWrapper.findOneWithNotFoundDetection(entityId).getDisplayName();
                    defaultUserMessage = (String)defaultUserMessage + " is already exist as a guarantor for this loan";
                    String action = loan.client() != null ? "client.guarantor" : "group.guarantor";
                    throw new DuplicateGuarantorException(action, "is.already.exist.same.loan", (String)defaultUserMessage, new Object[]{entityId, loanId});
                }
            }
            if (changesOnly.containsKey(GuarantorConstants.GuarantorJSONinputParams.ENTITY_ID.getValue()) || changesOnly.containsKey(GuarantorConstants.GuarantorJSONinputParams.GUARANTOR_TYPE_ID.getValue())) {
                this.validateGuarantorBusinessRules(guarantorForUpdate);
            }
            if (!changesOnly.isEmpty()) {
                this.guarantorRepository.saveAndFlush((Object)guarantorForUpdate);
            }
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withOfficeId(guarantorForUpdate.getOfficeId()).withEntityId((Long)guarantorForUpdate.getId()).withOfficeId(guarantorForUpdate.getLoanId()).with(changesOnly).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            Throwable throwable = dve.getMostSpecificCause();
            this.handleGuarantorDataIntegrityIssues(throwable, (NonTransientDataAccessException)dve);
            return CommandProcessingResult.empty();
        }
    }

    @Transactional
    public CommandProcessingResult removeGuarantor(Long loanId, Long guarantorId, Long guarantorFundingId) {
        Loan loan = this.loanRepositoryWrapper.findOneWithNotFoundDetection(loanId, true);
        this.validateLoanStatus(loan);
        Guarantor guarantorForDelete = this.guarantorRepository.findByLoanAndId(loan, guarantorId);
        if (guarantorForDelete == null || guarantorFundingId == null && !guarantorForDelete.getGuarantorFundDetails().isEmpty()) {
            throw new GuarantorNotFoundException(loanId, guarantorId, guarantorFundingId);
        }
        CommandProcessingResult commandProcessingResult = this.removeGuarantor(guarantorForDelete, loanId, guarantorFundingId);
        if (loan.isApproved() || loan.isDisbursed()) {
            this.guarantorDomainService.validateGuarantorBusinessRules(loan);
        }
        return commandProcessingResult;
    }

    private CommandProcessingResult removeGuarantor(Guarantor guarantorForDelete, Long loanId, Long guarantorFundingId) {
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("Guarantor");
        if (guarantorFundingId == null) {
            if (!guarantorForDelete.isActive()) {
                baseDataValidator.failWithCodeNoParameterAddedToErrorCode("not.active", new Object[0]);
            }
            guarantorForDelete.updateStatus(false);
        } else {
            GuarantorFundingDetails guarantorFundingDetails = guarantorForDelete.getGuarantorFundingDetail(guarantorFundingId);
            if (guarantorFundingDetails == null) {
                throw new GuarantorNotFoundException(loanId, (Long)guarantorForDelete.getId(), guarantorFundingId);
            }
            this.removeguarantorFundDetails(guarantorForDelete, baseDataValidator, guarantorFundingDetails);
        }
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException("validation.msg.validation.errors.exist", "Validation errors exist.", dataValidationErrors);
        }
        this.guarantorRepository.saveAndFlush((Object)guarantorForDelete);
        CommandProcessingResultBuilder commandProcessingResultBuilder = new CommandProcessingResultBuilder().withEntityId((Long)guarantorForDelete.getId()).withLoanId(guarantorForDelete.getLoanId()).withOfficeId(guarantorForDelete.getOfficeId());
        if (guarantorFundingId != null) {
            commandProcessingResultBuilder.withSubEntityId(guarantorFundingId);
        }
        return commandProcessingResultBuilder.build();
    }

    private void removeguarantorFundDetails(Guarantor guarantorForDelete, DataValidatorBuilder baseDataValidator, GuarantorFundingDetails guarantorFundingDetails) {
        if (!guarantorFundingDetails.getStatus().isActive()) {
            baseDataValidator.failWithCodeNoParameterAddedToErrorCode("not.active", new Object[0]);
        }
        GuarantorFundStatusType fundStatusType = GuarantorFundStatusType.DELETED;
        if (guarantorForDelete.getLoan().isDisbursed() || guarantorForDelete.getLoan().isApproved()) {
            fundStatusType = GuarantorFundStatusType.WITHDRAWN;
            this.guarantorDomainService.releaseGuarantor(guarantorFundingDetails, DateUtils.getBusinessLocalDate());
        }
        guarantorForDelete.updateStatus(guarantorFundingDetails, fundStatusType);
    }

    private void validateGuarantorBusinessRules(Guarantor guarantor) {
        if (guarantor.isExistingCustomer()) {
            this.clientRepositoryWrapper.findOneWithNotFoundDetection(guarantor.getEntityId());
            if (guarantor.getClientId() != null && guarantor.getClientId().equals(guarantor.getEntityId())) {
                String errorCode = null;
                if (guarantor.getGuarantorFundDetails().isEmpty()) {
                    errorCode = "guarantor.can.not.be.own";
                } else if (guarantor.getClientRelationshipType() != null) {
                    errorCode = "guarantor.relation.should.be.empty.for.own";
                }
                if (errorCode != null) {
                    throw new InvalidGuarantorException(guarantor.getEntityId(), guarantor.getLoanId(), errorCode);
                }
            }
        } else if (guarantor.isExistingEmployee()) {
            this.staffRepositoryWrapper.findOneWithNotFoundDetection(guarantor.getEntityId());
        }
    }

    private void validateLoanStatus(Loan loan) {
        if (!loan.getStatus().isActiveOrAwaitingApprovalOrDisbursal()) {
            ArrayList dataValidationErrors = new ArrayList();
            DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("loan.guarantor");
            baseDataValidator.reset().failWithCodeNoParameterAddedToErrorCode("loan.is.closed", new Object[0]);
            throw new PlatformApiDataValidationException("validation.msg.validation.errors.exist", "Validation errors exist.", dataValidationErrors);
        }
    }

    private void handleGuarantorDataIntegrityIssues(Throwable realCause, NonTransientDataAccessException dve) {
        LOG.error("Error occured.", (Throwable)dve);
        throw ErrorHandler.getMappable((Throwable)dve, (String)"error.msg.guarantor.unknown.data.integrity.issue", (String)("Unknown data integrity issue with resource Guarantor: " + realCause.getMessage()));
    }
}

