/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.portfolio.collateral.service;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.math.BigDecimal;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.infrastructure.codes.domain.CodeValue;
import org.apache.fineract.infrastructure.codes.domain.CodeValueRepositoryWrapper;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.portfolio.collateral.domain.LoanCollateral;
import org.apache.fineract.portfolio.collateral.domain.LoanCollateralRepository;
import org.apache.fineract.portfolio.collateral.exception.CollateralNotFoundException;

public class CollateralAssembler {
    private final FromJsonHelper fromApiJsonHelper;
    private final CodeValueRepositoryWrapper codeValueRepository;
    private final LoanCollateralRepository loanCollateralRepository;

    public Set<LoanCollateral> fromParsedJson(JsonElement element) {
        JsonObject topLevelJsonElement;
        HashSet<LoanCollateral> collateralItems = new HashSet<LoanCollateral>();
        if (element.isJsonObject() && (topLevelJsonElement = element.getAsJsonObject()).has("collateral") && topLevelJsonElement.get("collateral").isJsonArray()) {
            JsonArray array = topLevelJsonElement.get("collateral").getAsJsonArray();
            Locale locale = this.fromApiJsonHelper.extractLocaleParameter(topLevelJsonElement);
            for (int i = 0; i < array.size(); ++i) {
                JsonObject collateralItemElement = array.get(i).getAsJsonObject();
                Long id = this.fromApiJsonHelper.extractLongNamed("id", (JsonElement)collateralItemElement);
                Long collateralTypeId = this.fromApiJsonHelper.extractLongNamed("type", (JsonElement)collateralItemElement);
                CodeValue collateralType = this.codeValueRepository.findOneWithNotFoundDetection(collateralTypeId);
                String description = this.fromApiJsonHelper.extractStringNamed("description", (JsonElement)collateralItemElement);
                BigDecimal value = this.fromApiJsonHelper.extractBigDecimalNamed("value", (JsonElement)collateralItemElement, locale);
                if (id == null) {
                    collateralItems.add(LoanCollateral.from((CodeValue)collateralType, (BigDecimal)value, (String)description));
                    continue;
                }
                LoanCollateral loanCollateralItem = (LoanCollateral)this.loanCollateralRepository.findById((Object)id).orElseThrow(() -> new CollateralNotFoundException(id));
                loanCollateralItem.assembleFrom(collateralType, value, description);
                collateralItems.add(loanCollateralItem);
            }
        }
        return collateralItems;
    }

    @Generated
    public CollateralAssembler(FromJsonHelper fromApiJsonHelper, CodeValueRepositoryWrapper codeValueRepository, LoanCollateralRepository loanCollateralRepository) {
        this.fromApiJsonHelper = fromApiJsonHelper;
        this.codeValueRepository = codeValueRepository;
        this.loanCollateralRepository = loanCollateralRepository;
    }
}

