/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.organisation.holiday.service;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import jakarta.persistence.PersistenceException;
import java.time.LocalDate;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResultBuilder;
import org.apache.fineract.infrastructure.core.exception.ErrorHandler;
import org.apache.fineract.infrastructure.core.exception.PlatformDataIntegrityException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.apache.fineract.organisation.holiday.data.HolidayDataValidator;
import org.apache.fineract.organisation.holiday.domain.Holiday;
import org.apache.fineract.organisation.holiday.domain.HolidayRepositoryWrapper;
import org.apache.fineract.organisation.holiday.exception.HolidayDateException;
import org.apache.fineract.organisation.holiday.service.HolidayWritePlatformService;
import org.apache.fineract.organisation.office.domain.Office;
import org.apache.fineract.organisation.office.domain.OfficeRepositoryWrapper;
import org.apache.fineract.organisation.workingdays.domain.WorkingDays;
import org.apache.fineract.organisation.workingdays.domain.WorkingDaysRepositoryWrapper;
import org.apache.fineract.organisation.workingdays.service.WorkingDaysUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.orm.jpa.JpaSystemException;
import org.springframework.transaction.annotation.Transactional;

public class HolidayWritePlatformServiceJpaRepositoryImpl
implements HolidayWritePlatformService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HolidayWritePlatformServiceJpaRepositoryImpl.class);
    private final HolidayDataValidator fromApiJsonDeserializer;
    private final HolidayRepositoryWrapper holidayRepository;
    private final WorkingDaysRepositoryWrapper daysRepositoryWrapper;
    private final PlatformSecurityContext context;
    private final OfficeRepositoryWrapper officeRepositoryWrapper;
    private final FromJsonHelper fromApiJsonHelper;

    @Transactional
    public CommandProcessingResult createHoliday(JsonCommand command) {
        try {
            this.context.authenticatedUser();
            this.fromApiJsonDeserializer.validateForCreate(command.json());
            this.validateInputDates(command);
            Set offices = this.getSelectedOffices(command);
            Holiday holiday = Holiday.createNew((Set)offices, (JsonCommand)command);
            this.holidayRepository.saveAndFlush(holiday);
            return new CommandProcessingResultBuilder().withCommandId(command.commandId()).withEntityId((Long)holiday.getId()).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleDataIntegrityIssues(command, throwable, (Exception)((Object)dve));
            return CommandProcessingResult.empty();
        }
    }

    @Transactional
    public CommandProcessingResult updateHoliday(JsonCommand command) {
        try {
            Set offices;
            boolean updated;
            this.context.authenticatedUser();
            this.fromApiJsonDeserializer.validateForUpdate(command.json());
            Holiday holiday = this.holidayRepository.findOneWithNotFoundDetection(command.entityId());
            Map changes = holiday.update(command);
            this.validateInputDates(holiday.getFromDate(), holiday.getToDate(), holiday.getRepaymentsRescheduledTo());
            if (changes.containsKey("offices") && !(updated = holiday.update(offices = this.getSelectedOffices(command)))) {
                changes.remove("offices");
            }
            this.holidayRepository.saveAndFlush(holiday);
            return new CommandProcessingResultBuilder().withEntityId((Long)holiday.getId()).with(changes).build();
        }
        catch (DataIntegrityViolationException | JpaSystemException dve) {
            this.handleDataIntegrityIssues(command, dve.getMostSpecificCause(), (Exception)dve);
            return CommandProcessingResult.empty();
        }
        catch (PersistenceException dve) {
            Throwable throwable = ExceptionUtils.getRootCause((Throwable)dve.getCause());
            this.handleDataIntegrityIssues(command, throwable, (Exception)((Object)dve));
            return CommandProcessingResult.empty();
        }
    }

    @Transactional
    public CommandProcessingResult activateHoliday(Long holidayId) {
        this.context.authenticatedUser();
        Holiday holiday = this.holidayRepository.findOneWithNotFoundDetection(holidayId);
        holiday.activate();
        this.holidayRepository.saveAndFlush(holiday);
        return new CommandProcessingResultBuilder().withEntityId((Long)holiday.getId()).build();
    }

    @Transactional
    public CommandProcessingResult deleteHoliday(Long holidayId) {
        this.context.authenticatedUser();
        Holiday holiday = this.holidayRepository.findOneWithNotFoundDetection(holidayId);
        holiday.delete();
        this.holidayRepository.saveAndFlush(holiday);
        return new CommandProcessingResultBuilder().withEntityId(holidayId).build();
    }

    private Set<Office> getSelectedOffices(JsonCommand command) {
        HashSet<Office> offices = null;
        JsonObject topLevelJsonElement = this.fromApiJsonHelper.parse(command.json()).getAsJsonObject();
        if (topLevelJsonElement.has("offices") && topLevelJsonElement.get("offices").isJsonArray()) {
            JsonArray array = topLevelJsonElement.get("offices").getAsJsonArray();
            offices = new HashSet<Office>(array.size());
            for (int i = 0; i < array.size(); ++i) {
                JsonObject officeElement = array.get(i).getAsJsonObject();
                Long officeId = this.fromApiJsonHelper.extractLongNamed("officeId", (JsonElement)officeElement);
                Office office = this.officeRepositoryWrapper.findOneWithNotFoundDetection(officeId);
                offices.add(office);
            }
        }
        return offices;
    }

    private void handleDataIntegrityIssues(JsonCommand command, Throwable realCause, Exception dve) {
        if (realCause.getMessage().contains("holiday_name")) {
            String name = command.stringValueOfParameterNamed("name");
            throw new PlatformDataIntegrityException("error.msg.holiday.duplicate.name", "Holiday with name `" + name + "` already exists", "name", new Object[]{name});
        }
        log.error("Error occured.", (Throwable)dve);
        throw ErrorHandler.getMappable((Throwable)dve, (String)"error.msg.office.unknown.data.integrity.issue", (String)("Unknown data integrity issue with resource: " + realCause.getMessage()));
    }

    private void validateInputDates(JsonCommand command) {
        LocalDate fromDate = command.localDateValueOfParameterNamed("fromDate");
        LocalDate toDate = command.localDateValueOfParameterNamed("toDate");
        Integer reshedulingType = null;
        if (command.parameterExists("reschedulingType")) {
            reshedulingType = command.integerValueOfParameterNamed("reschedulingType");
        }
        LocalDate repaymentsRescheduledTo = null;
        if (reshedulingType != null && reshedulingType.equals(2)) {
            repaymentsRescheduledTo = command.localDateValueOfParameterNamed("repaymentsRescheduledTo");
        }
        if (repaymentsRescheduledTo != null) {
            this.validateInputDates(fromDate, toDate, repaymentsRescheduledTo);
        }
    }

    private void validateInputDates(LocalDate fromDate, LocalDate toDate, LocalDate repaymentsRescheduledTo) {
        String defaultUserMessage = "";
        if (DateUtils.isBefore((LocalDate)toDate, (LocalDate)fromDate)) {
            defaultUserMessage = "To Date date cannot be before the From Date.";
            throw new HolidayDateException("to.date.cannot.be.before.from.date", defaultUserMessage, new Object[]{fromDate.toString(), toDate.toString()});
        }
        if (repaymentsRescheduledTo != null) {
            if (!DateUtils.isBefore((LocalDate)repaymentsRescheduledTo, (LocalDate)fromDate) && !DateUtils.isAfter((LocalDate)repaymentsRescheduledTo, (LocalDate)toDate)) {
                defaultUserMessage = "Repayments rescheduled date should be before from date or after to date.";
                throw new HolidayDateException("repayments.rescheduled.date.should.be.before.from.date.or.after.to.date", defaultUserMessage, new Object[]{repaymentsRescheduledTo.toString()});
            }
            WorkingDays workingDays = this.daysRepositoryWrapper.findOne();
            Boolean isRepaymentOnWorkingDay = WorkingDaysUtil.isWorkingDay((WorkingDays)workingDays, (LocalDate)repaymentsRescheduledTo);
            if (!isRepaymentOnWorkingDay.booleanValue()) {
                defaultUserMessage = "Repayments rescheduled date should not fall on non working days";
                throw new HolidayDateException("repayments.rescheduled.date.should.not.fall.on.non.working.day", defaultUserMessage, new Object[]{repaymentsRescheduledTo.toString()});
            }
            if (DateUtils.isBefore((LocalDate)repaymentsRescheduledTo, (LocalDate)fromDate.minusDays(30L)) || DateUtils.isAfter((LocalDate)repaymentsRescheduledTo, (LocalDate)toDate.plusDays(30L))) {
                defaultUserMessage = "Repayments Rescheduled to date must be within 30 days before or after from and to dates";
                throw new HolidayDateException("repayments.rescheduled.to.must.be.within.range", defaultUserMessage, new Object[]{fromDate.toString(), toDate.toString(), repaymentsRescheduledTo.toString()});
            }
        }
    }

    @Generated
    public HolidayWritePlatformServiceJpaRepositoryImpl(HolidayDataValidator fromApiJsonDeserializer, HolidayRepositoryWrapper holidayRepository, WorkingDaysRepositoryWrapper daysRepositoryWrapper, PlatformSecurityContext context, OfficeRepositoryWrapper officeRepositoryWrapper, FromJsonHelper fromApiJsonHelper) {
        this.fromApiJsonDeserializer = fromApiJsonDeserializer;
        this.holidayRepository = holidayRepository;
        this.daysRepositoryWrapper = daysRepositoryWrapper;
        this.context = context;
        this.officeRepositoryWrapper = officeRepositoryWrapper;
        this.fromApiJsonHelper = fromApiJsonHelper;
    }
}

