/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.interoperation.serialization;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import jakarta.validation.constraints.NotNull;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.apache.fineract.interoperation.data.InteropIdentifierRequestData;
import org.apache.fineract.interoperation.data.InteropQuoteRequestData;
import org.apache.fineract.interoperation.data.InteropTransactionRequestData;
import org.apache.fineract.interoperation.data.InteropTransferRequestData;
import org.apache.fineract.interoperation.domain.InteropIdentifierType;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class InteropDataValidator {
    private final FromJsonHelper jsonHelper;

    @Autowired
    public InteropDataValidator(FromJsonHelper fromJsonHelper) {
        this.jsonHelper = fromJsonHelper;
    }

    public InteropTransferRequestData validateAndParseTransferRequest(JsonCommand command) {
        DataValidatorBuilder dataValidator = new DataValidatorBuilder(new ArrayList()).resource("interoperation.transfer");
        JsonObject element = this.extractJsonObject(command);
        InteropTransferRequestData result = InteropTransferRequestData.validateAndParse((DataValidatorBuilder)dataValidator, (JsonObject)element, (FromJsonHelper)this.jsonHelper);
        this.throwExceptionIfValidationWarningsExist(dataValidator);
        return result;
    }

    public InteropIdentifierRequestData validateAndParseCreateIdentifier(@NotNull InteropIdentifierType idType, @NotNull String idValue, String subIdOrType, JsonCommand command) {
        DataValidatorBuilder dataValidator = new DataValidatorBuilder(new ArrayList()).resource("interoperation.identifier");
        JsonObject element = this.extractJsonObject(command);
        InteropIdentifierRequestData result = InteropIdentifierRequestData.validateAndParse((DataValidatorBuilder)dataValidator, (InteropIdentifierType)idType, (String)idValue, (String)subIdOrType, (JsonObject)element, (FromJsonHelper)this.jsonHelper);
        this.throwExceptionIfValidationWarningsExist(dataValidator);
        return result;
    }

    public InteropTransactionRequestData validateAndParseCreateRequest(JsonCommand command) {
        DataValidatorBuilder dataValidator = new DataValidatorBuilder(new ArrayList()).resource("interoperation.request");
        JsonObject element = this.extractJsonObject(command);
        InteropTransactionRequestData result = InteropTransactionRequestData.validateAndParse((DataValidatorBuilder)dataValidator, (JsonObject)element, (FromJsonHelper)this.jsonHelper);
        this.throwExceptionIfValidationWarningsExist(dataValidator);
        return result;
    }

    public InteropQuoteRequestData validateAndParseCreateQuote(JsonCommand command) {
        DataValidatorBuilder dataValidator = new DataValidatorBuilder(new ArrayList()).resource("interoperation.quote");
        JsonObject element = this.extractJsonObject(command);
        InteropQuoteRequestData result = InteropQuoteRequestData.validateAndParse((DataValidatorBuilder)dataValidator, (JsonObject)element, (FromJsonHelper)this.jsonHelper);
        this.throwExceptionIfValidationWarningsExist(dataValidator);
        return result;
    }

    public InteropTransferRequestData validateAndParsePrepareTransfer(JsonCommand command) {
        return this.validateAndParseCreateTransfer(command);
    }

    public InteropTransferRequestData validateAndParseCreateTransfer(JsonCommand command) {
        DataValidatorBuilder dataValidator = new DataValidatorBuilder(new ArrayList()).resource("interoperation.transfer");
        JsonObject element = this.extractJsonObject(command);
        InteropTransferRequestData result = InteropTransferRequestData.validateAndParse((DataValidatorBuilder)dataValidator, (JsonObject)element, (FromJsonHelper)this.jsonHelper);
        this.throwExceptionIfValidationWarningsExist(dataValidator);
        return result;
    }

    private JsonObject extractJsonObject(JsonCommand command) {
        String json = command.json();
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        JsonElement element = this.jsonHelper.parse(json);
        return element.getAsJsonObject();
    }

    private void throwExceptionIfValidationWarningsExist(DataValidatorBuilder dataValidator) {
        if (dataValidator.hasError()) {
            throw new PlatformApiDataValidationException("validation.msg.validation.errors.exist", "Validation errors exist.", dataValidator.getDataValidationErrors());
        }
    }
}

