/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.springbatch.messagehandler.kafka;

import lombok.Generated;
import org.apache.fineract.infrastructure.springbatch.ContextualMessage;
import org.apache.fineract.infrastructure.springbatch.InputChannelInterceptor;
import org.apache.fineract.infrastructure.springbatch.messagehandler.StepExecutionRequestHandler;
import org.apache.fineract.infrastructure.springbatch.messagehandler.conditions.kafka.KafkaWorkerCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.integration.partition.StepExecutionRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.messaging.handler.annotation.Payload;
import org.springframework.stereotype.Component;

@Component
@Conditional(value={KafkaWorkerCondition.class})
public class KafkaRemoteMessageListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(KafkaRemoteMessageListener.class);
    @Autowired
    private StepExecutionRequestHandler stepExecutionRequestHandler;
    @Autowired
    private InputChannelInterceptor inputInterceptor;

    @KafkaListener(topics={"${fineract.remote-job-message-handler.kafka.topic.name}"})
    public void onMessage(@Payload ContextualMessage contextualMessage, Acknowledgment acknowledgment) {
        try {
            log.debug("Received Kafka partition message {}", (Object)contextualMessage);
            StepExecutionRequest stepExecutionRequest = this.inputInterceptor.beforeHandleMessage(contextualMessage);
            this.stepExecutionRequestHandler.handle(stepExecutionRequest);
        }
        catch (Exception e) {
            log.error("Exception while processing Kafka message", (Throwable)e);
        }
        acknowledgment.acknowledge();
        log.debug("Message was acknowledged {}", (Object)acknowledgment);
    }
}

