/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.jobs.service.aggregationjob.tasklet;

import java.time.LocalDate;
import java.util.Optional;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil;
import org.apache.fineract.infrastructure.jobs.service.aggregationjob.data.JournalEntryAggregationTrackingData;
import org.apache.fineract.infrastructure.jobs.service.aggregationjob.services.JournalEntryAggregationWriterService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Component
public class JournalEntryAggregationTrackingTasklet
implements Tasklet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(JournalEntryAggregationTrackingTasklet.class);
    private final JournalEntryAggregationWriterService journalEntryAggregationWriterService;

    public RepeatStatus execute(StepContribution contribution, @NonNull ChunkContext chunkContext) throws Exception {
        Optional<StepExecution> jobSummaryStepExecution = contribution.getStepExecution().getJobExecution().getStepExecutions().stream().filter(stepExecution -> stepExecution.getStepName().equals("JournalEntryAggregation Summary Insert - Step")).findFirst();
        long writeCount = jobSummaryStepExecution.map(StepExecution::getWriteCount).orElse(0L);
        log.info("Starting journal entry aggregation tasklet to insert into tracking table writeCount={}", (Object)writeCount);
        if (writeCount > 0L) {
            JobExecution jobExecutionContext = chunkContext.getStepContext().getStepExecution().getJobExecution();
            LocalDate aggregatedOnDateFrom = (LocalDate)jobExecutionContext.getExecutionContext().get("aggregatedOnDateFrom");
            LocalDate aggregatedOnDateTo = (LocalDate)jobExecutionContext.getExecutionContext().get("aggregatedOnDateTo");
            JournalEntryAggregationTrackingData journalEntrySummaryTrackingDTO = JournalEntryAggregationTrackingData.builder().submittedOnDate(ThreadLocalContextUtil.getBusinessDate()).aggregatedOnDateFrom(aggregatedOnDateFrom).aggregatedOnDateTo(aggregatedOnDateTo).jobExecutionId(contribution.getStepExecution().getJobExecution().getId()).build();
            this.journalEntryAggregationWriterService.insertJournalEntryTracking(journalEntrySummaryTrackingDTO);
        }
        return RepeatStatus.FINISHED;
    }

    @Generated
    public JournalEntryAggregationTrackingTasklet(JournalEntryAggregationWriterService journalEntryAggregationWriterService) {
        this.journalEntryAggregationWriterService = journalEntryAggregationWriterService;
    }
}

