/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.jobs.domain;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.Table;
import jakarta.persistence.Temporal;
import jakarta.persistence.TemporalType;
import jakarta.persistence.UniqueConstraint;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;

@Entity
@Table(name="job", uniqueConstraints={@UniqueConstraint(columnNames={"short_name"}, name="job_short_name_key")})
public class ScheduledJobDetail
extends AbstractPersistableCustom<Long> {
    @Column(name="name")
    private String jobName;
    @Column(name="display_name")
    private String jobDisplayName;
    @Column(name="node_id")
    private Integer nodeId;
    @Column(name="is_mismatched_job")
    private boolean isMismatchedJob;
    @Column(name="cron_expression")
    private String cronExpression;
    @Column(name="create_time")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date createTime;
    @Column(name="task_priority")
    private Short taskPriority;
    @Column(name="group_name")
    private String groupName;
    @Column(name="previous_run_start_time")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date previousRunStartTime;
    @Column(name="next_run_time")
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date nextRunTime;
    @Column(name="job_key")
    private String jobKey;
    @Column(name="initializing_errorlog")
    private String errorLog;
    @Column(name="is_active")
    private boolean activeSchedular;
    @Column(name="currently_running")
    private boolean currentlyRunning;
    @Column(name="updates_allowed")
    private boolean updatesAllowed;
    @Column(name="scheduler_group")
    private Short schedulerGroup;
    @Column(name="is_misfired")
    private boolean triggerMisfired;
    @Column(name="short_name", nullable=false)
    private String shortName;

    public Map<String, Object> update(JsonCommand command) {
        String newValue;
        LinkedHashMap<String, Object> actualChanges = new LinkedHashMap<String, Object>(9);
        if (command.isChangeInStringParameterNamed("displayName", this.jobDisplayName)) {
            newValue = command.stringValueOfParameterNamed("displayName").trim();
            actualChanges.put("displayName", newValue);
            this.jobDisplayName = (String)StringUtils.defaultIfEmpty((CharSequence)newValue, null);
        }
        if (command.isChangeInStringParameterNamed("cronExpression", this.cronExpression)) {
            newValue = command.stringValueOfParameterNamed("cronExpression").trim();
            actualChanges.put("cronExpression", newValue);
            this.cronExpression = (String)StringUtils.defaultIfEmpty((CharSequence)newValue, null);
        }
        if (command.isChangeInBooleanParameterNamed("active", Boolean.valueOf(this.activeSchedular))) {
            boolean newValue2 = command.booleanPrimitiveValueOfParameterNamed("active");
            actualChanges.put("active", newValue2);
            this.activeSchedular = newValue2;
        }
        return actualChanges;
    }

    @Generated
    public String getJobName() {
        return this.jobName;
    }

    @Generated
    public String getJobDisplayName() {
        return this.jobDisplayName;
    }

    @Generated
    public Integer getNodeId() {
        return this.nodeId;
    }

    @Generated
    public boolean isMismatchedJob() {
        return this.isMismatchedJob;
    }

    @Generated
    public String getCronExpression() {
        return this.cronExpression;
    }

    @Generated
    public Date getCreateTime() {
        return this.createTime;
    }

    @Generated
    public Short getTaskPriority() {
        return this.taskPriority;
    }

    @Generated
    public String getGroupName() {
        return this.groupName;
    }

    @Generated
    public Date getPreviousRunStartTime() {
        return this.previousRunStartTime;
    }

    @Generated
    public Date getNextRunTime() {
        return this.nextRunTime;
    }

    @Generated
    public String getJobKey() {
        return this.jobKey;
    }

    @Generated
    public String getErrorLog() {
        return this.errorLog;
    }

    @Generated
    public boolean isActiveSchedular() {
        return this.activeSchedular;
    }

    @Generated
    public boolean isCurrentlyRunning() {
        return this.currentlyRunning;
    }

    @Generated
    public boolean isUpdatesAllowed() {
        return this.updatesAllowed;
    }

    @Generated
    public Short getSchedulerGroup() {
        return this.schedulerGroup;
    }

    @Generated
    public boolean isTriggerMisfired() {
        return this.triggerMisfired;
    }

    @Generated
    public String getShortName() {
        return this.shortName;
    }

    @Generated
    public ScheduledJobDetail setJobName(String jobName) {
        this.jobName = jobName;
        return this;
    }

    @Generated
    public ScheduledJobDetail setJobDisplayName(String jobDisplayName) {
        this.jobDisplayName = jobDisplayName;
        return this;
    }

    @Generated
    public ScheduledJobDetail setNodeId(Integer nodeId) {
        this.nodeId = nodeId;
        return this;
    }

    @Generated
    public ScheduledJobDetail setMismatchedJob(boolean isMismatchedJob) {
        this.isMismatchedJob = isMismatchedJob;
        return this;
    }

    @Generated
    public ScheduledJobDetail setCronExpression(String cronExpression) {
        this.cronExpression = cronExpression;
        return this;
    }

    @Generated
    public ScheduledJobDetail setCreateTime(Date createTime) {
        this.createTime = createTime;
        return this;
    }

    @Generated
    public ScheduledJobDetail setTaskPriority(Short taskPriority) {
        this.taskPriority = taskPriority;
        return this;
    }

    @Generated
    public ScheduledJobDetail setGroupName(String groupName) {
        this.groupName = groupName;
        return this;
    }

    @Generated
    public ScheduledJobDetail setPreviousRunStartTime(Date previousRunStartTime) {
        this.previousRunStartTime = previousRunStartTime;
        return this;
    }

    @Generated
    public ScheduledJobDetail setNextRunTime(Date nextRunTime) {
        this.nextRunTime = nextRunTime;
        return this;
    }

    @Generated
    public ScheduledJobDetail setJobKey(String jobKey) {
        this.jobKey = jobKey;
        return this;
    }

    @Generated
    public ScheduledJobDetail setErrorLog(String errorLog) {
        this.errorLog = errorLog;
        return this;
    }

    @Generated
    public ScheduledJobDetail setActiveSchedular(boolean activeSchedular) {
        this.activeSchedular = activeSchedular;
        return this;
    }

    @Generated
    public ScheduledJobDetail setCurrentlyRunning(boolean currentlyRunning) {
        this.currentlyRunning = currentlyRunning;
        return this;
    }

    @Generated
    public ScheduledJobDetail setUpdatesAllowed(boolean updatesAllowed) {
        this.updatesAllowed = updatesAllowed;
        return this;
    }

    @Generated
    public ScheduledJobDetail setSchedulerGroup(Short schedulerGroup) {
        this.schedulerGroup = schedulerGroup;
        return this;
    }

    @Generated
    public ScheduledJobDetail setTriggerMisfired(boolean triggerMisfired) {
        this.triggerMisfired = triggerMisfired;
        return this;
    }

    @Generated
    public ScheduledJobDetail setShortName(String shortName) {
        this.shortName = shortName;
        return this;
    }

    @Generated
    public ScheduledJobDetail() {
    }
}

