/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.jobs.api;

import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import lombok.Generated;
import org.apache.fineract.cob.data.LoanIdsResponseDTO;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.core.data.CommandProcessingResult;
import org.apache.fineract.infrastructure.core.serialization.DefaultToApiJsonSerializer;
import org.apache.fineract.infrastructure.jobs.api.InlineJobResourceSwagger;
import org.springframework.stereotype.Component;

@Path(value="/v1/jobs")
@Component
@Tag(name="Inline Job", description="")
public class InlineJobApiResource {
    private final PortfolioCommandSourceWritePlatformService commandWritePlatformService;
    private final DefaultToApiJsonSerializer<LoanIdsResponseDTO> serializer;

    @POST
    @Path(value="{jobName}/inline")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @Operation(summary="Starts an inline Job", description="Starts an inline Job")
    @RequestBody(content={@Content(schema=@Schema(implementation=InlineJobResourceSwagger.InlineJobRequest.class))})
    @ApiResponses(value={@ApiResponse(responseCode="200", description="OK", content={@Content(schema=@Schema(implementation=InlineJobResourceSwagger.InlineJobResponse.class))}), @ApiResponse(responseCode="400", description="Request body item size validation error")})
    public String executeInlineJob(@PathParam(value="jobName") @Parameter(description="jobName") String jobName, @Parameter(hidden=true) String jsonRequestBody) {
        CommandWrapper commandRequest = new CommandWrapperBuilder().executeInlineJob(jobName).withJson(jsonRequestBody).build();
        CommandProcessingResult result = this.commandWritePlatformService.logCommandSource(commandRequest);
        return this.serializer.serialize((Object)result);
    }

    @Generated
    public InlineJobApiResource(PortfolioCommandSourceWritePlatformService commandWritePlatformService, DefaultToApiJsonSerializer<LoanIdsResponseDTO> serializer) {
        this.commandWritePlatformService = commandWritePlatformService;
        this.serializer = serializer;
    }
}

