/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.event.external.service.serialization.serializer.loan;

import java.util.List;
import lombok.Generated;
import org.apache.avro.generic.GenericContainer;
import org.apache.fineract.avro.generator.ByteBufferSerializable;
import org.apache.fineract.avro.loan.v1.LoanProductDataV1;
import org.apache.fineract.infrastructure.event.business.domain.BusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.product.LoanProductBusinessEvent;
import org.apache.fineract.infrastructure.event.external.service.serialization.mapper.loan.LoanProductDataMapper;
import org.apache.fineract.infrastructure.event.external.service.serialization.serializer.AbstractBusinessEventWithCustomDataSerializer;
import org.apache.fineract.infrastructure.event.external.service.serialization.serializer.ExternalEventCustomDataSerializer;
import org.apache.fineract.portfolio.loanproduct.data.LoanProductData;
import org.apache.fineract.portfolio.loanproduct.domain.LoanProduct;
import org.apache.fineract.portfolio.loanproduct.service.LoanProductReadPlatformService;
import org.springframework.stereotype.Component;

@Component
public class LoanProductBusinessEventSerializer
extends AbstractBusinessEventWithCustomDataSerializer<LoanProductBusinessEvent> {
    private final LoanProductReadPlatformService service;
    private final LoanProductDataMapper mapper;
    private final List<ExternalEventCustomDataSerializer<LoanProductBusinessEvent>> externalEventCustomDataSerializers;

    public <T> boolean canSerialize(BusinessEvent<T> event) {
        return event instanceof LoanProductBusinessEvent;
    }

    public <T> ByteBufferSerializable toAvroDTO(BusinessEvent<T> rawEvent) {
        LoanProductBusinessEvent event = (LoanProductBusinessEvent)rawEvent;
        LoanProductData data = this.service.retrieveLoanProduct((Long)((LoanProduct)event.get()).getId());
        LoanProductDataV1 loanProductDataV1 = this.mapper.map(data);
        loanProductDataV1.setCustomData(this.collectCustomData((BusinessEvent)event));
        return loanProductDataV1;
    }

    public Class<? extends GenericContainer> getSupportedSchema() {
        return LoanProductDataV1.class;
    }

    protected List<ExternalEventCustomDataSerializer<LoanProductBusinessEvent>> getExternalEventCustomDataSerializers() {
        return this.externalEventCustomDataSerializers;
    }

    @Generated
    public LoanProductBusinessEventSerializer(LoanProductReadPlatformService service, LoanProductDataMapper mapper, List<ExternalEventCustomDataSerializer<LoanProductBusinessEvent>> externalEventCustomDataSerializers) {
        this.service = service;
        this.mapper = mapper;
        this.externalEventCustomDataSerializers = externalEventCustomDataSerializers;
    }
}

